/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import io.trino.cost.StatsAndCosts;
import io.trino.execution.scheduler.SchedulingUtils;
import io.trino.operator.RetryPolicy;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.RemoteSourceNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.StringLiteral;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSchedulingUtils {
    @Test
    public void testCanStreamNoJoin() {
        SubPlan parentSubPlan = TestSchedulingUtils.createSubPlan("parent", (PlanNode)TestSchedulingUtils.remoteSource("a"), (List<SubPlan>)ImmutableList.of((Object)TestSchedulingUtils.valuesSubPlan("a")));
        Assertions.assertThat((boolean)SchedulingUtils.canStream((SubPlan)parentSubPlan, (SubPlan)TestSchedulingUtils.valuesSubPlan("a"))).isTrue();
    }

    @Test
    public void testCanStreamJoin() {
        SubPlan aSubPlan = TestSchedulingUtils.valuesSubPlan("a");
        RemoteSourceNode remoteSourceA = TestSchedulingUtils.remoteSource("a");
        SubPlan bSubPlan = TestSchedulingUtils.valuesSubPlan("b");
        RemoteSourceNode remoteSourceB = TestSchedulingUtils.remoteSource("b");
        SubPlan parentSubPlan = TestSchedulingUtils.createSubPlan("parent", (PlanNode)TestSchedulingUtils.join("join", (PlanNode)remoteSourceA, (PlanNode)remoteSourceB), (List<SubPlan>)ImmutableList.of((Object)aSubPlan, (Object)bSubPlan));
        Assertions.assertThat((boolean)SchedulingUtils.canStream((SubPlan)parentSubPlan, (SubPlan)aSubPlan)).isTrue();
        Assertions.assertThat((boolean)SchedulingUtils.canStream((SubPlan)parentSubPlan, (SubPlan)bSubPlan)).isFalse();
    }

    @Test
    public void testCanStreamTwoJoins() {
        SubPlan aSubPlan = TestSchedulingUtils.valuesSubPlan("a");
        RemoteSourceNode remoteSourceA = TestSchedulingUtils.remoteSource("a");
        SubPlan bSubPlan = TestSchedulingUtils.valuesSubPlan("b");
        RemoteSourceNode remoteSourceB = TestSchedulingUtils.remoteSource("b");
        SubPlan cSubPlan = TestSchedulingUtils.valuesSubPlan("c");
        RemoteSourceNode remoteSourceC = TestSchedulingUtils.remoteSource("c");
        SubPlan parentSubPlan = TestSchedulingUtils.createSubPlan("parent", (PlanNode)TestSchedulingUtils.join("join1", (PlanNode)remoteSourceA, (PlanNode)TestSchedulingUtils.join("join2", (PlanNode)remoteSourceB, (PlanNode)remoteSourceC)), (List<SubPlan>)ImmutableList.of((Object)bSubPlan, (Object)cSubPlan, (Object)aSubPlan));
        Assertions.assertThat((boolean)SchedulingUtils.canStream((SubPlan)parentSubPlan, (SubPlan)aSubPlan)).isTrue();
        Assertions.assertThat((boolean)SchedulingUtils.canStream((SubPlan)parentSubPlan, (SubPlan)bSubPlan)).isFalse();
        Assertions.assertThat((boolean)SchedulingUtils.canStream((SubPlan)parentSubPlan, (SubPlan)cSubPlan)).isFalse();
    }

    @Test
    public void testCanStreamJoinWithUnion() {
        SubPlan aSubPlan = TestSchedulingUtils.valuesSubPlan("a");
        RemoteSourceNode remoteSourceA = TestSchedulingUtils.remoteSource("a");
        SubPlan bSubPlan = TestSchedulingUtils.valuesSubPlan("b");
        RemoteSourceNode remoteSourceB = TestSchedulingUtils.remoteSource("b");
        SubPlan cSubPlan = TestSchedulingUtils.valuesSubPlan("c");
        RemoteSourceNode remoteSourceC = TestSchedulingUtils.remoteSource("c");
        SubPlan dSubPlan = TestSchedulingUtils.valuesSubPlan("d");
        RemoteSourceNode remoteSourceD = TestSchedulingUtils.remoteSource("d");
        UnionNode union1 = TestSchedulingUtils.union("union1", (List<PlanNode>)ImmutableList.of((Object)remoteSourceA, (Object)remoteSourceB));
        UnionNode union2 = TestSchedulingUtils.union("union2", (List<PlanNode>)ImmutableList.of((Object)remoteSourceC, (Object)remoteSourceD));
        SubPlan parentSubPlan = TestSchedulingUtils.createSubPlan("parent", (PlanNode)TestSchedulingUtils.join("join", (PlanNode)union1, (PlanNode)union2), (List<SubPlan>)ImmutableList.of((Object)bSubPlan, (Object)cSubPlan, (Object)aSubPlan, (Object)dSubPlan));
        Assertions.assertThat((boolean)SchedulingUtils.canStream((SubPlan)parentSubPlan, (SubPlan)aSubPlan)).isTrue();
        Assertions.assertThat((boolean)SchedulingUtils.canStream((SubPlan)parentSubPlan, (SubPlan)bSubPlan)).isTrue();
        Assertions.assertThat((boolean)SchedulingUtils.canStream((SubPlan)parentSubPlan, (SubPlan)cSubPlan)).isFalse();
        Assertions.assertThat((boolean)SchedulingUtils.canStream((SubPlan)parentSubPlan, (SubPlan)dSubPlan)).isFalse();
    }

    @Test
    public void testCanStreamJoinMultipleSubPlanPerRemoteSource() {
        SubPlan aSubPlan = TestSchedulingUtils.valuesSubPlan("a");
        SubPlan bSubPlan = TestSchedulingUtils.valuesSubPlan("b");
        RemoteSourceNode remoteSourceAB = TestSchedulingUtils.remoteSource((List<String>)ImmutableList.of((Object)"a", (Object)"b"));
        SubPlan cSubPlan = TestSchedulingUtils.valuesSubPlan("c");
        SubPlan dSubPlan = TestSchedulingUtils.valuesSubPlan("d");
        RemoteSourceNode remoteSourceCD = TestSchedulingUtils.remoteSource((List<String>)ImmutableList.of((Object)"c", (Object)"d"));
        SubPlan parentSubPlan = TestSchedulingUtils.createSubPlan("parent", (PlanNode)TestSchedulingUtils.join("join", (PlanNode)remoteSourceAB, (PlanNode)remoteSourceCD), (List<SubPlan>)ImmutableList.of((Object)bSubPlan, (Object)cSubPlan, (Object)aSubPlan, (Object)dSubPlan));
        Assertions.assertThat((boolean)SchedulingUtils.canStream((SubPlan)parentSubPlan, (SubPlan)aSubPlan)).isTrue();
        Assertions.assertThat((boolean)SchedulingUtils.canStream((SubPlan)parentSubPlan, (SubPlan)bSubPlan)).isTrue();
        Assertions.assertThat((boolean)SchedulingUtils.canStream((SubPlan)parentSubPlan, (SubPlan)cSubPlan)).isFalse();
        Assertions.assertThat((boolean)SchedulingUtils.canStream((SubPlan)parentSubPlan, (SubPlan)dSubPlan)).isFalse();
    }

    @Test
    public void testCanStreamSemiJoin() {
        SubPlan aSubPlan = TestSchedulingUtils.valuesSubPlan("a");
        RemoteSourceNode remoteSourceA = TestSchedulingUtils.remoteSource("a");
        SubPlan bSubPlan = TestSchedulingUtils.valuesSubPlan("b");
        RemoteSourceNode remoteSourceB = TestSchedulingUtils.remoteSource("b");
        SubPlan parentSubPlan = TestSchedulingUtils.createSubPlan("parent", (PlanNode)TestSchedulingUtils.semiJoin("semijoin", (PlanNode)remoteSourceA, (PlanNode)remoteSourceB), (List<SubPlan>)ImmutableList.of((Object)aSubPlan, (Object)bSubPlan));
        Assertions.assertThat((boolean)SchedulingUtils.canStream((SubPlan)parentSubPlan, (SubPlan)aSubPlan)).isTrue();
        Assertions.assertThat((boolean)SchedulingUtils.canStream((SubPlan)parentSubPlan, (SubPlan)bSubPlan)).isFalse();
    }

    @Test
    public void testCanStreamIndexJoin() {
        SubPlan aSubPlan = TestSchedulingUtils.valuesSubPlan("a");
        RemoteSourceNode remoteSourceA = TestSchedulingUtils.remoteSource("a");
        SubPlan bSubPlan = TestSchedulingUtils.valuesSubPlan("b");
        RemoteSourceNode remoteSourceB = TestSchedulingUtils.remoteSource("b");
        SubPlan parentSubPlan = TestSchedulingUtils.createSubPlan("parent", (PlanNode)TestSchedulingUtils.indexJoin("indexjoin", (PlanNode)remoteSourceA, (PlanNode)remoteSourceB), (List<SubPlan>)ImmutableList.of((Object)aSubPlan, (Object)bSubPlan));
        Assertions.assertThat((boolean)SchedulingUtils.canStream((SubPlan)parentSubPlan, (SubPlan)aSubPlan)).isTrue();
        Assertions.assertThat((boolean)SchedulingUtils.canStream((SubPlan)parentSubPlan, (SubPlan)bSubPlan)).isFalse();
    }

    @Test
    public void testCanStreamSpatialJoin() {
        SubPlan aSubPlan = TestSchedulingUtils.valuesSubPlan("a");
        RemoteSourceNode remoteSourceA = TestSchedulingUtils.remoteSource("a");
        SubPlan bSubPlan = TestSchedulingUtils.valuesSubPlan("b");
        RemoteSourceNode remoteSourceB = TestSchedulingUtils.remoteSource("b");
        SubPlan parentSubPlan = TestSchedulingUtils.createSubPlan("parent", (PlanNode)TestSchedulingUtils.spatialJoin("spatialjoin", (PlanNode)remoteSourceA, (PlanNode)remoteSourceB), (List<SubPlan>)ImmutableList.of((Object)aSubPlan, (Object)bSubPlan));
        Assertions.assertThat((boolean)SchedulingUtils.canStream((SubPlan)parentSubPlan, (SubPlan)aSubPlan)).isTrue();
        Assertions.assertThat((boolean)SchedulingUtils.canStream((SubPlan)parentSubPlan, (SubPlan)bSubPlan)).isFalse();
    }

    private static RemoteSourceNode remoteSource(String fragmentId) {
        return TestSchedulingUtils.remoteSource((List<String>)ImmutableList.of((Object)fragmentId));
    }

    private static RemoteSourceNode remoteSource(List<String> fragmentIds) {
        return new RemoteSourceNode(new PlanNodeId(fragmentIds.get(0)), (List)fragmentIds.stream().map(PlanFragmentId::new).collect(ImmutableList.toImmutableList()), (List)ImmutableList.of((Object)new Symbol("blah")), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.TASK);
    }

    private static JoinNode join(String id, PlanNode left, PlanNode right) {
        return new JoinNode(new PlanNodeId(id), JoinNode.Type.INNER, left, right, (List)ImmutableList.of(), left.getOutputSymbols(), right.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
    }

    private static SemiJoinNode semiJoin(String id, PlanNode left, PlanNode right) {
        return new SemiJoinNode(new PlanNodeId(id), left, right, (Symbol)left.getOutputSymbols().get(0), (Symbol)right.getOutputSymbols().get(0), new Symbol(id), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static IndexJoinNode indexJoin(String id, PlanNode left, PlanNode right) {
        return new IndexJoinNode(new PlanNodeId(id), IndexJoinNode.Type.INNER, left, right, (List)ImmutableList.of(), Optional.empty(), Optional.empty());
    }

    private static SpatialJoinNode spatialJoin(String id, PlanNode left, PlanNode right) {
        return new SpatialJoinNode(new PlanNodeId(id), SpatialJoinNode.Type.INNER, left, right, left.getOutputSymbols(), (Expression)BooleanLiteral.TRUE_LITERAL, Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static UnionNode union(String id, List<PlanNode> sources) {
        Symbol symbol = new Symbol(id);
        return new UnionNode(new PlanNodeId(id), sources, (ListMultimap)ImmutableListMultimap.of(), (List)ImmutableList.of((Object)symbol));
    }

    private static SubPlan valuesSubPlan(String fragmentId) {
        Symbol symbol = new Symbol("column");
        return TestSchedulingUtils.createSubPlan(fragmentId, (PlanNode)new ValuesNode(new PlanNodeId(fragmentId + "Values"), (List)ImmutableList.of((Object)symbol), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new StringLiteral("foo"))))), (List<SubPlan>)ImmutableList.of());
    }

    private static SubPlan createSubPlan(String fragmentId, PlanNode plan, List<SubPlan> children) {
        Symbol symbol = (Symbol)plan.getOutputSymbols().get(0);
        PlanNodeId valuesNodeId = new PlanNodeId("plan");
        PlanFragment planFragment = new PlanFragment(new PlanFragmentId(fragmentId), plan, (Map)ImmutableMap.of((Object)symbol, (Object)VarcharType.VARCHAR), SystemPartitioningHandle.SOURCE_DISTRIBUTION, Optional.empty(), (List)ImmutableList.of((Object)valuesNodeId), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)symbol)), StatsAndCosts.empty(), (List)ImmutableList.of(), Optional.empty());
        return new SubPlan(planFragment, children);
    }
}

