/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import io.trino.execution.scheduler.faulttolerant.NodeRequirements;
import io.trino.execution.scheduler.faulttolerant.SplitAssigner;
import io.trino.execution.scheduler.faulttolerant.TaskDescriptor;
import io.trino.execution.scheduler.faulttolerant.TestingConnectorSplit;
import io.trino.metadata.Split;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;

class SplitAssignerTester {
    private final Map<Integer, NodeRequirements> nodeRequirements = new HashMap<Integer, NodeRequirements>();
    private final Map<Integer, ListMultimap<PlanNodeId, Split>> splits = new HashMap<Integer, ListMultimap<PlanNodeId, Split>>();
    private final SetMultimap<Integer, PlanNodeId> noMoreSplits = HashMultimap.create();
    private final Set<Integer> sealedPartitions = new HashSet<Integer>();
    private boolean noMorePartitions;
    private Optional<List<TaskDescriptor>> taskDescriptors = Optional.empty();

    SplitAssignerTester() {
    }

    public Optional<List<TaskDescriptor>> getTaskDescriptors() {
        return this.taskDescriptors;
    }

    public synchronized int getPartitionCount() {
        return this.nodeRequirements.size();
    }

    public synchronized NodeRequirements getNodeRequirements(int partition) {
        NodeRequirements result = this.nodeRequirements.get(partition);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"partition not found: %s", (int)partition);
        return result;
    }

    public synchronized Set<Integer> getSplitIds(int partition, PlanNodeId planNodeId) {
        ListMultimap<PlanNodeId, Split> partitionSplits = this.splits.getOrDefault(partition, (ListMultimap<PlanNodeId, Split>)ImmutableListMultimap.of());
        return (Set)partitionSplits.get((Object)planNodeId).stream().map(split -> (TestingConnectorSplit)split.getConnectorSplit()).map(TestingConnectorSplit::getId).collect(ImmutableSet.toImmutableSet());
    }

    public synchronized boolean isNoMoreSplits(int partition, PlanNodeId planNodeId) {
        return this.noMoreSplits.get((Object)partition).contains(planNodeId);
    }

    public synchronized boolean isSealed(int partition) {
        return this.sealedPartitions.contains(partition);
    }

    public synchronized boolean isNoMorePartitions() {
        return this.noMorePartitions;
    }

    public void checkContainsSplits(PlanNodeId planNodeId, Collection<Split> splits, boolean replicated) {
        Set expectedSplitIds = splits.stream().map(TestingConnectorSplit::getSplitId).collect(Collectors.toSet());
        for (int partitionId = 0; partitionId < this.getPartitionCount(); ++partitionId) {
            Set<Integer> partitionSplitIds = this.getSplitIds(partitionId, planNodeId);
            if (replicated) {
                Assertions.assertThat(partitionSplitIds).containsAll(expectedSplitIds);
                continue;
            }
            expectedSplitIds.removeAll(partitionSplitIds);
        }
        if (!replicated) {
            Assertions.assertThat(expectedSplitIds).isEmpty();
        }
    }

    public void update(SplitAssigner.AssignmentResult assignment) {
        for (SplitAssigner.Partition partition : assignment.partitionsAdded()) {
            Verify.verify((!this.noMorePartitions ? 1 : 0) != 0, (String)"noMorePartitions is set", (Object[])new Object[0]);
            Verify.verify((this.nodeRequirements.put(partition.partitionId(), partition.nodeRequirements()) == null ? 1 : 0) != 0, (String)"partition already exist: %s", (int)partition.partitionId());
        }
        for (SplitAssigner.PartitionUpdate partitionUpdate : assignment.partitionUpdates()) {
            int partitionId = partitionUpdate.partitionId();
            Verify.verify((this.nodeRequirements.get(partitionId) != null ? 1 : 0) != 0, (String)"partition does not exist: %s", (int)partitionId);
            Verify.verify((!this.sealedPartitions.contains(partitionId) ? 1 : 0) != 0, (String)"partition is sealed: %s", (int)partitionId);
            PlanNodeId planNodeId = partitionUpdate.planNodeId();
            if (!partitionUpdate.splits().isEmpty()) {
                Verify.verify((!this.noMoreSplits.get((Object)partitionId).contains(planNodeId) ? 1 : 0) != 0, (String)"noMoreSplits is set for partition %s and plan node %s", (int)partitionId, (Object)planNodeId);
                this.splits.computeIfAbsent(partitionId, key -> ArrayListMultimap.create()).putAll((Object)planNodeId, (Iterable)partitionUpdate.splits());
            }
            if (!partitionUpdate.noMoreSplits()) continue;
            this.noMoreSplits.put((Object)partitionId, (Object)planNodeId);
        }
        assignment.sealedPartitions().forEach(this.sealedPartitions::add);
        if (assignment.noMorePartitions()) {
            this.noMorePartitions = true;
        }
        this.checkFinished();
    }

    private synchronized void checkFinished() {
        if (this.noMorePartitions && this.sealedPartitions.containsAll(this.nodeRequirements.keySet())) {
            Verify.verify((boolean)this.sealedPartitions.equals(this.nodeRequirements.keySet()), (String)"unknown sealed partitions: %s", (Object)Sets.difference(this.sealedPartitions, this.nodeRequirements.keySet()));
            ImmutableList.Builder result = ImmutableList.builder();
            for (Integer partitionId : this.sealedPartitions) {
                ListMultimap<PlanNodeId, Split> taskSplits = this.splits.getOrDefault(partitionId, (ListMultimap<PlanNodeId, Split>)ImmutableListMultimap.of());
                Verify.verify((boolean)this.noMoreSplits.get((Object)partitionId).containsAll(taskSplits.keySet()), (String)"no more split is missing for partition %s: %s", (Object)partitionId, (Object)Sets.difference((Set)taskSplits.keySet(), (Set)this.noMoreSplits.get((Object)partitionId)));
                result.add((Object)new TaskDescriptor(partitionId.intValue(), taskSplits, this.nodeRequirements.get(partitionId)));
            }
            this.taskDescriptors = Optional.of(result.build());
        }
    }
}

