/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import io.airlift.json.JsonCodec;
import io.trino.metadata.QualifiedTablePrefix;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestQualifiedTablePrefix {
    private static final JsonCodec<QualifiedTablePrefix> CODEC = JsonCodec.jsonCodec(QualifiedTablePrefix.class);

    @Test
    public void testCatalog() {
        QualifiedTablePrefix tableName = new QualifiedTablePrefix("catalog");
        Assert.assertEquals((String)"catalog", (String)tableName.getCatalogName());
        Assert.assertFalse((boolean)tableName.hasSchemaName());
        Assert.assertFalse((boolean)tableName.hasTableName());
    }

    @Test
    public void testSchema() {
        QualifiedTablePrefix tableName = new QualifiedTablePrefix("catalog", "schema");
        Assert.assertEquals((String)"catalog", (String)tableName.getCatalogName());
        Assert.assertTrue((boolean)tableName.hasSchemaName());
        Assert.assertEquals((String)"schema", (String)((String)tableName.getSchemaName().get()));
        Assert.assertFalse((boolean)tableName.hasTableName());
    }

    @Test
    public void testTable() {
        QualifiedTablePrefix tableName = new QualifiedTablePrefix("catalog", "schema", "table");
        Assert.assertEquals((String)"catalog", (String)tableName.getCatalogName());
        Assert.assertTrue((boolean)tableName.hasSchemaName());
        Assert.assertEquals((String)"schema", (String)((String)tableName.getSchemaName().get()));
        Assert.assertTrue((boolean)tableName.hasTableName());
        Assert.assertEquals((String)"table", (String)((String)tableName.getTableName().get()));
    }

    @Test
    public void testNullSchema() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new QualifiedTablePrefix("catalog", null, "table")).isInstanceOf(NullPointerException.class)).hasMessage("schemaName is null");
    }

    @Test
    public void testRoundTrip() {
        QualifiedTablePrefix table = new QualifiedTablePrefix("abc", "xyz", "fgh");
        Assert.assertEquals((Object)CODEC.fromJson(CODEC.toJson((Object)table)), (Object)table);
    }
}

