/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.OperatorContext;
import io.trino.operator.TestingOperatorContext;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.testng.Assert;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestOperatorMemoryRevocation {
    private ScheduledExecutorService scheduledExecutor;

    @BeforeAll
    public void setUp() {
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    @AfterAll
    public void tearDown() {
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testOperatorMemoryRevocation() {
        AtomicInteger counter = new AtomicInteger();
        OperatorContext operatorContext = TestingOperatorContext.create(this.scheduledExecutor);
        LocalMemoryContext revocableMemoryContext = operatorContext.localRevocableMemoryContext();
        revocableMemoryContext.setBytes(1000L);
        operatorContext.setMemoryRevocationRequestListener(counter::incrementAndGet);
        operatorContext.requestMemoryRevoking();
        Assert.assertTrue((boolean)operatorContext.isMemoryRevokingRequested());
        Assert.assertEquals((int)counter.get(), (int)1);
        operatorContext.resetMemoryRevokingRequested();
        Assert.assertFalse((boolean)operatorContext.isMemoryRevokingRequested());
        operatorContext.requestMemoryRevoking();
        Assert.assertEquals((int)counter.get(), (int)2);
        Assert.assertTrue((boolean)operatorContext.isMemoryRevokingRequested());
    }

    @Test
    public void testRevocationAlreadyRequested() {
        AtomicInteger counter = new AtomicInteger();
        OperatorContext operatorContext = TestingOperatorContext.create(this.scheduledExecutor);
        LocalMemoryContext revocableMemoryContext = operatorContext.localRevocableMemoryContext();
        revocableMemoryContext.setBytes(1000L);
        operatorContext.requestMemoryRevoking();
        operatorContext.setMemoryRevocationRequestListener(counter::incrementAndGet);
        Assert.assertTrue((boolean)operatorContext.isMemoryRevokingRequested());
        Assert.assertEquals((int)counter.get(), (int)1);
    }

    @Test
    public void testSingleListenerEnforcement() {
        OperatorContext operatorContext = TestingOperatorContext.create(this.scheduledExecutor);
        operatorContext.setMemoryRevocationRequestListener(() -> {});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> operatorContext.setMemoryRevocationRequestListener(() -> {})).isInstanceOf(IllegalStateException.class)).hasMessage("listener already set");
    }
}

