/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.block.BlockAssertions;
import io.trino.execution.TableExecuteContext;
import io.trino.execution.TableExecuteContextManager;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.AggregationOperator;
import io.trino.operator.DriverContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.PageAssertions;
import io.trino.operator.TableFinishOperator;
import io.trino.operator.aggregation.TestingAggregationFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.LongArrayBlockBuilder;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.statistics.ColumnStatisticMetadata;
import io.trino.spi.statistics.ColumnStatisticType;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.StatisticAggregationsDescriptor;
import io.trino.testing.TestingSession;
import io.trino.testing.TestingTaskContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.testng.Assert;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestTableFinishOperator {
    private static final TestingAggregationFunction LONG_MAX = new TestingFunctionResolution().getAggregateFunction("max", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
    private ScheduledExecutorService scheduledExecutor;

    @BeforeAll
    public void setUp() {
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
    }

    @AfterAll
    public void tearDown() {
        this.scheduledExecutor.shutdownNow();
        this.scheduledExecutor = null;
    }

    @Test
    public void testStatisticsAggregation() throws Exception {
        TestTableFinisher tableFinisher = new TestTableFinisher();
        ColumnStatisticMetadata statisticMetadata = new ColumnStatisticMetadata("column", ColumnStatisticType.MAX_VALUE);
        StatisticAggregationsDescriptor descriptor = new StatisticAggregationsDescriptor((Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)statisticMetadata, (Object)0));
        Session session = TestingSession.testSessionBuilder().setSystemProperty("statistics_cpu_timer_enabled", "true").build();
        TableExecuteContextManager tableExecuteContextManager = new TableExecuteContextManager();
        TableFinishOperator.TableFinishOperatorFactory operatorFactory = new TableFinishOperator.TableFinishOperatorFactory(0, new PlanNodeId("node"), (TableFinishOperator.TableFinisher)tableFinisher, (OperatorFactory)new AggregationOperator.AggregationOperatorFactory(1, new PlanNodeId("test"), (List)ImmutableList.of((Object)LONG_MAX.createAggregatorFactory(AggregationNode.Step.SINGLE, (List<Integer>)ImmutableList.of((Object)2), OptionalInt.empty()))), descriptor, tableExecuteContextManager, true, session);
        DriverContext driverContext = TestingTaskContext.createTaskContext((Executor)this.scheduledExecutor, (ScheduledExecutorService)this.scheduledExecutor, (Session)session).addPipelineContext(0, true, true, false).addDriverContext();
        tableExecuteContextManager.registerTableExecuteContextForQuery(driverContext.getPipelineContext().getTaskContext().getQueryContext().getQueryId());
        TableFinishOperator operator = (TableFinishOperator)operatorFactory.createOperator(driverContext);
        ImmutableList inputTypes = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarbinaryType.VARBINARY, (Object)BigintType.BIGINT);
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(4, null, null).build().get(0));
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(5, null, null).build().get(0));
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(null, new byte[]{1}, null).build().get(0));
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(null, new byte[]{2}, null).build().get(0));
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(null, null, 6).build().get(0));
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(null, null, 7).build().get(0));
        ((AbstractLongAssert)Assertions.assertThat((long)driverContext.getMemoryUsage()).as("memoryUsage", new Object[0])).isGreaterThan(0L);
        Assert.assertTrue((boolean)operator.isBlocked().isDone(), (String)"isBlocked should be done");
        Assert.assertTrue((boolean)operator.needsInput(), (String)"needsInput should be true");
        operator.finish();
        Assert.assertFalse((boolean)operator.isFinished(), (String)"isFinished should be false");
        Assert.assertNull((Object)operator.getOutput());
        ImmutableList outputTypes = ImmutableList.of((Object)BigintType.BIGINT);
        PageAssertions.assertPageEquals((List<? extends Type>)outputTypes, operator.getOutput(), RowPagesBuilder.rowPagesBuilder((Iterable<Type>)outputTypes).row(9).build().get(0));
        Assert.assertTrue((boolean)operator.isBlocked().isDone(), (String)"isBlocked should be done");
        Assert.assertFalse((boolean)operator.needsInput(), (String)"needsInput should be false");
        Assert.assertTrue((boolean)operator.isFinished(), (String)"isFinished should be true");
        operator.close();
        Assert.assertEquals(tableFinisher.getFragments(), (Collection)ImmutableList.of((Object)Slices.wrappedBuffer((byte[])new byte[]{1}), (Object)Slices.wrappedBuffer((byte[])new byte[]{2})));
        Assert.assertEquals((int)tableFinisher.getComputedStatistics().size(), (int)1);
        Assert.assertEquals((int)((ComputedStatistics)Iterables.getOnlyElement(tableFinisher.getComputedStatistics())).getColumnStatistics().size(), (int)1);
        LongArrayBlockBuilder expectedStatistics = new LongArrayBlockBuilder(null, 1);
        BigintType.BIGINT.writeLong((BlockBuilder)expectedStatistics, 7L);
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, (Block)((ComputedStatistics)Iterables.getOnlyElement(tableFinisher.getComputedStatistics())).getColumnStatistics().get(statisticMetadata), expectedStatistics.build());
        Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)0L, (String)"memoryUsage");
    }

    private static class TestTableFinisher
    implements TableFinishOperator.TableFinisher {
        private boolean finished;
        private Collection<Slice> fragments;
        private Collection<ComputedStatistics> computedStatistics;
        private TableExecuteContext tableExecuteContext;

        private TestTableFinisher() {
        }

        public Optional<ConnectorOutputMetadata> finishTable(Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics, TableExecuteContext tableExecuteContext) {
            Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
            this.finished = true;
            this.fragments = fragments;
            this.computedStatistics = computedStatistics;
            this.tableExecuteContext = tableExecuteContext;
            return Optional.empty();
        }

        public Collection<Slice> getFragments() {
            return this.fragments;
        }

        public Collection<ComputedStatistics> getComputedStatistics() {
            return this.computedStatistics;
        }

        public TableExecuteContext getTableExecuteContext() {
            return this.tableExecuteContext;
        }
    }
}

