/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.jmh.Benchmarks;
import io.trino.operator.aggregation.AggregationMask;
import io.trino.operator.aggregation.AggregationMaskBuilder;
import io.trino.operator.aggregation.AggregationMaskCompiler;
import io.trino.operator.aggregation.InterpretedAggregationMaskBuilder;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ShortArrayBlock;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=1, jvmArgsAppend={"-XX:+UnlockDiagnosticVMOptions"})
@Warmup(iterations=10, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=1000, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkAggregationMaskBuilder {
    private final AggregationMaskBuilder rleNoNullsBuilder = new InterpretedAggregationMaskBuilder(0, 3, 6);
    private final AggregationMaskBuilder rleNoNullsBuilderCurrent = new CurrentAggregationMaskBuilder(0, 3, 6);
    private final AggregationMaskBuilder rleNoNullsBuilderHandCoded = new HandCodedAggregationMaskBuilder(0, 3, 6);
    private final AggregationMaskBuilder rleNoNullsBuilderCompiled = BenchmarkAggregationMaskBuilder.compiledMaskBuilder(0, 3, 6);
    private final AggregationMaskBuilder noNullsBuilder = new InterpretedAggregationMaskBuilder(1, 4, 7);
    private final AggregationMaskBuilder noNullsBuilderCurrent = new CurrentAggregationMaskBuilder(1, 4, 7);
    private final AggregationMaskBuilder noNullsBuilderHandCoded = new HandCodedAggregationMaskBuilder(1, 4, 7);
    private final AggregationMaskBuilder noNullsBuilderCompiled = BenchmarkAggregationMaskBuilder.compiledMaskBuilder(1, 4, 7);
    private final AggregationMaskBuilder someNullsBuilder = new InterpretedAggregationMaskBuilder(2, 5, 8);
    private final AggregationMaskBuilder someNullsBuilderCurrent = new CurrentAggregationMaskBuilder(2, 5, 8);
    private final AggregationMaskBuilder someNullsBuilderHandCoded = new HandCodedAggregationMaskBuilder(2, 5, 8);
    private final AggregationMaskBuilder someNullsBuilderCompiled = BenchmarkAggregationMaskBuilder.compiledMaskBuilder(2, 5, 8);
    private final AggregationMaskBuilder oneBlockSomeNullsBuilder = new InterpretedAggregationMaskBuilder(2);
    private final AggregationMaskBuilder oneBlockSomeNullsBuilderCurrent = new CurrentAggregationMaskBuilder(2, -1, -1);
    private final AggregationMaskBuilder oneBlockSomeNullsBuilderHandCoded = new HandCodedAggregationMaskBuilder(2, -1, -1);
    private final AggregationMaskBuilder oneBlockSomeNullsBuilderCompiled = BenchmarkAggregationMaskBuilder.compiledMaskBuilder(2);
    private final AggregationMaskBuilder allBlocksBuilder = new InterpretedAggregationMaskBuilder(0, 1, 2, 3, 4, 5, 6, 7, 8);
    private final AggregationMaskBuilder allBlocksBuilderCompiled = BenchmarkAggregationMaskBuilder.compiledMaskBuilder(0, 1, 2, 3, 4, 5, 6, 7, 8);
    private Page arguments;

    @Setup
    public void setup() throws Throwable {
        int positions = 10000;
        Block shortRleNoNulls = RunLengthEncodedBlock.create((Block)new ShortArrayBlock(1, Optional.empty(), new short[]{42}), (int)positions);
        ShortArrayBlock shortNoNulls = new ShortArrayBlock(new long[positions].length, Optional.empty(), new short[positions]);
        ShortArrayBlock shortSomeNulls = new ShortArrayBlock(new long[positions].length, BenchmarkAggregationMaskBuilder.someNulls(positions, 0.3), new short[positions]);
        Block intRleNoNulls = RunLengthEncodedBlock.create((Block)new IntArrayBlock(1, Optional.empty(), new int[]{42}), (int)positions);
        IntArrayBlock intNoNulls = new IntArrayBlock(new long[positions].length, Optional.empty(), new int[positions]);
        IntArrayBlock intSomeNulls = new IntArrayBlock(new long[positions].length, BenchmarkAggregationMaskBuilder.someNulls(positions, 0.3), new int[positions]);
        Block longRleNoNulls = RunLengthEncodedBlock.create((Block)new LongArrayBlock(1, Optional.empty(), new long[]{42L}), (int)positions);
        LongArrayBlock longNoNulls = new LongArrayBlock(new long[positions].length, Optional.empty(), new long[positions]);
        LongArrayBlock longSomeNulls = new LongArrayBlock(new long[positions].length, BenchmarkAggregationMaskBuilder.someNulls(positions, 0.3), new long[positions]);
        Block rleAllNulls = RunLengthEncodedBlock.create((Block)new ShortArrayBlock(1, Optional.of(new boolean[]{true}), new short[]{42}), (int)positions);
        this.arguments = new Page(new Block[]{shortRleNoNulls, shortNoNulls, shortSomeNulls, intRleNoNulls, intNoNulls, intSomeNulls, longRleNoNulls, longNoNulls, longSomeNulls, rleAllNulls});
    }

    private static Optional<boolean[]> someNulls(int positions, double nullRatio) {
        boolean[] nulls = new boolean[positions];
        for (int i = 0; i < nulls.length; ++i) {
            nulls[i] = ThreadLocalRandom.current().nextDouble() < nullRatio;
        }
        return Optional.of(nulls);
    }

    @Benchmark
    public Object rleNoNullsBlocksInterpreted() {
        return this.rleNoNullsBuilder.buildAggregationMask(this.arguments, Optional.empty());
    }

    @Benchmark
    public Object rleNoNullsBlocksCurrent() {
        return this.rleNoNullsBuilderCurrent.buildAggregationMask(this.arguments, Optional.empty());
    }

    @Benchmark
    public Object rleNoNullsBlocksHandCoded() {
        return this.rleNoNullsBuilderHandCoded.buildAggregationMask(this.arguments, Optional.empty());
    }

    @Benchmark
    public Object rleNoNullsBlocksCompiled() {
        return this.rleNoNullsBuilderCompiled.buildAggregationMask(this.arguments, Optional.empty());
    }

    @Benchmark
    public Object noNullsBlocksInterpreted() {
        return this.noNullsBuilder.buildAggregationMask(this.arguments, Optional.empty());
    }

    @Benchmark
    public Object noNullsBlocksCurrent() {
        return this.noNullsBuilderCurrent.buildAggregationMask(this.arguments, Optional.empty());
    }

    @Benchmark
    public Object noNullsBlocksHandCoded() {
        return this.noNullsBuilderHandCoded.buildAggregationMask(this.arguments, Optional.empty());
    }

    @Benchmark
    public Object noNullsBlocksCompiled() {
        return this.noNullsBuilderCompiled.buildAggregationMask(this.arguments, Optional.empty());
    }

    @Benchmark
    public Object someNullsBlocksInterpreted() {
        return this.someNullsBuilder.buildAggregationMask(this.arguments, Optional.empty());
    }

    @Benchmark
    public Object someNullsBlocksCurrent() {
        return this.someNullsBuilderCurrent.buildAggregationMask(this.arguments, Optional.empty());
    }

    @Benchmark
    public Object someNullsBlocksHandCoded() {
        return this.someNullsBuilderHandCoded.buildAggregationMask(this.arguments, Optional.empty());
    }

    @Benchmark
    public Object someNullsBlocksCompiled() {
        return this.someNullsBuilderCompiled.buildAggregationMask(this.arguments, Optional.empty());
    }

    @Benchmark
    public Object oneBlockSomeNullsInterpreted() {
        return this.oneBlockSomeNullsBuilder.buildAggregationMask(this.arguments, Optional.empty());
    }

    @Benchmark
    public Object oneBlockSomeNullsCurrent() {
        return this.oneBlockSomeNullsBuilderCurrent.buildAggregationMask(this.arguments, Optional.empty());
    }

    @Benchmark
    public Object oneBlockSomeNullsHandCoded() {
        return this.oneBlockSomeNullsBuilderHandCoded.buildAggregationMask(this.arguments, Optional.empty());
    }

    @Benchmark
    public Object oneBlockSomeNullsCompiled() {
        return this.oneBlockSomeNullsBuilderCompiled.buildAggregationMask(this.arguments, Optional.empty());
    }

    @Benchmark
    public Object allBlocksInterpreted() {
        return this.allBlocksBuilder.buildAggregationMask(this.arguments, Optional.empty());
    }

    @Benchmark
    public Object allBlocksCompiled() {
        return this.allBlocksBuilderCompiled.buildAggregationMask(this.arguments, Optional.empty());
    }

    public static void main(String[] args) throws Throwable {
        BenchmarkAggregationMaskBuilder bench = new BenchmarkAggregationMaskBuilder();
        bench.setup();
        bench.rleNoNullsBlocksInterpreted();
        bench.noNullsBlocksInterpreted();
        bench.someNullsBlocksInterpreted();
        bench.allBlocksInterpreted();
        bench.someNullsBlocksCurrent();
        bench.someNullsBlocksHandCoded();
        bench.someNullsBlocksCompiled();
        Benchmarks.benchmark(BenchmarkAggregationMaskBuilder.class).run();
    }

    private static boolean isAlwaysNull(Block block) {
        if (block instanceof RunLengthEncodedBlock) {
            RunLengthEncodedBlock rle = (RunLengthEncodedBlock)block;
            return rle.getValue().isNull(0);
        }
        return false;
    }

    private static boolean testMaskBlock(Block block, boolean mayHaveNulls, int position) {
        return block == null || (!mayHaveNulls || !block.isNull(position)) && block.getByte(position, 0) != 0;
    }

    private static boolean isNotNull(Block block, boolean mayHaveNulls, int position) {
        return !mayHaveNulls || !block.isNull(position);
    }

    private static AggregationMaskBuilder compiledMaskBuilder(int ... ints) {
        try {
            return (AggregationMaskBuilder)AggregationMaskCompiler.generateAggregationMaskBuilder((int[])ints).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static class CurrentAggregationMaskBuilder
    implements AggregationMaskBuilder {
        private final int first;
        private final int second;
        private final int third;
        private final AggregationMask mask = AggregationMask.createSelectAll((int)0);

        public CurrentAggregationMaskBuilder(int first, int second, int third) {
            this.first = first;
            this.second = second;
            this.third = third;
        }

        public AggregationMask buildAggregationMask(Page arguments, Optional<Block> optionalMaskBlock) {
            int positionCount = arguments.getPositionCount();
            this.mask.reset(positionCount);
            this.mask.applyMaskBlock((Block)optionalMaskBlock.orElse(null));
            if (this.first >= 0) {
                this.mask.unselectNullPositions(arguments.getBlock(this.first));
            }
            if (this.second >= 0) {
                this.mask.unselectNullPositions(arguments.getBlock(this.second));
            }
            if (this.third >= 0) {
                this.mask.unselectNullPositions(arguments.getBlock(this.third));
            }
            return this.mask;
        }
    }

    private static class HandCodedAggregationMaskBuilder
    implements AggregationMaskBuilder {
        private final int first;
        private final int second;
        private final int third;
        private int[] selectedPositions = new int[0];

        public HandCodedAggregationMaskBuilder(int first, int second, int third) {
            this.first = first;
            this.second = second;
            this.third = third;
        }

        public AggregationMask buildAggregationMask(Page arguments, Optional<Block> optionalMaskBlock) {
            boolean nonNullArgNMayHaveNull;
            Block nonNullArgN;
            Block nonNullArg1;
            Block nonNullArg0;
            boolean maskBlockMayHaveNull;
            int positionCount = arguments.getPositionCount();
            if (positionCount == 0) {
                return AggregationMask.createSelectNone((int)positionCount);
            }
            Block maskBlock = optionalMaskBlock.orElse(null);
            boolean hasMaskBlock = maskBlock != null;
            boolean bl = maskBlockMayHaveNull = hasMaskBlock && maskBlock.mayHaveNull();
            if (maskBlock instanceof RunLengthEncodedBlock) {
                RunLengthEncodedBlock rle = (RunLengthEncodedBlock)maskBlock;
                Block value = rle.getValue();
                if (value != null && (maskBlockMayHaveNull && value.isNull(0) || value.getByte(0, 0) == 0)) {
                    return AggregationMask.createSelectNone((int)positionCount);
                }
                hasMaskBlock = false;
                maskBlockMayHaveNull = false;
            }
            Block block = nonNullArg0 = this.first < 0 ? null : arguments.getBlock(this.first);
            if (BenchmarkAggregationMaskBuilder.isAlwaysNull(nonNullArg0)) {
                return AggregationMask.createSelectNone((int)positionCount);
            }
            boolean nonNullArg0MayHaveNull = nonNullArg0 != null && nonNullArg0.mayHaveNull();
            Block block2 = nonNullArg1 = this.third < 0 ? null : arguments.getBlock(this.second);
            if (BenchmarkAggregationMaskBuilder.isAlwaysNull(nonNullArg1)) {
                return AggregationMask.createSelectNone((int)positionCount);
            }
            boolean nonNullArg1MayHaveNull = nonNullArg1 != null && nonNullArg1.mayHaveNull();
            Block block3 = nonNullArgN = this.third < 0 ? null : arguments.getBlock(this.third);
            if (BenchmarkAggregationMaskBuilder.isAlwaysNull(nonNullArgN)) {
                return AggregationMask.createSelectNone((int)positionCount);
            }
            boolean bl2 = nonNullArgNMayHaveNull = nonNullArgN != null && nonNullArgN.mayHaveNull();
            if (!(hasMaskBlock || nonNullArg0MayHaveNull || nonNullArg1MayHaveNull || nonNullArgNMayHaveNull)) {
                return AggregationMask.createSelectAll((int)positionCount);
            }
            int[] selectedPositions = this.selectedPositions;
            if (selectedPositions.length < positionCount) {
                this.selectedPositions = selectedPositions = new int[positionCount];
            }
            int selectedPositionsIndex = 0;
            for (int position = 0; position < positionCount; ++position) {
                if (maskBlock != null && (maskBlockMayHaveNull && maskBlock.isNull(position) || maskBlock.getByte(position, 0) == 0) || nonNullArg0MayHaveNull && nonNullArg0.isNull(position) || nonNullArg1MayHaveNull && nonNullArg1.isNull(position) || nonNullArgNMayHaveNull && nonNullArgN.isNull(position)) continue;
                selectedPositions[selectedPositionsIndex] = position;
                ++selectedPositionsIndex;
            }
            return AggregationMask.createSelectedPositions((int)positionCount, (int[])selectedPositions, (int)selectedPositionsIndex);
        }
    }
}

