/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.TrinoException;
import io.trino.sql.query.QueryAssertions;
import io.trino.type.LikeFunctions;
import io.trino.type.LikePattern;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.testng.Assert;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestLikeFunctions {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    private static Slice offsetHeapSlice(String value) {
        Slice source = Slices.utf8Slice((String)value);
        Slice result = Slices.allocate((int)(source.length() + 5));
        result.setBytes(2, source);
        return result.slice(2, source.length());
    }

    @Test
    public void testLikeBasic() {
        LikePattern matcher = LikePattern.compile((String)Slices.utf8Slice((String)"f%b__").toStringUtf8(), Optional.empty());
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foobar"), (LikePattern)matcher));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)TestLikeFunctions.offsetHeapSlice("foobar"), (LikePattern)matcher));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'f%b__'").binding("a", "'foob'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'f%b'").binding("a", "'foob'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo '").binding("a", "CAST('foo' AS varchar(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo '").binding("a", "CAST('foo ' AS varchar(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo___'").binding("a", "CAST('foo' AS varchar(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo%'").binding("a", "CAST('foo' AS varchar(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE CAST('foo' AS varchar(6))").binding("a", "CAST('foo' AS varchar(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE CAST('foo  ' AS varchar(3))").binding("a", "CAST('foo' AS varchar(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE CAST('foo   ' AS varchar(6))").binding("a", "CAST('foo' AS varchar(6))")))).isEqualTo(false);
    }

    @Test
    public void testLikeChar() {
        LikePattern matcher = LikePattern.compile((String)Slices.utf8Slice((String)"f%b__").toStringUtf8(), Optional.empty());
        Assert.assertTrue((boolean)LikeFunctions.likeChar((Long)6L, (Slice)Slices.utf8Slice((String)"foobar"), (LikePattern)matcher));
        Assert.assertTrue((boolean)LikeFunctions.likeChar((Long)6L, (Slice)TestLikeFunctions.offsetHeapSlice("foobar"), (LikePattern)matcher));
        Assert.assertTrue((boolean)LikeFunctions.likeChar((Long)6L, (Slice)Slices.utf8Slice((String)"foob"), (LikePattern)matcher));
        Assert.assertTrue((boolean)LikeFunctions.likeChar((Long)6L, (Slice)TestLikeFunctions.offsetHeapSlice("foob"), (LikePattern)matcher));
        Assert.assertFalse((boolean)LikeFunctions.likeChar((Long)7L, (Slice)Slices.utf8Slice((String)"foob"), (LikePattern)matcher));
        Assert.assertFalse((boolean)LikeFunctions.likeChar((Long)7L, (Slice)TestLikeFunctions.offsetHeapSlice("foob"), (LikePattern)matcher));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo'").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo  '").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'fo_'").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'fo%'").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE '%foo'").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE '_oo'").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'f%b__'").binding("a", "CAST('foob' AS char(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'f%b__'").binding("a", "CAST('foob' AS char(7))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo'").binding("a", "CAST('foo' AS char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'ja\u017a\u0144'").binding("a", "CAST('ja\u017a\u0144' AS char(4))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'fob'").binding("a", "CAST('foo' AS char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo   '").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo __'").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE '%%%%%%'").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE '%%foo'").binding("a", "CAST('foo' AS char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'f#_#_' ESCAPE '#'").binding("a", "CAST('foo' AS char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'f#_#_' ESCAPE '#'").binding("a", "CAST('f__' AS char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo    '").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo __ '").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE '_______'").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE '%%%%%%%'").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo   %%%%%%%'").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo  %%%%%%% '").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo  %%%%%%%  '").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foobar%%%%%%%'").binding("a", "CAST('foobar' AS char(6))")))).isEqualTo(true);
    }

    @Test
    public void testLikeSpacesInPattern() {
        LikePattern matcher = LikePattern.compile((String)Slices.utf8Slice((String)"ala  ").toStringUtf8(), Optional.empty());
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"ala  "), (LikePattern)matcher));
        Assert.assertFalse((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"ala"), (LikePattern)matcher));
    }

    @Test
    public void testLikeNewlineInPattern() {
        LikePattern matcher = LikePattern.compile((String)Slices.utf8Slice((String)"%o\nbar").toStringUtf8(), Optional.empty());
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foo\nbar"), (LikePattern)matcher));
    }

    @Test
    public void testLikeNewlineBeforeMatch() {
        LikePattern matcher = LikePattern.compile((String)Slices.utf8Slice((String)"%b%").toStringUtf8(), Optional.empty());
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foo\nbar"), (LikePattern)matcher));
    }

    @Test
    public void testLikeNewlineInMatch() {
        LikePattern matcher = LikePattern.compile((String)Slices.utf8Slice((String)"f%b%").toStringUtf8(), Optional.empty());
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foo\nbar"), (LikePattern)matcher));
    }

    @Test
    public void testLikeUtf8Pattern() {
        LikePattern matcher = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"%\u540d\u8a89%"), (Slice)Slices.utf8Slice((String)"\\"));
        Assert.assertFalse((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foo"), (LikePattern)matcher));
    }

    @Test
    public void testLikeInvalidUtf8Value() {
        Slice value = Slices.wrappedBuffer((byte[])new byte[]{97, 98, 99, -1, 120, 121});
        LikePattern matcher = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"%b%"), (Slice)Slices.utf8Slice((String)"\\"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)value, (LikePattern)matcher));
    }

    @Test
    public void testBackslashesNoSpecialTreatment() {
        LikePattern matcher = LikePattern.compile((String)Slices.utf8Slice((String)"\\abc\\/\\\\").toStringUtf8(), Optional.empty());
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"\\abc\\/\\\\"), (LikePattern)matcher));
    }

    @Test
    public void testSelfEscaping() {
        LikePattern matcher = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"\\\\abc\\%"), (Slice)Slices.utf8Slice((String)"\\"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"\\abc%"), (LikePattern)matcher));
    }

    @Test
    public void testAlternateEscapedCharacters() {
        LikePattern matcher = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"xxx%x_abcxx"), (Slice)Slices.utf8Slice((String)"x"));
        Assert.assertTrue((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"x%_abcx"), (LikePattern)matcher));
    }

    @Test
    public void testInvalidLikePattern() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"#"), (Slice)Slices.utf8Slice((String)"#"))).isInstanceOf(TrinoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"abc#abc"), (Slice)Slices.utf8Slice((String)"#"))).isInstanceOf(TrinoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"abc#"), (Slice)Slices.utf8Slice((String)"#"))).isInstanceOf(TrinoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
    }

    @Test
    public void testIsLikePattern() {
        Assert.assertFalse((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc"), Optional.empty()));
        Assert.assertFalse((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc#_def"), Optional.of(Slices.utf8Slice((String)"#"))));
        Assert.assertFalse((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc##def"), Optional.of(Slices.utf8Slice((String)"#"))));
        Assert.assertFalse((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc#%def"), Optional.of(Slices.utf8Slice((String)"#"))));
        Assert.assertTrue((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc%def"), Optional.empty()));
        Assert.assertTrue((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abcdef_"), Optional.empty()));
        Assert.assertTrue((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abcdef##_"), Optional.of(Slices.utf8Slice((String)"#"))));
        Assert.assertTrue((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"%abcdef#_"), Optional.of(Slices.utf8Slice((String)"#"))));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"#"), Optional.of(Slices.utf8Slice((String)"#")))).isInstanceOf(TrinoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc#abc"), Optional.of(Slices.utf8Slice((String)"#")))).isInstanceOf(TrinoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc#"), Optional.of(Slices.utf8Slice((String)"#")))).isInstanceOf(TrinoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
    }

    @Test
    public void testPatternConstantPrefixBytes() {
        Assert.assertEquals((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abc"), Optional.empty()), (int)3);
        Assert.assertEquals((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abc#_def"), Optional.of(Slices.utf8Slice((String)"#"))), (int)8);
        Assert.assertEquals((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abc##def"), Optional.of(Slices.utf8Slice((String)"#"))), (int)8);
        Assert.assertEquals((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abc#%def"), Optional.of(Slices.utf8Slice((String)"#"))), (int)8);
        Assert.assertEquals((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abc%def"), Optional.empty()), (int)3);
        Assert.assertEquals((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abcdef_"), Optional.empty()), (int)6);
        Assert.assertEquals((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abcdef##_"), Optional.of(Slices.utf8Slice((String)"#"))), (int)8);
        Assert.assertEquals((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"%abcdef#_"), Optional.of(Slices.utf8Slice((String)"#"))), (int)0);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"#"), Optional.of(Slices.utf8Slice((String)"#")))).isInstanceOf(TrinoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abc#abc"), Optional.of(Slices.utf8Slice((String)"#")))).isInstanceOf(TrinoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abc#"), Optional.of(Slices.utf8Slice((String)"#")))).isInstanceOf(TrinoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
    }

    @Test
    public void testUnescapeValidLikePattern() {
        Assert.assertEquals((Object)LikeFunctions.unescapeLiteralLikePattern((Slice)Slices.utf8Slice((String)"abc"), Optional.empty()), (Object)Slices.utf8Slice((String)"abc"));
        Assert.assertEquals((Object)LikeFunctions.unescapeLiteralLikePattern((Slice)Slices.utf8Slice((String)"abc#_"), Optional.of(Slices.utf8Slice((String)"#"))), (Object)Slices.utf8Slice((String)"abc_"));
        Assert.assertEquals((Object)LikeFunctions.unescapeLiteralLikePattern((Slice)Slices.utf8Slice((String)"a##bc#_"), Optional.of(Slices.utf8Slice((String)"#"))), (Object)Slices.utf8Slice((String)"a#bc_"));
        Assert.assertEquals((Object)LikeFunctions.unescapeLiteralLikePattern((Slice)Slices.utf8Slice((String)"a###_bc"), Optional.of(Slices.utf8Slice((String)"#"))), (Object)Slices.utf8Slice((String)"a#_bc"));
    }

    @Test
    public void testLikeWithDynamicPattern() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT value FROM (\n    VALUES\n        ('a', 'a'),\n        ('b', 'a'),\n        ('c', '%')) t(value, pattern)\nWHERE value LIKE pattern\n")))).matches("VALUES 'a', 'c'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT value FROM (\n    VALUES\n        ('a%b', 'aX%b', 'X'),\n        ('a0b', 'aX%b', 'X'),\n        ('b_', 'aY_', 'Y'),\n        ('c%', 'cZ%', 'Z')) t(value, pattern, esc)\nWHERE value LIKE pattern ESCAPE esc\n")))).matches("VALUES 'a%b', 'c%'");
    }
}

