/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.connector.CatalogServiceProvider;
import io.trino.connector.MockConnectorFactory;
import io.trino.eventlistener.EventListenerManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.QualifiedObjectName;
import io.trino.plugin.base.security.AllowAllAccessControl;
import io.trino.plugin.base.security.AllowAllSystemAccessControl;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlConfig;
import io.trino.security.AccessControlManager;
import io.trino.security.SecurityContext;
import io.trino.spi.QueryId;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaRoutineName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorSecurityContext;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.BasicPrincipal;
import io.trino.spi.security.Identity;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.security.SystemAccessControlFactory;
import io.trino.spi.security.SystemSecurityContext;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingEventListenerManager;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionBuilder;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestAccessControlManager {
    private static final Principal PRINCIPAL = new BasicPrincipal("principal");
    private static final String USER_NAME = "user_name";
    private static final QueryId queryId = new QueryId("query_id");
    private static final Instant queryStart = Instant.now();

    @Test
    public void testInitializing() {
        AccessControlManager accessControlManager = this.createAccessControlManager(InMemoryTransactionManager.createTestTransactionManager());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSetUser(Optional.empty(), "foo")).isInstanceOf(TrinoException.class)).hasMessage("Trino server is still initializing");
    }

    @Test
    public void testNoneSystemAccessControl() {
        AccessControlManager accessControlManager = this.createAccessControlManager(InMemoryTransactionManager.createTestTransactionManager());
        accessControlManager.loadSystemAccessControl("allow-all", (Map)ImmutableMap.of());
        accessControlManager.checkCanSetUser(Optional.empty(), USER_NAME);
    }

    @Test
    public void testReadOnlySystemAccessControl() {
        Identity identity = Identity.forUser((String)USER_NAME).withPrincipal(PRINCIPAL).build();
        QualifiedObjectName tableName = new QualifiedObjectName("test-catalog", "schema", "table");
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
        AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
        accessControlManager.loadSystemAccessControl("read-only", (Map)ImmutableMap.of());
        accessControlManager.checkCanSetUser(Optional.of(PRINCIPAL), USER_NAME);
        accessControlManager.checkCanSetSystemSessionProperty(identity, "property");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> {
            SecurityContext context = new SecurityContext(transactionId, identity, queryId, queryStart);
            accessControlManager.checkCanSetCatalogSessionProperty(context, "test-catalog", "property");
            accessControlManager.checkCanShowSchemas(context, "test-catalog");
            accessControlManager.checkCanShowTables(context, new CatalogSchemaName("test-catalog", "schema"));
            accessControlManager.checkCanSelectFromColumns(context, tableName, (Set)ImmutableSet.of((Object)"column"));
            accessControlManager.checkCanCreateViewWithSelectFromColumns(context, tableName, (Set)ImmutableSet.of((Object)"column"));
            ImmutableSet catalogs = ImmutableSet.of((Object)"test-catalog");
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(context, (Set)catalogs), (Set)catalogs);
            ImmutableSet schemas = ImmutableSet.of((Object)"schema");
            Assert.assertEquals((Set)accessControlManager.filterSchemas(context, "test-catalog", (Set)schemas), (Set)schemas);
            ImmutableSet tableNames = ImmutableSet.of((Object)new SchemaTableName("schema", "table"));
            Assert.assertEquals((Set)accessControlManager.filterTables(context, "test-catalog", (Set)tableNames), (Set)tableNames);
        });
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestAccessControlManager.lambda$testReadOnlySystemAccessControl$3(transactionManager, (Metadata)metadata, accessControlManager, identity, tableName)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot insert into table test-catalog.schema.table");
    }

    @Test
    public void testSetAccessControl() {
        AccessControlManager accessControlManager = this.createAccessControlManager(InMemoryTransactionManager.createTestTransactionManager());
        TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("test");
        accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
        accessControlManager.loadSystemAccessControl("test", (Map)ImmutableMap.of());
        accessControlManager.checkCanSetUser(Optional.of(PRINCIPAL), USER_NAME);
        Assert.assertEquals((String)accessControlFactory.getCheckedUserName(), (String)USER_NAME);
        Assert.assertEquals(accessControlFactory.getCheckedPrincipal(), Optional.of(PRINCIPAL));
    }

    @Test
    public void testNoCatalogAccessControl() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
        AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
        TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("test");
        accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
        accessControlManager.loadSystemAccessControl("test", (Map)ImmutableMap.of());
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanSelectFromColumns(TestAccessControlManager.context(transactionId), new QualifiedObjectName("test-catalog", "schema", "table"), (Set)ImmutableSet.of((Object)"column")));
    }

    @Test
    public void testDenyCatalogAccessControl() {
        try (LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);){
            TransactionManager transactionManager = queryRunner.getTransactionManager();
            MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
            AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
            TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("test");
            accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
            accessControlManager.loadSystemAccessControl("test", (Map)ImmutableMap.of());
            queryRunner.createCatalog("test-catalog", (ConnectorFactory)MockConnectorFactory.create(), (Map)ImmutableMap.of());
            accessControlManager.setConnectorAccessControlProvider(CatalogServiceProvider.singleton((CatalogHandle)queryRunner.getCatalogHandle("test-catalog"), Optional.of(new DenyConnectorAccessControl())));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestAccessControlManager.lambda$testDenyCatalogAccessControl$6(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(TrinoException.class)).hasMessageMatching("Access Denied: Cannot select from columns \\[column\\] in table or view schema.table");
        }
    }

    @Test
    public void testDenyTableFunctionCatalogAccessControl() {
        try (LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);){
            TransactionManager transactionManager = queryRunner.getTransactionManager();
            AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
            TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("test");
            accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
            accessControlManager.loadSystemAccessControl("allow-all", (Map)ImmutableMap.of());
            queryRunner.createCatalog("test-catalog", (ConnectorFactory)MockConnectorFactory.create(), (Map)ImmutableMap.of());
            accessControlManager.setConnectorAccessControlProvider(CatalogServiceProvider.singleton((CatalogHandle)queryRunner.getCatalogHandle("test-catalog"), Optional.of(new DenyConnectorAccessControl())));
        }
    }

    @Test
    public void testColumnMaskOrdering() {
        try (LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);){
            TransactionManager transactionManager = queryRunner.getTransactionManager();
            AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
            accessControlManager.addSystemAccessControlFactory(new SystemAccessControlFactory(){

                public String getName() {
                    return "test";
                }

                public SystemAccessControl create(Map<String, String> config) {
                    return new SystemAccessControl(){

                        public Optional<ViewExpression> getColumnMask(SystemSecurityContext context, CatalogSchemaTableName tableName, String column, Type type) {
                            return Optional.of(ViewExpression.builder().identity("user").expression("system mask").build());
                        }

                        public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
                        }
                    };
                }
            });
            accessControlManager.loadSystemAccessControl("test", (Map)ImmutableMap.of());
            queryRunner.createCatalog("test-catalog", (ConnectorFactory)MockConnectorFactory.create(), (Map)ImmutableMap.of());
            accessControlManager.setConnectorAccessControlProvider(CatalogServiceProvider.singleton((CatalogHandle)queryRunner.getCatalogHandle("test-catalog"), Optional.of(new ConnectorAccessControl(){

                public Optional<ViewExpression> getColumnMask(ConnectorSecurityContext context, SchemaTableName tableName, String column, Type type) {
                    return Optional.of(ViewExpression.builder().identity("user").expression("connector mask").build());
                }

                public void checkCanShowCreateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
                }
            })));
        }
    }

    private static SecurityContext context(TransactionId transactionId) {
        Identity identity = Identity.forUser((String)USER_NAME).withPrincipal(PRINCIPAL).build();
        return new SecurityContext(transactionId, identity, queryId, queryStart);
    }

    @Test
    public void testDenySystemAccessControl() {
        try (LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);){
            TransactionManager transactionManager = queryRunner.getTransactionManager();
            MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
            AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
            TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("test");
            accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
            accessControlManager.loadSystemAccessControl("test", (Map)ImmutableMap.of());
            queryRunner.createCatalog("test-catalog", (ConnectorFactory)MockConnectorFactory.create(), (Map)ImmutableMap.of());
            accessControlManager.setConnectorAccessControlProvider(CatalogServiceProvider.singleton((CatalogHandle)queryRunner.getCatalogHandle("test-catalog"), Optional.of(new DenyConnectorAccessControl())));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestAccessControlManager.lambda$testDenySystemAccessControl$8(transactionManager, (Metadata)metadata, accessControlManager)).isInstanceOf(TrinoException.class)).hasMessageMatching("Access Denied: Cannot select from table secured_catalog.schema.table");
        }
    }

    @Test
    public void testDenyExecuteProcedureBySystem() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
        AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
        TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("deny-all");
        accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
        accessControlManager.loadSystemAccessControl("deny-all", (Map)ImmutableMap.of());
        this.assertDenyExecuteProcedure(transactionManager, (Metadata)metadata, accessControlManager, "Access Denied: Cannot execute procedure test-catalog.schema.procedure");
    }

    @Test
    public void testDenyExecuteProcedureByConnector() {
        try (LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);){
            TransactionManager transactionManager = queryRunner.getTransactionManager();
            MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
            AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
            accessControlManager.loadSystemAccessControl("allow-all", (Map)ImmutableMap.of());
            queryRunner.createCatalog("test-catalog", (ConnectorFactory)MockConnectorFactory.create(), (Map)ImmutableMap.of());
            accessControlManager.setConnectorAccessControlProvider(CatalogServiceProvider.singleton((CatalogHandle)queryRunner.getCatalogHandle("test-catalog"), Optional.of(new DenyConnectorAccessControl())));
            this.assertDenyExecuteProcedure(transactionManager, (Metadata)metadata, accessControlManager, "Access Denied: Cannot execute procedure schema.procedure");
        }
    }

    @Test
    public void testAllowExecuteProcedure() {
        try (LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);){
            TransactionManager transactionManager = queryRunner.getTransactionManager();
            MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
            AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
            accessControlManager.loadSystemAccessControl("allow-all", (Map)ImmutableMap.of());
            queryRunner.createCatalog("test-catalog", (ConnectorFactory)MockConnectorFactory.create(), (Map)ImmutableMap.of());
            accessControlManager.setConnectorAccessControlProvider(CatalogServiceProvider.singleton((CatalogHandle)queryRunner.getCatalogHandle("test-catalog"), Optional.of(new AllowAllAccessControl())));
            TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanExecuteProcedure(TestAccessControlManager.context(transactionId), new QualifiedObjectName("test-catalog", "schema", "procedure")));
        }
    }

    @Test
    public void testRegisterSingleEventListenerForDefaultAccessControl() {
        EventListener expectedListener = new EventListener(){};
        String defaultAccessControlName = "event-listening-default-access-control";
        TestingEventListenerManager eventListenerManager = TestingEventListenerManager.emptyEventListenerManager();
        AccessControlManager accessControlManager = this.createAccessControlManager((EventListenerManager)eventListenerManager, defaultAccessControlName);
        accessControlManager.addSystemAccessControlFactory(this.eventListeningSystemAccessControlFactory(defaultAccessControlName, expectedListener));
        accessControlManager.loadSystemAccessControl();
        Assertions.assertThat((Collection)eventListenerManager.getConfiguredEventListeners()).contains((Object[])new EventListener[]{expectedListener});
    }

    @Test
    public void testRegisterMultipleEventListenerForDefaultAccessControl() {
        EventListener firstListener = new EventListener(){};
        EventListener secondListener = new EventListener(){};
        String defaultAccessControlName = "event-listening-default-access-control";
        TestingEventListenerManager eventListenerManager = TestingEventListenerManager.emptyEventListenerManager();
        AccessControlManager accessControlManager = this.createAccessControlManager((EventListenerManager)eventListenerManager, defaultAccessControlName);
        accessControlManager.addSystemAccessControlFactory(this.eventListeningSystemAccessControlFactory(defaultAccessControlName, firstListener, secondListener));
        accessControlManager.loadSystemAccessControl();
        Assertions.assertThat((Collection)eventListenerManager.getConfiguredEventListeners()).contains((Object[])new EventListener[]{firstListener, secondListener});
    }

    @Test
    public void testRegisterSingleEventListener() throws IOException {
        EventListener expectedListener = new EventListener(){};
        String systemAccessControlName = "event-listening-sac";
        TestingEventListenerManager eventListenerManager = TestingEventListenerManager.emptyEventListenerManager();
        AccessControlManager accessControlManager = this.createAccessControlManager(eventListenerManager, (List<String>)ImmutableList.of((Object)("access-control.name=" + systemAccessControlName)));
        accessControlManager.addSystemAccessControlFactory(this.eventListeningSystemAccessControlFactory(systemAccessControlName, expectedListener));
        accessControlManager.loadSystemAccessControl();
        Assertions.assertThat((Collection)eventListenerManager.getConfiguredEventListeners()).contains((Object[])new EventListener[]{expectedListener});
    }

    @Test
    public void testRegisterMultipleEventListeners() throws IOException {
        EventListener firstListener = new EventListener(){};
        EventListener secondListener = new EventListener(){};
        String systemAccessControlName = "event-listening-sac";
        TestingEventListenerManager eventListenerManager = TestingEventListenerManager.emptyEventListenerManager();
        AccessControlManager accessControlManager = this.createAccessControlManager(eventListenerManager, (List<String>)ImmutableList.of((Object)("access-control.name=" + systemAccessControlName)));
        accessControlManager.addSystemAccessControlFactory(this.eventListeningSystemAccessControlFactory(systemAccessControlName, firstListener, secondListener));
        accessControlManager.loadSystemAccessControl();
        Assertions.assertThat((Collection)eventListenerManager.getConfiguredEventListeners()).contains((Object[])new EventListener[]{firstListener, secondListener});
    }

    private void assertDenyExecuteProcedure(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager, String s) {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanExecuteProcedure(TestAccessControlManager.context(transactionId), new QualifiedObjectName("test-catalog", "schema", "procedure"))).isInstanceOf(AccessDeniedException.class)).hasMessage(s));
    }

    @Test
    public void testDenyExecuteFunctionBySystemAccessControl() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
        AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
        TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("deny-all");
        accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
        accessControlManager.loadSystemAccessControl("deny-all", (Map)ImmutableMap.of());
        QualifiedObjectName functionName = new QualifiedObjectName("test-catalog", "schema", "executed_function");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> {
            Assertions.assertThat((boolean)accessControlManager.canExecuteFunction(TestAccessControlManager.context(transactionId), functionName)).isFalse();
            Assertions.assertThat((boolean)accessControlManager.canCreateViewWithExecuteFunction(TestAccessControlManager.context(transactionId), functionName)).isFalse();
        });
    }

    @Test
    public void testAllowExecuteFunction() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
        AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
        accessControlManager.loadSystemAccessControl("allow-all", (Map)ImmutableMap.of());
        QualifiedObjectName functionName = new QualifiedObjectName("test-catalog", "schema", "executed_function");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> {
            Assertions.assertThat((boolean)accessControlManager.canExecuteFunction(TestAccessControlManager.context(transactionId), functionName)).isTrue();
            Assertions.assertThat((boolean)accessControlManager.canCreateViewWithExecuteFunction(TestAccessControlManager.context(transactionId), functionName)).isTrue();
        });
    }

    @Test
    public void testAllowExecuteTableFunction() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
        AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
        accessControlManager.loadSystemAccessControl("allow-all", (Map)ImmutableMap.of());
        QualifiedObjectName functionName = new QualifiedObjectName("test-catalog", "schema", "executed_function");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> {
            Assertions.assertThat((boolean)accessControlManager.canExecuteFunction(TestAccessControlManager.context(transactionId), functionName)).isTrue();
            Assertions.assertThat((boolean)accessControlManager.canCreateViewWithExecuteFunction(TestAccessControlManager.context(transactionId), functionName)).isTrue();
        });
    }

    @Test
    public void testRemovedMethodsCannotBeDeclared() {
        try (LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);){
            TransactionManager transactionManager = queryRunner.getTransactionManager();
            AccessControlManager accessControlManager = this.createAccessControlManager(transactionManager);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.setSystemAccessControls((List)ImmutableList.of((Object)new AllowAllSystemAccessControl(){

                public void checkCanAccessCatalog(SystemSecurityContext context, String catalogName) {
                }
            }))).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Access control .* must not implement removed method checkCanAccessCatalog\\(.*\\)");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.setSystemAccessControls((List)ImmutableList.of((Object)new AllowAllSystemAccessControl(){

                public void checkCanGrantExecuteFunctionPrivilege(SystemSecurityContext context, String functionName, TrinoPrincipal grantee, boolean grantOption) {
                }
            }))).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Access control .* must not implement removed method checkCanGrantExecuteFunctionPrivilege\\(.*\\)");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.setSystemAccessControls((List)ImmutableList.of((Object)new AllowAllSystemAccessControl(){

                public void checkCanExecuteFunction(SystemSecurityContext systemSecurityContext, String functionName) {
                }
            }))).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Access control .* must not implement removed method checkCanExecuteFunction\\(.*\\)");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.setSystemAccessControls((List)ImmutableList.of((Object)new AllowAllSystemAccessControl(){

                public void checkCanExecuteFunction(SystemSecurityContext systemSecurityContext, FunctionKind functionKind, CatalogSchemaRoutineName functionName) {
                }
            }))).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Access control .* must not implement removed method checkCanExecuteFunction\\(.*\\)");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.setSystemAccessControls((List)ImmutableList.of((Object)new AllowAllSystemAccessControl(){

                public void checkCanGrantExecuteFunctionPrivilege(SystemSecurityContext context, FunctionKind functionKind, CatalogSchemaRoutineName functionName, TrinoPrincipal grantee, boolean grantOption) {
                }
            }))).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Access control .* must not implement removed method checkCanGrantExecuteFunctionPrivilege\\(.*\\)");
            accessControlManager.setSystemAccessControls((List)ImmutableList.of((Object)new AllowAllSystemAccessControl()));
        }
    }

    private AccessControlManager createAccessControlManager(TestingEventListenerManager eventListenerManager, List<String> systemAccessControlProperties) throws IOException {
        Path systemAccessControlConfig = Files.createTempFile("access-control-config-file", ".properties", new FileAttribute[0]);
        Files.write(systemAccessControlConfig, systemAccessControlProperties, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        String accessControlConfigPath = systemAccessControlConfig.toFile().getAbsolutePath();
        return this.createAccessControlManager((EventListenerManager)eventListenerManager, new AccessControlConfig().setAccessControlFiles(accessControlConfigPath));
    }

    private AccessControlManager createAccessControlManager(TransactionManager testTransactionManager) {
        return new AccessControlManager(testTransactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager(), new AccessControlConfig(), OpenTelemetry.noop(), "default");
    }

    private AccessControlManager createAccessControlManager(EventListenerManager eventListenerManager, AccessControlConfig config) {
        return new AccessControlManager(InMemoryTransactionManager.createTestTransactionManager(), eventListenerManager, config, OpenTelemetry.noop(), "default");
    }

    private AccessControlManager createAccessControlManager(EventListenerManager eventListenerManager, String defaultAccessControlName) {
        return new AccessControlManager(InMemoryTransactionManager.createTestTransactionManager(), eventListenerManager, new AccessControlConfig(), OpenTelemetry.noop(), defaultAccessControlName);
    }

    private SystemAccessControlFactory eventListeningSystemAccessControlFactory(final String name, final EventListener ... eventListeners) {
        return new SystemAccessControlFactory(){

            public String getName() {
                return name;
            }

            public SystemAccessControl create(Map<String, String> config) {
                return new SystemAccessControl(){

                    public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
                    }

                    public Iterable<EventListener> getEventListeners() {
                        return ImmutableSet.copyOf((Object[])eventListeners);
                    }
                };
            }
        };
    }

    private static /* synthetic */ void lambda$testDenySystemAccessControl$8(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanSelectFromColumns(TestAccessControlManager.context(transactionId), new QualifiedObjectName("secured_catalog", "schema", "table"), (Set)ImmutableSet.of((Object)"column")));
    }

    private static /* synthetic */ void lambda$testDenyCatalogAccessControl$6(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanSelectFromColumns(TestAccessControlManager.context(transactionId), new QualifiedObjectName("test-catalog", "schema", "table"), (Set)ImmutableSet.of((Object)"column")));
    }

    private static /* synthetic */ void lambda$testReadOnlySystemAccessControl$3(TransactionManager transactionManager, Metadata metadata, AccessControlManager accessControlManager, Identity identity, QualifiedObjectName tableName) throws Throwable {
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanInsertIntoTable(new SecurityContext(transactionId, identity, queryId, queryStart), tableName));
    }

    private static class TestSystemAccessControlFactory
    implements SystemAccessControlFactory {
        private final String name;
        private Map<String, String> config;
        private Optional<Principal> checkedPrincipal;
        private String checkedUserName;

        public TestSystemAccessControlFactory(String name) {
            this.name = Objects.requireNonNull(name, "name is null");
        }

        public Map<String, String> getConfig() {
            return this.config;
        }

        public Optional<Principal> getCheckedPrincipal() {
            return this.checkedPrincipal;
        }

        public String getCheckedUserName() {
            return this.checkedUserName;
        }

        public String getName() {
            return this.name;
        }

        public SystemAccessControl create(Map<String, String> config) {
            this.config = config;
            return new SystemAccessControl(){

                public void checkCanSetUser(Optional<Principal> principal, String userName) {
                    checkedPrincipal = principal;
                    checkedUserName = userName;
                }

                public boolean canAccessCatalog(SystemSecurityContext context, String catalogName) {
                    return true;
                }

                public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
                    throw new UnsupportedOperationException();
                }

                public void checkCanSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
                    if (table.getCatalogName().equals("secured_catalog")) {
                        AccessDeniedException.denySelectTable((String)table.toString());
                    }
                }

                public Set<String> filterCatalogs(SystemSecurityContext context, Set<String> catalogs) {
                    return catalogs;
                }
            };
        }
    }

    private static class DenyConnectorAccessControl
    implements ConnectorAccessControl {
        private DenyConnectorAccessControl() {
        }
    }
}

