/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.airlift.node.NodeInfo;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.connector.CatalogServiceProvider;
import io.trino.metadata.SessionPropertyManager;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.server.SessionPropertyDefaults;
import io.trino.spi.QueryId;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.Identity;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.session.SessionPropertyConfigurationManagerFactory;
import io.trino.spi.session.TestingSessionPropertyConfigurationManagerFactory;
import io.trino.testing.TestingHandles;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestSessionPropertyDefaults {
    private static final ResourceGroupId TEST_RESOURCE_GROUP_ID = new ResourceGroupId("test");
    private static final NodeInfo TEST_NODE_INFO = new NodeInfo("test");

    @Test
    public void testApplyDefaultProperties() {
        SessionPropertyDefaults sessionPropertyDefaults = new SessionPropertyDefaults(TEST_NODE_INFO, (AccessControl)new AllowAllAccessControl());
        ImmutableList catalogProperties = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"explicit_set", (String)"Test property", null, (boolean)false), (Object)PropertyMetadata.stringProperty((String)"catalog_default", (String)"Test property", null, (boolean)false));
        SessionPropertyManager sessionPropertyManager = new SessionPropertyManager((Set)ImmutableSet.of((Object)new SystemSessionProperties()), CatalogServiceProvider.singleton((CatalogHandle)TestingHandles.TEST_CATALOG_HANDLE, (Object)Maps.uniqueIndex((Iterable)catalogProperties, PropertyMetadata::getName)));
        TestingSessionPropertyConfigurationManagerFactory factory = new TestingSessionPropertyConfigurationManagerFactory((Map)ImmutableMap.builder().put((Object)"query_max_memory", (Object)"2GB").put((Object)"query_max_total_memory", (Object)"2GB").buildOrThrow(), (Map)ImmutableMap.of((Object)"test-catalog", (Object)ImmutableMap.builder().put((Object)"explicit_set", (Object)"override").put((Object)"catalog_default", (Object)"catalog_default").buildOrThrow()));
        sessionPropertyDefaults.addConfigurationManagerFactory((SessionPropertyConfigurationManagerFactory)factory);
        sessionPropertyDefaults.setConfigurationManager(factory.getName(), (Map)ImmutableMap.of());
        Session session = Session.builder((SessionPropertyManager)sessionPropertyManager).setQueryId(new QueryId("test_query_id")).setIdentity(Identity.ofUser((String)"testUser")).setOriginalIdentity(Identity.ofUser((String)"testUser")).setSystemProperty("query_max_memory", "1GB").setSystemProperty("join_distribution_type", "partitioned").setSystemProperty("max_hash_partition_count", "43").setCatalogSessionProperty("test-catalog", "explicit_set", "explicit_set").build();
        Assert.assertEquals((Map)session.getSystemProperties(), (Map)ImmutableMap.builder().put((Object)"query_max_memory", (Object)"1GB").put((Object)"join_distribution_type", (Object)"partitioned").put((Object)"max_hash_partition_count", (Object)"43").buildOrThrow());
        Assert.assertEquals((Map)session.getCatalogProperties(), (Map)ImmutableMap.of((Object)"test-catalog", (Object)ImmutableMap.of((Object)"explicit_set", (Object)"explicit_set")));
        session = sessionPropertyDefaults.newSessionWithDefaultProperties(session, Optional.empty(), TEST_RESOURCE_GROUP_ID);
        Assert.assertEquals((Map)session.getSystemProperties(), (Map)ImmutableMap.builder().put((Object)"query_max_memory", (Object)"1GB").put((Object)"join_distribution_type", (Object)"partitioned").put((Object)"max_hash_partition_count", (Object)"43").put((Object)"query_max_total_memory", (Object)"2GB").buildOrThrow());
        Assert.assertEquals((Map)session.getCatalogProperties(), (Map)ImmutableMap.of((Object)"test-catalog", (Object)ImmutableMap.builder().put((Object)"explicit_set", (Object)"explicit_set").put((Object)"catalog_default", (Object)"catalog_default").buildOrThrow()));
    }
}

