/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Type;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.ExpressionInterpreter;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.NoOpSymbolResolver;
import io.trino.sql.planner.SymbolResolver;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SqlToRowExpressionTranslator;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import java.math.BigDecimal;
import java.util.Map;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.testng.Assert;

public class TestSqlToRowExpressionTranslator {
    private final LiteralEncoder literalEncoder = new LiteralEncoder(TestingPlannerContext.PLANNER_CONTEXT);

    @Test
    @Timeout(value=10L)
    public void testPossibleExponentialOptimizationTime() {
        LongLiteral expression = new LongLiteral("1");
        ImmutableMap.Builder types = ImmutableMap.builder();
        types.put((Object)NodeRef.of((Node)expression), (Object)BigintType.BIGINT);
        for (int i = 0; i < 100; ++i) {
            expression = new CoalesceExpression((Expression)expression, (Expression)new LongLiteral("2"), new Expression[0]);
            types.put((Object)NodeRef.of((Node)expression), (Object)BigintType.BIGINT);
        }
        this.translateAndOptimize((Expression)expression, (Map<NodeRef<Expression>, Type>)types.buildOrThrow());
    }

    @Test
    public void testOptimizeDecimalLiteral() {
        Assert.assertEquals((Object)this.translateAndOptimize(PlanBuilder.expression("CAST(NULL AS DECIMAL(7,2))")), (Object)Expressions.constant(null, (Type)DecimalType.createDecimalType((int)7, (int)2)));
        Assert.assertEquals((Object)this.translateAndOptimize(PlanBuilder.expression("DECIMAL '42'")), (Object)Expressions.constant((Object)42L, (Type)DecimalType.createDecimalType((int)2, (int)0)));
        Assert.assertEquals((Object)this.translateAndOptimize(PlanBuilder.expression("CAST(42 AS DECIMAL(7,2))")), (Object)Expressions.constant((Object)4200L, (Type)DecimalType.createDecimalType((int)7, (int)2)));
        Assert.assertEquals((Object)this.translateAndOptimize(this.simplifyExpression(PlanBuilder.expression("CAST(42 AS DECIMAL(7,2))"))), (Object)Expressions.constant((Object)4200L, (Type)DecimalType.createDecimalType((int)7, (int)2)));
        Assert.assertEquals((Object)this.translateAndOptimize(PlanBuilder.expression("CAST(NULL AS DECIMAL(35,2))")), (Object)Expressions.constant(null, (Type)DecimalType.createDecimalType((int)35, (int)2)));
        Assert.assertEquals((Object)this.translateAndOptimize(PlanBuilder.expression("DECIMAL '123456789012345678901234567890'")), (Object)Expressions.constant((Object)Decimals.valueOf((BigDecimal)new BigDecimal("123456789012345678901234567890")), (Type)DecimalType.createDecimalType((int)30, (int)0)));
        Assert.assertEquals((Object)this.translateAndOptimize(PlanBuilder.expression("CAST(DECIMAL '123456789012345678901234567890' AS DECIMAL(35,2))")), (Object)Expressions.constant((Object)Decimals.valueOf((BigDecimal)new BigDecimal("123456789012345678901234567890.00")), (Type)DecimalType.createDecimalType((int)35, (int)2)));
        Assert.assertEquals((Object)this.translateAndOptimize(this.simplifyExpression(PlanBuilder.expression("CAST(DECIMAL '123456789012345678901234567890' AS DECIMAL(35,2))"))), (Object)Expressions.constant((Object)Decimals.valueOf((BigDecimal)new BigDecimal("123456789012345678901234567890.00")), (Type)DecimalType.createDecimalType((int)35, (int)2)));
    }

    private RowExpression translateAndOptimize(Expression expression) {
        return this.translateAndOptimize(expression, this.getExpressionTypes(expression));
    }

    private RowExpression translateAndOptimize(Expression expression, Map<NodeRef<Expression>, Type> types) {
        return SqlToRowExpressionTranslator.translate((Expression)expression, types, (Map)ImmutableMap.of(), (Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), (FunctionManager)TestingPlannerContext.PLANNER_CONTEXT.getFunctionManager(), (Session)SessionTestUtils.TEST_SESSION, (boolean)true);
    }

    private Expression simplifyExpression(Expression expression) {
        Map<NodeRef<Expression>, Type> expressionTypes = this.getExpressionTypes(expression);
        ExpressionInterpreter interpreter = new ExpressionInterpreter(expression, TestingPlannerContext.PLANNER_CONTEXT, SessionTestUtils.TEST_SESSION, expressionTypes);
        Object value = interpreter.optimize((SymbolResolver)NoOpSymbolResolver.INSTANCE);
        return this.literalEncoder.toExpression(value, expressionTypes.get(NodeRef.of((Node)expression)));
    }

    private Map<NodeRef<Expression>, Type> getExpressionTypes(Expression expression) {
        return ExpressionUtils.getExpressionTypes((PlannerContext)TestingPlannerContext.PLANNER_CONTEXT, (Session)SessionTestUtils.TEST_SESSION, (Expression)expression, (TypeProvider)TypeProvider.empty());
    }
}

