/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.slice.SizeOf;
import io.trino.block.BlockAssertions;
import io.trino.operator.PageAssertions;
import io.trino.operator.PagesHashStrategy;
import io.trino.operator.SimplePagesHashStrategy;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.JoinCompiler;
import io.trino.type.BlockTypeOperators;
import io.trino.type.TypeTestUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestJoinCompiler {
    private static final TypeOperators typeOperators = new TypeOperators();
    private static final BlockTypeOperators blockTypeOperators = new BlockTypeOperators(typeOperators);
    private static final JoinCompiler joinCompiler = new JoinCompiler(typeOperators);

    @Test
    public void testSingleChannel() {
        for (boolean hashEnabled : Arrays.asList(true, false)) {
            ImmutableList joinTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
            List joinChannels = Ints.asList((int[])new int[]{0});
            JoinCompiler.PagesHashStrategyFactory pagesHashStrategyFactory = joinCompiler.compilePagesHashStrategyFactory((List)joinTypes, joinChannels);
            ObjectArrayList channel = new ObjectArrayList();
            channel.add((Object)BlockAssertions.createStringSequenceBlock(10, 20));
            channel.add((Object)BlockAssertions.createStringSequenceBlock(20, 30));
            channel.add((Object)BlockAssertions.createStringSequenceBlock(15, 25));
            OptionalInt hashChannel = OptionalInt.empty();
            ImmutableList channels = ImmutableList.of((Object)channel);
            if (hashEnabled) {
                ObjectArrayList hashChannelBuilder = new ObjectArrayList();
                for (Block block : channel) {
                    hashChannelBuilder.add((Object)TypeTestUtils.getHashBlock((List<? extends Type>)joinTypes, block));
                }
                hashChannel = OptionalInt.of(1);
                channels = ImmutableList.of((Object)channel, (Object)hashChannelBuilder);
            }
            PagesHashStrategy hashStrategy = pagesHashStrategyFactory.createPagesHashStrategy((List)channels, hashChannel);
            Assert.assertEquals((int)hashStrategy.getChannelCount(), (int)1);
            BlockTypeOperators blockTypeOperators = new BlockTypeOperators();
            BlockTypeOperators.BlockPositionEqual equalOperator = blockTypeOperators.getEqualOperator((Type)VarcharType.VARCHAR);
            BlockTypeOperators.BlockPositionIsDistinctFrom distinctFromOperator = blockTypeOperators.getDistinctFromOperator((Type)VarcharType.VARCHAR);
            BlockTypeOperators.BlockPositionHashCode hashCodeOperator = blockTypeOperators.getHashCodeOperator((Type)VarcharType.VARCHAR);
            for (int leftBlockIndex = 0; leftBlockIndex < channel.size(); ++leftBlockIndex) {
                Block leftBlock = (Block)channel.get(leftBlockIndex);
                PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)VarcharType.VARCHAR));
                for (int leftBlockPosition = 0; leftBlockPosition < leftBlock.getPositionCount(); ++leftBlockPosition) {
                    boolean expectedNotDistinct;
                    boolean expected;
                    int rightBlockPosition;
                    Block rightBlock;
                    int rightBlockIndex;
                    Assert.assertEquals((long)hashStrategy.hashPosition(leftBlockIndex, leftBlockPosition), (long)hashCodeOperator.hashCodeNullSafe(leftBlock, leftBlockPosition));
                    Assert.assertTrue((boolean)hashStrategy.positionEqualsPositionIgnoreNulls(leftBlockIndex, leftBlockPosition, leftBlockIndex, leftBlockPosition));
                    for (rightBlockIndex = 0; rightBlockIndex < channel.size(); ++rightBlockIndex) {
                        rightBlock = (Block)channel.get(rightBlockIndex);
                        for (rightBlockPosition = 0; rightBlockPosition < rightBlock.getPositionCount(); ++rightBlockPosition) {
                            expected = equalOperator.equalNullSafe(leftBlock, leftBlockPosition, rightBlock, rightBlockPosition);
                            expectedNotDistinct = !distinctFromOperator.isDistinctFrom(leftBlock, leftBlockPosition, rightBlock, rightBlockPosition);
                            Assert.assertEquals((boolean)hashStrategy.positionEqualsRow(leftBlockIndex, leftBlockPosition, rightBlockPosition, new Page(new Block[]{rightBlock})), (boolean)expected);
                            Assert.assertEquals((boolean)hashStrategy.positionNotDistinctFromRow(leftBlockIndex, leftBlockPosition, rightBlockPosition, new Page(new Block[]{rightBlock})), (boolean)expectedNotDistinct);
                            Assert.assertEquals((boolean)hashStrategy.rowEqualsRow(leftBlockPosition, new Page(new Block[]{leftBlock}), rightBlockPosition, new Page(new Block[]{rightBlock})), (boolean)expected);
                            Assert.assertEquals((boolean)hashStrategy.rowNotDistinctFromRow(leftBlockPosition, new Page(new Block[]{leftBlock}), rightBlockPosition, new Page(new Block[]{rightBlock})), (boolean)expectedNotDistinct);
                            Assert.assertEquals((boolean)hashStrategy.positionEqualsRowIgnoreNulls(leftBlockIndex, leftBlockPosition, rightBlockPosition, new Page(new Block[]{rightBlock})), (boolean)expected);
                            Assert.assertEquals((boolean)hashStrategy.positionEqualsPositionIgnoreNulls(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition), (boolean)expected);
                            Assert.assertEquals((boolean)hashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition), (boolean)expected);
                            Assert.assertEquals((boolean)hashStrategy.positionNotDistinctFromPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition), (boolean)expectedNotDistinct);
                        }
                    }
                    for (rightBlockIndex = 0; rightBlockIndex < channel.size(); ++rightBlockIndex) {
                        rightBlock = (Block)channel.get(rightBlockIndex);
                        for (rightBlockPosition = 0; rightBlockPosition < rightBlock.getPositionCount(); ++rightBlockPosition) {
                            expected = equalOperator.equalNullSafe(leftBlock, leftBlockPosition, rightBlock, rightBlockPosition);
                            expectedNotDistinct = !distinctFromOperator.isDistinctFrom(leftBlock, leftBlockPosition, rightBlock, rightBlockPosition);
                            Assert.assertEquals((boolean)hashStrategy.positionEqualsRow(leftBlockIndex, leftBlockPosition, rightBlockPosition, new Page(new Block[]{rightBlock})), (boolean)expected);
                            Assert.assertEquals((boolean)hashStrategy.positionNotDistinctFromRow(leftBlockIndex, leftBlockPosition, rightBlockPosition, new Page(new Block[]{rightBlock})), (boolean)expectedNotDistinct);
                            Assert.assertEquals((boolean)hashStrategy.rowEqualsRow(leftBlockPosition, new Page(new Block[]{leftBlock}), rightBlockPosition, new Page(new Block[]{rightBlock})), (boolean)expected);
                            Assert.assertEquals((boolean)hashStrategy.rowNotDistinctFromRow(leftBlockPosition, new Page(new Block[]{leftBlock}), rightBlockPosition, new Page(new Block[]{rightBlock})), (boolean)expectedNotDistinct);
                            Assert.assertEquals((boolean)hashStrategy.positionEqualsRowIgnoreNulls(leftBlockIndex, leftBlockPosition, rightBlockPosition, new Page(new Block[]{rightBlock})), (boolean)expected);
                            Assert.assertEquals((boolean)hashStrategy.positionEqualsPositionIgnoreNulls(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition), (boolean)expected);
                            Assert.assertEquals((boolean)hashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition), (boolean)expected);
                            Assert.assertEquals((boolean)hashStrategy.positionNotDistinctFromPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition), (boolean)expectedNotDistinct);
                        }
                    }
                    pageBuilder.declarePosition();
                    hashStrategy.appendTo(leftBlockIndex, leftBlockPosition, pageBuilder, 0);
                }
                BlockAssertions.assertBlockEquals((Type)VarcharType.VARCHAR, pageBuilder.build().getBlock(0), leftBlock);
            }
        }
    }

    @Test
    public void testMultiChannel() {
        for (boolean hashEnabled : Arrays.asList(true, false)) {
            ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR);
            ImmutableList joinTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN);
            ImmutableList outputTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR);
            List joinChannels = Ints.asList((int[])new int[]{1, 2, 3, 4});
            List outputChannels = Ints.asList((int[])new int[]{1, 2, 3, 4, 0});
            ObjectArrayList extraChannel = new ObjectArrayList();
            extraChannel.add((Object)BlockAssertions.createStringSequenceBlock(10, 20));
            extraChannel.add((Object)BlockAssertions.createStringSequenceBlock(20, 30));
            extraChannel.add((Object)BlockAssertions.createStringSequenceBlock(15, 25));
            ObjectArrayList varcharChannel = new ObjectArrayList();
            varcharChannel.add((Object)BlockAssertions.createStringSequenceBlock(10, 20));
            varcharChannel.add((Object)BlockAssertions.createStringSequenceBlock(20, 30));
            varcharChannel.add((Object)BlockAssertions.createStringSequenceBlock(15, 25));
            ObjectArrayList longChannel = new ObjectArrayList();
            longChannel.add((Object)BlockAssertions.createLongSequenceBlock(10, 20));
            longChannel.add((Object)BlockAssertions.createLongSequenceBlock(20, 30));
            longChannel.add((Object)BlockAssertions.createLongSequenceBlock(15, 25));
            ObjectArrayList doubleChannel = new ObjectArrayList();
            doubleChannel.add((Object)BlockAssertions.createDoubleSequenceBlock(10, 20));
            doubleChannel.add((Object)BlockAssertions.createDoubleSequenceBlock(20, 30));
            doubleChannel.add((Object)BlockAssertions.createDoubleSequenceBlock(15, 25));
            ObjectArrayList booleanChannel = new ObjectArrayList();
            booleanChannel.add((Object)BlockAssertions.createBooleanSequenceBlock(10, 20));
            booleanChannel.add((Object)BlockAssertions.createBooleanSequenceBlock(20, 30));
            booleanChannel.add((Object)BlockAssertions.createBooleanSequenceBlock(15, 25));
            ObjectArrayList extraUnusedChannel = new ObjectArrayList();
            extraUnusedChannel.add((Object)BlockAssertions.createBooleanSequenceBlock(10, 20));
            extraUnusedChannel.add((Object)BlockAssertions.createBooleanSequenceBlock(20, 30));
            extraUnusedChannel.add((Object)BlockAssertions.createBooleanSequenceBlock(15, 25));
            OptionalInt hashChannel = OptionalInt.empty();
            ImmutableList channels = ImmutableList.of((Object)extraChannel, (Object)varcharChannel, (Object)longChannel, (Object)doubleChannel, (Object)booleanChannel, (Object)extraUnusedChannel);
            ObjectArrayList precomputedHash = new ObjectArrayList();
            if (hashEnabled) {
                for (int i = 0; i < 3; ++i) {
                    precomputedHash.add((Object)TypeTestUtils.getHashBlock((List<? extends Type>)joinTypes, (Block)varcharChannel.get(i), (Block)longChannel.get(i), (Block)doubleChannel.get(i), (Block)booleanChannel.get(i)));
                }
                hashChannel = OptionalInt.of(6);
                channels = ImmutableList.of((Object)extraChannel, (Object)varcharChannel, (Object)longChannel, (Object)doubleChannel, (Object)booleanChannel, (Object)extraUnusedChannel, (Object)precomputedHash);
                types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT);
                outputTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT);
                outputChannels = Ints.asList((int[])new int[]{1, 2, 3, 4, 0, 6});
            }
            JoinCompiler.PagesHashStrategyFactory pagesHashStrategyFactory = joinCompiler.compilePagesHashStrategyFactory((List)types, joinChannels, Optional.of(outputChannels));
            PagesHashStrategy hashStrategy = pagesHashStrategyFactory.createPagesHashStrategy((List)channels, hashChannel);
            SimplePagesHashStrategy expectedHashStrategy = new SimplePagesHashStrategy((List)types, outputChannels, (List)channels, joinChannels, hashChannel, Optional.empty(), blockTypeOperators);
            Assert.assertEquals((int)hashStrategy.getChannelCount(), (int)outputChannels.size());
            int instanceSize = SizeOf.instanceSize(hashStrategy.getClass());
            long sizeInBytes = (long)instanceSize + (channels.size() > 0 ? SizeOf.sizeOf((Object[])((ObjectArrayList)channels.get(0)).elements()) * (long)channels.size() : 0L) + channels.stream().flatMap(Collection::stream).mapToLong(Block::getRetainedSizeInBytes).sum();
            Assert.assertEquals((long)hashStrategy.getSizeInBytes(), (long)sizeInBytes);
            for (int leftBlockIndex = 0; leftBlockIndex < varcharChannel.size(); ++leftBlockIndex) {
                PageBuilder pageBuilder = new PageBuilder((List)outputTypes);
                Block[] leftBlocks = new Block[]{(Block)varcharChannel.get(leftBlockIndex), (Block)longChannel.get(leftBlockIndex), (Block)doubleChannel.get(leftBlockIndex), (Block)booleanChannel.get(leftBlockIndex)};
                int leftPositionCount = ((Block)varcharChannel.get(leftBlockIndex)).getPositionCount();
                for (int leftBlockPosition = 0; leftBlockPosition < leftPositionCount; ++leftBlockPosition) {
                    int rightBlockIndex;
                    Assert.assertEquals((long)hashStrategy.hashPosition(leftBlockIndex, leftBlockPosition), (long)expectedHashStrategy.hashPosition(leftBlockIndex, leftBlockPosition));
                    Assert.assertTrue((boolean)hashStrategy.positionEqualsPositionIgnoreNulls(leftBlockIndex, leftBlockPosition, leftBlockIndex, leftBlockPosition));
                    Assert.assertTrue((boolean)hashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, leftBlockIndex, leftBlockPosition));
                    Assert.assertTrue((boolean)hashStrategy.positionNotDistinctFromPosition(leftBlockIndex, leftBlockPosition, leftBlockIndex, leftBlockPosition));
                    for (rightBlockIndex = 0; rightBlockIndex < varcharChannel.size(); ++rightBlockIndex) {
                        Block rightBlock = (Block)varcharChannel.get(rightBlockIndex);
                        for (int rightBlockPosition = 0; rightBlockPosition < rightBlock.getPositionCount(); ++rightBlockPosition) {
                            Assert.assertEquals((boolean)hashStrategy.positionEqualsPositionIgnoreNulls(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition), (boolean)expectedHashStrategy.positionEqualsPositionIgnoreNulls(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition));
                            Assert.assertEquals((boolean)hashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition), (boolean)expectedHashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition));
                            Assert.assertEquals((boolean)hashStrategy.positionNotDistinctFromPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition), (boolean)expectedHashStrategy.positionNotDistinctFromPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition));
                        }
                    }
                    for (rightBlockIndex = 0; rightBlockIndex < varcharChannel.size(); ++rightBlockIndex) {
                        Block[] rightBlocks = new Block[]{(Block)varcharChannel.get(rightBlockIndex), (Block)longChannel.get(rightBlockIndex), (Block)doubleChannel.get(rightBlockIndex), (Block)booleanChannel.get(rightBlockIndex)};
                        int rightPositionCount = ((Block)varcharChannel.get(rightBlockIndex)).getPositionCount();
                        for (int rightPosition = 0; rightPosition < rightPositionCount; ++rightPosition) {
                            boolean expected = expectedHashStrategy.positionEqualsRow(leftBlockIndex, leftBlockPosition, rightPosition, new Page(rightBlocks));
                            boolean expectedNotDistinct = expectedHashStrategy.positionNotDistinctFromRow(leftBlockIndex, leftBlockPosition, rightPosition, new Page(rightBlocks));
                            Assert.assertEquals((boolean)hashStrategy.positionEqualsRow(leftBlockIndex, leftBlockPosition, rightPosition, new Page(rightBlocks)), (boolean)expected);
                            Assert.assertEquals((boolean)hashStrategy.positionNotDistinctFromRow(leftBlockIndex, leftBlockPosition, rightPosition, new Page(rightBlocks)), (boolean)expectedNotDistinct);
                            Assert.assertEquals((boolean)hashStrategy.rowEqualsRow(leftBlockPosition, new Page(leftBlocks), rightPosition, new Page(rightBlocks)), (boolean)expected);
                            Assert.assertEquals((boolean)hashStrategy.rowNotDistinctFromRow(leftBlockPosition, new Page(leftBlocks), rightPosition, new Page(rightBlocks)), (boolean)expectedNotDistinct);
                            Assert.assertEquals((boolean)hashStrategy.positionEqualsRowIgnoreNulls(leftBlockIndex, leftBlockPosition, rightPosition, new Page(rightBlocks)), (boolean)expected);
                        }
                    }
                    pageBuilder.declarePosition();
                    hashStrategy.appendTo(leftBlockIndex, leftBlockPosition, pageBuilder, 0);
                }
                Page page = pageBuilder.build();
                if (hashEnabled) {
                    PageAssertions.assertPageEquals((List<? extends Type>)outputTypes, page, new Page(new Block[]{(Block)varcharChannel.get(leftBlockIndex), (Block)longChannel.get(leftBlockIndex), (Block)doubleChannel.get(leftBlockIndex), (Block)booleanChannel.get(leftBlockIndex), (Block)extraChannel.get(leftBlockIndex), (Block)precomputedHash.get(leftBlockIndex)}));
                    continue;
                }
                PageAssertions.assertPageEquals((List<? extends Type>)outputTypes, page, new Page(new Block[]{(Block)varcharChannel.get(leftBlockIndex), (Block)longChannel.get(leftBlockIndex), (Block)doubleChannel.get(leftBlockIndex), (Block)booleanChannel.get(leftBlockIndex), (Block)extraChannel.get(leftBlockIndex)}));
            }
        }
    }

    @Test
    public void testDistinctFrom() {
        ImmutableList joinTypes = ImmutableList.of((Object)DoubleType.DOUBLE);
        List joinChannels = Ints.asList((int[])new int[]{0});
        JoinCompiler.PagesHashStrategyFactory pagesHashStrategyFactory = joinCompiler.compilePagesHashStrategyFactory((List)joinTypes, joinChannels);
        ObjectArrayList channel = new ObjectArrayList();
        channel.add((Object)BlockAssertions.createDoubleSequenceBlock(10, 20));
        channel.add((Object)BlockAssertions.createDoublesBlock(Double.NaN, null, Double.NaN, 1.0, null));
        channel.add((Object)BlockAssertions.createDoubleSequenceBlock(20, 30));
        channel.add((Object)BlockAssertions.createDoubleSequenceBlock(15, 25));
        PagesHashStrategy hashStrategy = pagesHashStrategyFactory.createPagesHashStrategy((List)ImmutableList.of((Object)channel), OptionalInt.empty());
        Assert.assertEquals((int)hashStrategy.getChannelCount(), (int)1);
        BlockTypeOperators blockTypeOperators = new BlockTypeOperators();
        BlockTypeOperators.BlockPositionIsDistinctFrom distinctFromOperator = blockTypeOperators.getDistinctFromOperator((Type)DoubleType.DOUBLE);
        for (int leftBlockIndex = 0; leftBlockIndex < channel.size(); ++leftBlockIndex) {
            Block leftBlock = (Block)channel.get(leftBlockIndex);
            for (int leftBlockPosition = 0; leftBlockPosition < leftBlock.getPositionCount(); ++leftBlockPosition) {
                boolean expectedNotDistinct;
                int rightBlockPosition;
                Block rightBlock;
                int rightBlockIndex;
                Assert.assertTrue((boolean)hashStrategy.positionNotDistinctFromPosition(leftBlockIndex, leftBlockPosition, leftBlockIndex, leftBlockPosition));
                for (rightBlockIndex = 0; rightBlockIndex < channel.size(); ++rightBlockIndex) {
                    rightBlock = (Block)channel.get(rightBlockIndex);
                    for (rightBlockPosition = 0; rightBlockPosition < rightBlock.getPositionCount(); ++rightBlockPosition) {
                        expectedNotDistinct = !distinctFromOperator.isDistinctFrom(leftBlock, leftBlockPosition, rightBlock, rightBlockPosition);
                        Assert.assertEquals((boolean)hashStrategy.positionNotDistinctFromRow(leftBlockIndex, leftBlockPosition, rightBlockPosition, new Page(new Block[]{rightBlock})), (boolean)expectedNotDistinct);
                        Assert.assertEquals((boolean)hashStrategy.rowNotDistinctFromRow(leftBlockPosition, new Page(new Block[]{leftBlock}), rightBlockPosition, new Page(new Block[]{rightBlock})), (boolean)expectedNotDistinct);
                        Assert.assertEquals((boolean)hashStrategy.positionNotDistinctFromPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition), (boolean)expectedNotDistinct);
                    }
                }
                for (rightBlockIndex = 0; rightBlockIndex < channel.size(); ++rightBlockIndex) {
                    rightBlock = (Block)channel.get(rightBlockIndex);
                    for (rightBlockPosition = 0; rightBlockPosition < rightBlock.getPositionCount(); ++rightBlockPosition) {
                        expectedNotDistinct = !distinctFromOperator.isDistinctFrom(leftBlock, leftBlockPosition, rightBlock, rightBlockPosition);
                        Assert.assertEquals((boolean)hashStrategy.positionNotDistinctFromRow(leftBlockIndex, leftBlockPosition, rightBlockPosition, new Page(new Block[]{rightBlock})), (boolean)expectedNotDistinct);
                        Assert.assertEquals((boolean)hashStrategy.rowNotDistinctFromRow(leftBlockPosition, new Page(new Block[]{leftBlock}), rightBlockPosition, new Page(new Block[]{rightBlock})), (boolean)expectedNotDistinct);
                        Assert.assertEquals((boolean)hashStrategy.positionNotDistinctFromPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition), (boolean)expectedNotDistinct);
                    }
                }
            }
        }
    }
}

