/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.Metadata;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.NullLiteral;
import io.trino.type.FunctionType;
import java.util.List;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestDeterminismEvaluator {
    private final TestingFunctionResolution functionResolution = new TestingFunctionResolution();

    @Test
    public void testSanity() {
        Metadata metadata = this.functionResolution.getMetadata();
        Assert.assertFalse((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("rand"), (Metadata)metadata));
        Assert.assertFalse((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("random"), (Metadata)metadata));
        Assert.assertFalse((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("shuffle", (List<Type>)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR)), (List<Expression>)ImmutableList.of((Object)new NullLiteral())), (Metadata)metadata));
        Assert.assertFalse((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("uuid"), (Metadata)metadata));
        Assert.assertTrue((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("abs", (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (List<Expression>)ImmutableList.of((Object)TestDeterminismEvaluator.input("symbol"))), (Metadata)metadata));
        Assert.assertFalse((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("abs", (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (List<Expression>)ImmutableList.of((Object)this.function("rand"))), (Metadata)metadata));
        Assert.assertTrue((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("abs", (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (List<Expression>)ImmutableList.of((Object)this.function("abs", (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (List<Expression>)ImmutableList.of((Object)TestDeterminismEvaluator.input("symbol"))))), (Metadata)metadata));
        Assert.assertTrue((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("filter", (List<Type>)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)BooleanType.BOOLEAN)), (List<Expression>)ImmutableList.of((Object)TestDeterminismEvaluator.lambda("a", (Expression)TestDeterminismEvaluator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)TestDeterminismEvaluator.input("a"), (Expression)new LongLiteral("0"))))), (Metadata)metadata));
        Assert.assertFalse((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("filter", (List<Type>)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER), (Object)new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)BooleanType.BOOLEAN)), (List<Expression>)ImmutableList.of((Object)TestDeterminismEvaluator.lambda("a", (Expression)TestDeterminismEvaluator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)this.function("rand", (List<Type>)ImmutableList.of((Object)IntegerType.INTEGER), (List<Expression>)ImmutableList.of((Object)TestDeterminismEvaluator.input("a"))), (Expression)new LongLiteral("0"))))), (Metadata)metadata));
    }

    private FunctionCall function(String name) {
        return this.function(name, (List<Type>)ImmutableList.of(), (List<Expression>)ImmutableList.of());
    }

    private FunctionCall function(String name, List<Type> types, List<Expression> arguments) {
        return this.functionResolution.functionCallBuilder(name).setArguments(types, arguments).build();
    }

    private static Identifier input(String symbol) {
        return new Identifier(symbol);
    }

    private static ComparisonExpression comparison(ComparisonExpression.Operator operator, Expression left, Expression right) {
        return new ComparisonExpression(operator, left, right);
    }

    private static LambdaExpression lambda(String symbol, Expression body) {
        return new LambdaExpression((List)ImmutableList.of((Object)new LambdaArgumentDeclaration(TestDeterminismEvaluator.input(symbol))), body);
    }
}

