/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.connector.MockConnectorColumnHandle;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.spi.Plugin;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneTableScanColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.iterative.rule.test.RuleTester;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;

public class TestPruneTableScanColumns
extends BaseRuleTest {
    public TestPruneTableScanColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneTableScanColumns(this.tester().getMetadata())).on(p -> {
            Symbol orderdate = p.symbol("orderdate", (Type)DateType.DATE);
            Symbol totalprice = p.symbol("totalprice", (Type)DoubleType.DOUBLE);
            return p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)totalprice.toSymbolReference()), (PlanNode)p.tableScan(this.tester().getCurrentCatalogTableHandle("tiny", "orders"), (List<Symbol>)ImmutableList.of((Object)orderdate, (Object)totalprice), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)orderdate, (Object)new TpchColumnHandle(orderdate.getName(), (Type)DateType.DATE), (Object)totalprice, (Object)new TpchColumnHandle(totalprice.getName(), (Type)DoubleType.DOUBLE))));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x_", (Object)PlanMatchPattern.expression("totalprice_")), PlanMatchPattern.strictTableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice_", (Object)"totalprice"))));
    }

    @Test
    public void testPruneEnforcedConstraint() {
        this.tester().assertThat((Rule<?>)new PruneTableScanColumns(this.tester().getMetadata())).on(p -> {
            Symbol orderdate = p.symbol("orderdate", (Type)DateType.DATE);
            Symbol totalprice = p.symbol("totalprice", (Type)DoubleType.DOUBLE);
            TpchColumnHandle orderdateHandle = new TpchColumnHandle(orderdate.getName(), (Type)DateType.DATE);
            TpchColumnHandle totalpriceHandle = new TpchColumnHandle(totalprice.getName(), (Type)DoubleType.DOUBLE);
            return p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)totalprice.toSymbolReference()), (PlanNode)p.tableScan(this.tester().getCurrentCatalogTableHandle("tiny", "orders"), List.of(orderdate, totalprice), Map.of(orderdate, orderdateHandle, totalprice, totalpriceHandle), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains(Map.of(orderdateHandle, Domain.notNull((Type)DateType.DATE), totalpriceHandle, Domain.notNull((Type)DoubleType.DOUBLE)))));
        }).matches(PlanMatchPattern.strictProject(Map.of("X", PlanMatchPattern.expression("TOTALPRICE")), PlanMatchPattern.strictConstrainedTableScan("orders", Map.of("TOTALPRICE", "totalprice"), Map.of("totalprice", Domain.notNull((Type)DoubleType.DOUBLE)))));
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneTableScanColumns(this.tester().getMetadata())).on(p -> p.project(Assignments.of((Symbol)p.symbol("y"), (Expression)PlanBuilder.expression("x")), (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of((Object)p.symbol("x")), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("x"), (Object)new TestingMetadata.TestingColumnHandle("x"))))).doesNotFire();
    }

    @Test
    public void testPushColumnPruningProjection() {
        String testSchema = "test_schema";
        String testTable = "test_table";
        SchemaTableName testSchemaTable = new SchemaTableName(testSchema, testTable);
        MockConnectorColumnHandle columnHandleA = new MockConnectorColumnHandle("cola", (Type)DateType.DATE);
        MockConnectorColumnHandle columnHandleB = new MockConnectorColumnHandle("colb", (Type)DoubleType.DOUBLE);
        ImmutableMap assignments = ImmutableMap.of((Object)"cola", (Object)columnHandleA, (Object)"colb", (Object)columnHandleB);
        MockConnectorFactory factory = MockConnectorFactory.builder().withListSchemaNames(connectorSession -> ImmutableList.of((Object)testSchema)).withListTables((connectorSession, schema) -> testSchema.equals(schema) ? ImmutableList.of((Object)testTable) : ImmutableList.of()).withGetColumns(arg_0 -> TestPruneTableScanColumns.lambda$testPushColumnPruningProjection$6((Map)assignments, arg_0)).withApplyProjection(this::mockApplyProjection).build();
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(factory).build();){
            ruleTester.assertThat((Rule<?>)new PruneTableScanColumns(ruleTester.getMetadata())).withSession(TestingSession.testSessionBuilder().setCatalog("test-catalog").setSchema(testSchema).build()).on(p -> {
                Symbol symbolA = p.symbol("cola", (Type)DateType.DATE);
                Symbol symbolB = p.symbol("colb", (Type)DoubleType.DOUBLE);
                return p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)symbolB.toSymbolReference()), (PlanNode)p.tableScan(ruleTester.getCurrentCatalogTableHandle(testSchema, testTable), (List<Symbol>)ImmutableList.of((Object)symbolA, (Object)symbolB), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)symbolA, (Object)columnHandleA, (Object)symbolB, (Object)columnHandleB)));
            }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("COLB")), PlanMatchPattern.tableScan(new MockConnectorTableHandle(testSchemaTable, (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.of(ImmutableList.of((Object)columnHandleB)))::equals, (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)"COLB", arg_0 -> ((ColumnHandle)columnHandleB).equals(arg_0)))));
        }
    }

    private Optional<ProjectionApplicationResult<ConnectorTableHandle>> mockApplyProjection(ConnectorSession session, ConnectorTableHandle tableHandle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        MockConnectorTableHandle handle = (MockConnectorTableHandle)tableHandle;
        List variables = (List)projections.stream().map(Variable.class::cast).collect(ImmutableList.toImmutableList());
        List newColumns = (List)variables.stream().map(variable -> (ColumnHandle)assignments.get(variable.getName())).collect(ImmutableList.toImmutableList());
        if (handle.getColumns().isPresent() && newColumns.equals(handle.getColumns().get())) {
            return Optional.empty();
        }
        return Optional.of(new ProjectionApplicationResult((Object)new MockConnectorTableHandle(handle.getTableName(), handle.getConstraint(), Optional.of(newColumns)), projections, (List)variables.stream().map(variable -> new Assignment(variable.getName(), (ColumnHandle)assignments.get(variable.getName()), ((MockConnectorColumnHandle)assignments.get(variable.getName())).getType())).collect(ImmutableList.toImmutableList()), false));
    }

    private static /* synthetic */ List lambda$testPushColumnPruningProjection$6(Map assignments, SchemaTableName schemaTableName) {
        return (List)assignments.entrySet().stream().map(entry -> new ColumnMetadata((String)entry.getKey(), ((MockConnectorColumnHandle)entry.getValue()).getType())).collect(ImmutableList.toImmutableList());
    }
}

