/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneWindowColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.WindowFrame;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;

public class TestPruneWindowColumns
extends BaseRuleTest {
    private static final ResolvedFunction MIN_FUNCTION = new TestingFunctionResolution().resolveFunction("min", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
    private static final List<String> inputSymbolNameList = ImmutableList.of((Object)"orderKey", (Object)"partitionKey", (Object)"hash", (Object)"startValue1", (Object)"startValue2", (Object)"endValue1", (Object)"endValue2", (Object)"input1", (Object)"input2", (Object)"unused");
    private static final Set<String> inputSymbolNameSet = ImmutableSet.copyOf(inputSymbolNameList);
    private static final ExpectedValueProvider<WindowNode.Frame> frameProvider1 = PlanMatchPattern.windowFrame(WindowFrame.Type.RANGE, FrameBound.Type.UNBOUNDED_PRECEDING, Optional.of("startValue1"), FrameBound.Type.CURRENT_ROW, Optional.of("endValue1"), Optional.of("orderKey"));
    private static final ExpectedValueProvider<WindowNode.Frame> frameProvider2 = PlanMatchPattern.windowFrame(WindowFrame.Type.RANGE, FrameBound.Type.UNBOUNDED_PRECEDING, Optional.of("startValue2"), FrameBound.Type.CURRENT_ROW, Optional.of("endValue2"), Optional.of("orderKey"));

    public TestPruneWindowColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testWindowNotNeeded() {
        this.tester().assertThat((Rule<?>)new PruneWindowColumns()).on(p -> TestPruneWindowColumns.buildProjectedWindow(p, symbol -> inputSymbolNameSet.contains(symbol.getName()), (Predicate<Symbol>)Predicates.alwaysTrue())).matches(PlanMatchPattern.strictProject(Maps.asMap(inputSymbolNameSet, PlanMatchPattern::expression), PlanMatchPattern.values(inputSymbolNameList)));
    }

    @Test
    public void testOneFunctionNotNeeded() {
        this.tester().assertThat((Rule<?>)new PruneWindowColumns()).on(p -> TestPruneWindowColumns.buildProjectedWindow(p, symbol -> symbol.getName().equals("output2") || symbol.getName().equals("unused"), (Predicate<Symbol>)Predicates.alwaysTrue())).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"output2", (Object)PlanMatchPattern.expression("output2"), (Object)"unused", (Object)PlanMatchPattern.expression("unused")), PlanMatchPattern.window(windowBuilder -> windowBuilder.prePartitionedInputs((Set<String>)ImmutableSet.of()).specification((List<String>)ImmutableList.of((Object)"partitionKey"), (List<String>)ImmutableList.of((Object)"orderKey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"orderKey", (Object)SortOrder.ASC_NULLS_FIRST)).preSortedOrderPrefix(0).addFunction("output2", PlanMatchPattern.functionCall("min", (List<String>)ImmutableList.of((Object)"input2")), MIN_FUNCTION, frameProvider2).hashSymbol("hash"), PlanMatchPattern.strictProject(Maps.asMap((Set)Sets.difference(inputSymbolNameSet, (Set)ImmutableSet.of((Object)"input1", (Object)"startValue1", (Object)"endValue1")), PlanMatchPattern::expression), PlanMatchPattern.values(inputSymbolNameList)))));
    }

    @Test
    public void testAllColumnsNeeded() {
        this.tester().assertThat((Rule<?>)new PruneWindowColumns()).on(p -> TestPruneWindowColumns.buildProjectedWindow(p, (Predicate<Symbol>)Predicates.alwaysTrue(), (Predicate<Symbol>)Predicates.alwaysTrue())).doesNotFire();
    }

    @Test
    public void testUsedInputsNotNeeded() {
        this.tester().assertThat((Rule<?>)new PruneWindowColumns()).on(p -> TestPruneWindowColumns.buildProjectedWindow(p, symbol -> !inputSymbolNameSet.contains(symbol.getName()), symbol -> !symbol.getName().equals("unused"))).doesNotFire();
    }

    @Test
    public void testUnusedInputNotNeeded() {
        this.tester().assertThat((Rule<?>)new PruneWindowColumns()).on(p -> TestPruneWindowColumns.buildProjectedWindow(p, symbol -> !inputSymbolNameSet.contains(symbol.getName()), (Predicate<Symbol>)Predicates.alwaysTrue())).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"output1", (Object)PlanMatchPattern.expression("output1"), (Object)"output2", (Object)PlanMatchPattern.expression("output2")), PlanMatchPattern.window(windowBuilder -> windowBuilder.prePartitionedInputs((Set<String>)ImmutableSet.of()).specification((List<String>)ImmutableList.of((Object)"partitionKey"), (List<String>)ImmutableList.of((Object)"orderKey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"orderKey", (Object)SortOrder.ASC_NULLS_FIRST)).preSortedOrderPrefix(0).addFunction("output1", PlanMatchPattern.functionCall("min", (List<String>)ImmutableList.of((Object)"input1")), MIN_FUNCTION, frameProvider1).addFunction("output2", PlanMatchPattern.functionCall("min", (List<String>)ImmutableList.of((Object)"input2")), MIN_FUNCTION, frameProvider2).hashSymbol("hash"), PlanMatchPattern.strictProject(Maps.asMap((Set)Sets.filter(inputSymbolNameSet, symbolName -> !symbolName.equals("unused")), PlanMatchPattern::expression), PlanMatchPattern.values(inputSymbolNameList)))));
    }

    private static PlanNode buildProjectedWindow(PlanBuilder p, Predicate<Symbol> projectionFilter, Predicate<Symbol> sourceFilter) {
        Symbol orderKey = p.symbol("orderKey");
        Symbol partitionKey = p.symbol("partitionKey");
        Symbol hash = p.symbol("hash");
        Symbol startValue1 = p.symbol("startValue1");
        Symbol startValue2 = p.symbol("startValue2");
        Symbol endValue1 = p.symbol("endValue1");
        Symbol endValue2 = p.symbol("endValue2");
        Symbol input1 = p.symbol("input1");
        Symbol input2 = p.symbol("input2");
        Symbol unused = p.symbol("unused");
        Symbol output1 = p.symbol("output1");
        Symbol output2 = p.symbol("output2");
        ImmutableList inputs = ImmutableList.of((Object)orderKey, (Object)partitionKey, (Object)hash, (Object)startValue1, (Object)startValue2, (Object)endValue1, (Object)endValue2, (Object)input1, (Object)input2, (Object)unused);
        ImmutableList outputs = ImmutableList.builder().addAll((Iterable)inputs).add((Object[])new Symbol[]{output1, output2}).build();
        return p.project(Assignments.identity((Iterable)((Iterable)outputs.stream().filter(projectionFilter).collect(ImmutableList.toImmutableList()))), (PlanNode)p.window(new DataOrganizationSpecification((List)ImmutableList.of((Object)partitionKey), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)orderKey), (Map)ImmutableMap.of((Object)orderKey, (Object)SortOrder.ASC_NULLS_FIRST)))), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)output1, (Object)new WindowNode.Function(MIN_FUNCTION, (List)ImmutableList.of((Object)input1.toSymbolReference()), new WindowNode.Frame(WindowFrame.Type.RANGE, FrameBound.Type.UNBOUNDED_PRECEDING, Optional.of(startValue1), Optional.of(orderKey), FrameBound.Type.CURRENT_ROW, Optional.of(endValue1), Optional.of(orderKey), Optional.of(startValue1.toSymbolReference()), Optional.of(endValue2.toSymbolReference())), false), (Object)output2, (Object)new WindowNode.Function(MIN_FUNCTION, (List)ImmutableList.of((Object)input2.toSymbolReference()), new WindowNode.Frame(WindowFrame.Type.RANGE, FrameBound.Type.UNBOUNDED_PRECEDING, Optional.of(startValue2), Optional.of(orderKey), FrameBound.Type.CURRENT_ROW, Optional.of(endValue2), Optional.of(orderKey), Optional.of(startValue2.toSymbolReference()), Optional.of(endValue2.toSymbolReference())), false)), hash, (PlanNode)p.values((List)inputs.stream().filter(sourceFilter).collect(ImmutableList.toImmutableList()), (List<List<Expression>>)ImmutableList.of())));
    }
}

