/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformUncorrelatedSubqueryToJoin;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestTransformUncorrelatedSubqueryToJoin
extends BaseRuleTest {
    public TestTransformUncorrelatedSubqueryToJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testRewriteInnerCorrelatedJoin() {
        this.tester().assertThat((Rule<?>)new TransformUncorrelatedSubqueryToJoin()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(a), CorrelatedJoinNode.Type.INNER, (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.values(b));
        }).matches(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.filter("b > a").left(PlanMatchPattern.values("a")).right(PlanMatchPattern.values("b"))));
    }

    @Test
    public void testRewriteLeftCorrelatedJoin() {
        this.tester().assertThat((Rule<?>)new TransformUncorrelatedSubqueryToJoin()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(a), CorrelatedJoinNode.Type.LEFT, (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.values(b));
        }).matches(PlanMatchPattern.join(JoinNode.Type.LEFT, builder -> builder.filter("b > a").left(PlanMatchPattern.values("a")).right(PlanMatchPattern.values("b"))));
    }

    @Test
    public void testRewriteRightCorrelatedJoin() {
        this.tester().assertThat((Rule<?>)new TransformUncorrelatedSubqueryToJoin()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(a), CorrelatedJoinNode.Type.RIGHT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.values(b));
        }).matches(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.left(PlanMatchPattern.values("a")).right(PlanMatchPattern.values("b"))));
        this.tester().assertThat((Rule<?>)new TransformUncorrelatedSubqueryToJoin()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(a), CorrelatedJoinNode.Type.RIGHT, (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.values(b));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("if(b > a, a, null)"), (Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.left(PlanMatchPattern.values("a")).right(PlanMatchPattern.values("b")))));
    }

    @Test
    public void testRewriteFullCorrelatedJoin() {
        this.tester().assertThat((Rule<?>)new TransformUncorrelatedSubqueryToJoin()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(a), CorrelatedJoinNode.Type.FULL, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.values(b));
        }).matches(PlanMatchPattern.join(JoinNode.Type.LEFT, builder -> builder.left(PlanMatchPattern.values("a")).right(PlanMatchPattern.values("b"))));
        this.tester().assertThat((Rule<?>)new TransformUncorrelatedSubqueryToJoin()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin(Collections.emptyList(), (PlanNode)p.values(a), CorrelatedJoinNode.Type.FULL, (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.values(b));
        }).doesNotFire();
    }

    @Test
    public void testDoesNotFire() {
        Symbol symbol = new Symbol("x");
        this.tester().assertThat((Rule<?>)new TransformUncorrelatedSubqueryToJoin()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)symbol), (PlanNode)p.values(symbol), (PlanNode)p.values(new Symbol[0]))).doesNotFire();
    }
}

