/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.connector.MockConnectorColumnHandle;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.statistics.ColumnStatistics;
import io.trino.spi.statistics.Estimate;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestDeterminePartitionCount
extends BasePlanTest {
    @Override
    protected LocalQueryRunner createLocalQueryRunner() {
        String catalogName = "mock";
        MockConnectorFactory connectorFactory = MockConnectorFactory.builder().withGetTableHandle((session, tableName) -> {
            if (tableName.getTableName().equals("table_with_stats_a") || tableName.getTableName().equals("table_with_stats_b") || tableName.getTableName().equals("table_without_stats_a") || tableName.getTableName().equals("table_without_stats_b")) {
                return new MockConnectorTableHandle((SchemaTableName)tableName);
            }
            return null;
        }).withGetColumns(schemaTableName -> ImmutableList.of((Object)new ColumnMetadata("column_a", (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata("column_b", (Type)VarcharType.VARCHAR))).withGetTableStatistics(tableName -> {
            if (tableName.getTableName().equals("table_with_stats_a") || tableName.getTableName().equals("table_with_stats_b")) {
                return new TableStatistics(Estimate.of((double)200.0), (Map)ImmutableMap.of((Object)new MockConnectorColumnHandle("column_a", (Type)VarcharType.VARCHAR), (Object)new ColumnStatistics(Estimate.of((double)0.0), Estimate.of((double)10000.0), Estimate.of((double)DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes()), Optional.empty()), (Object)new MockConnectorColumnHandle("column_b", (Type)VarcharType.VARCHAR), (Object)new ColumnStatistics(Estimate.of((double)0.0), Estimate.of((double)10000.0), Estimate.of((double)DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes()), Optional.empty())));
            }
            return TableStatistics.empty();
        }).withName(catalogName).build();
        Session session2 = TestingSession.testSessionBuilder().setCatalog(catalogName).setSchema("default").build();
        LocalQueryRunner queryRunner = LocalQueryRunner.builder((Session)session2).withNodeCountForStats(100).build();
        queryRunner.createCatalog(catalogName, (ConnectorFactory)connectorFactory, (Map)ImmutableMap.of());
        return queryRunner;
    }

    @Test
    public void testSimpleSelect() {
        String query = "SELECT * FROM table_with_stats_a";
        this.assertDistributedPlan(query, Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_hash_partition_count", "100").setSystemProperty("min_hash_partition_count", "4").setSystemProperty("min_input_size_per_task", "20MB").setSystemProperty("min_input_rows_per_task", "400").build(), PlanMatchPattern.output(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])));
    }

    @Test
    public void testSimpleFilter() {
        String query = "SELECT column_a FROM table_with_stats_a WHERE column_b IS NULL";
        this.assertDistributedPlan(query, Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_hash_partition_count", "100").setSystemProperty("min_hash_partition_count", "4").setSystemProperty("min_input_size_per_task", "20MB").setSystemProperty("min_input_rows_per_task", "400").build(), PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.filter("column_b IS NULL", PlanMatchPattern.tableScan("table_with_stats_a", (Map<String, String>)ImmutableMap.of((Object)"column_a", (Object)"column_a", (Object)"column_b", (Object)"column_b"))))));
    }

    @Test
    public void testSimpleCount() {
        String query = "SELECT count(*) FROM table_with_stats_a";
        this.assertDistributedPlan(query, Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_hash_partition_count", "100").setSystemProperty("min_hash_partition_count", "4").setSystemProperty("min_input_size_per_task", "20MB").setSystemProperty("min_input_rows_per_task", "400").build(), PlanMatchPattern.output(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, Optional.empty(), PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])))))));
    }

    @Test
    public void testPlanWhenTableStatisticsArePresent() {
        String query = "SELECT count(column_a) FROM table_with_stats_a group by column_b\n";
        this.assertDistributedPlan(query, Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_hash_partition_count", "21").setSystemProperty("min_hash_partition_count", "4").setSystemProperty("min_input_size_per_task", "20MB").setSystemProperty("min_input_rows_per_task", "400").build(), PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, Optional.of(10), PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))))));
    }

    @Test
    public void testDoesNotSetPartitionCountWhenNodeCountIsSmall() {
        String query = "SELECT count(column_a) FROM table_with_stats_a group by column_b\n";
        this.assertDistributedPlan(query, Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_hash_partition_count", "20").setSystemProperty("min_hash_partition_count", "4").setSystemProperty("min_input_size_per_task", "20MB").setSystemProperty("min_input_rows_per_task", "400").build(), PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, Optional.empty(), PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))))));
    }

    @Test
    public void testPlanWhenTableStatisticsAreAbsent() {
        String query = "SELECT * FROM table_without_stats_a as a JOIN table_without_stats_b as b ON a.column_a = b.column_a\n";
        this.assertDistributedPlan(query, Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_hash_partition_count", "10").setSystemProperty("min_hash_partition_count", "4").setSystemProperty("min_input_size_per_task", "20MB").setSystemProperty("min_input_rows_per_task", "400").build(), PlanMatchPattern.output(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("column_a", "column_a_0").right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, Optional.empty(), PlanMatchPattern.tableScan("table_without_stats_b", (Map<String, String>)ImmutableMap.of((Object)"column_a_0", (Object)"column_a", (Object)"column_b_1", (Object)"column_b"))))).left(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, Optional.empty(), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("table_without_stats_a", (Map<String, String>)ImmutableMap.of((Object)"column_a", (Object)"column_a", (Object)"column_b", (Object)"column_b"))))))));
    }

    @Test
    public void testPlanWhenCrossJoinIsPresent() {
        String query = "SELECT * FROM table_with_stats_a CROSS JOIN table_with_stats_b\n";
        this.assertDistributedPlan(query, Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_hash_partition_count", "10").setSystemProperty("min_hash_partition_count", "4").setSystemProperty("min_input_size_per_task", "20MB").setSystemProperty("min_input_rows_per_task", "400").build(), PlanMatchPattern.output(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, Optional.empty(), PlanMatchPattern.tableScan("table_with_stats_b", (Map<String, String>)ImmutableMap.of((Object)"column_a_0", (Object)"column_a", (Object)"column_b_1", (Object)"column_b"))))).left(PlanMatchPattern.tableScan("table_with_stats_a", (Map<String, String>)ImmutableMap.of((Object)"column_a", (Object)"column_a", (Object)"column_b", (Object)"column_b"))))));
    }

    @Test
    public void testPlanWhenCrossJoinIsScalar() {
        String query = "SELECT * FROM table_with_stats_a CROSS JOIN (select max(column_a) from table_with_stats_b) t(a)\n";
        this.assertDistributedPlan(query, Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_hash_partition_count", "20").setSystemProperty("min_hash_partition_count", "4").setSystemProperty("min_input_size_per_task", "20MB").setSystemProperty("min_input_rows_per_task", "400").build(), PlanMatchPattern.output(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, Optional.empty(), PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, Optional.empty(), PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])))))))).left(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])))));
    }

    @Test
    public void testPlanWhenJoinNodeStatsAreAbsent() {
        String query = "SELECT * FROM table_with_stats_a as a JOIN table_with_stats_b as b ON a.column_b = b.column_b\n";
        this.assertDistributedPlan(query, Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_hash_partition_count", "10").setSystemProperty("min_hash_partition_count", "4").setSystemProperty("min_input_size_per_task", "20MB").setSystemProperty("min_input_rows_per_task", "400").build(), PlanMatchPattern.output(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("column_b", "column_b_1").right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, Optional.empty(), PlanMatchPattern.tableScan("table_with_stats_b", (Map<String, String>)ImmutableMap.of((Object)"column_a_0", (Object)"column_a", (Object)"column_b_1", (Object)"column_b"))))).left(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, Optional.empty(), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("table_with_stats_a", (Map<String, String>)ImmutableMap.of((Object)"column_a", (Object)"column_a", (Object)"column_b", (Object)"column_b"))))))));
    }

    @Test
    public void testPlanWhenJoinNodeOutputIsBiggerThanRowsScanned() {
        String query = "SELECT a.column_a FROM table_with_stats_a as a JOIN table_with_stats_b as b ON a.column_a = b.column_a\n";
        this.assertDistributedPlan(query, Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_hash_partition_count", "50").setSystemProperty("min_hash_partition_count", "4").setSystemProperty("min_input_size_per_task", "20MB").setSystemProperty("min_input_rows_per_task", "400").build(), PlanMatchPattern.output(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("column_a", "column_a_0").right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, Optional.of(10), PlanMatchPattern.tableScan("table_with_stats_b", (Map<String, String>)ImmutableMap.of((Object)"column_a_0", (Object)"column_a"))))).left(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, Optional.of(10), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("table_with_stats_a", (Map<String, String>)ImmutableMap.of((Object)"column_a", (Object)"column_a"))))))));
    }

    @Test
    public void testEstimatedPartitionCountShouldNotBeGreaterThanMaxLimit() {
        String query = "SELECT * FROM table_with_stats_a as a JOIN table_with_stats_b as b ON a.column_a = b.column_a\n";
        this.assertDistributedPlan(query, Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_hash_partition_count", "5").setSystemProperty("min_hash_partition_count", "2").setSystemProperty("min_input_size_per_task", "20MB").setSystemProperty("min_input_rows_per_task", "400").build(), PlanMatchPattern.output(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("column_a", "column_a_0").right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, Optional.empty(), PlanMatchPattern.tableScan("table_with_stats_b", (Map<String, String>)ImmutableMap.of((Object)"column_a_0", (Object)"column_a", (Object)"column_b_1", (Object)"column_b"))))).left(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, Optional.empty(), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("table_with_stats_a", (Map<String, String>)ImmutableMap.of((Object)"column_a", (Object)"column_a", (Object)"column_b", (Object)"column_b"))))))));
    }

    @Test
    public void testEstimatedPartitionCountShouldNotBeLessThanMinLimit() {
        String query = "SELECT a.column_a FROM table_with_stats_a as a JOIN table_with_stats_b as b ON a.column_a = b.column_a\n";
        this.assertDistributedPlan(query, Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_hash_partition_count", "40").setSystemProperty("min_hash_partition_count", "15").setSystemProperty("min_input_size_per_task", "20MB").setSystemProperty("min_input_rows_per_task", "400").build(), PlanMatchPattern.output(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("column_a", "column_a_0").right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, Optional.of(15), PlanMatchPattern.tableScan("table_with_stats_b", (Map<String, String>)ImmutableMap.of((Object)"column_a_0", (Object)"column_a"))))).left(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, Optional.of(15), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("table_with_stats_a", (Map<String, String>)ImmutableMap.of((Object)"column_a", (Object)"column_a"))))))));
    }

    @Test
    public void testPlanWhenUnionNodeOutputIsBiggerThanJoinOutput() {
        String query = "SELECT a.column_b\nFROM table_with_stats_a as a\nJOIN table_with_stats_b as b\nON a.column_a = b.column_a\nUNION ALL\nSELECT column_b\nFROM table_with_stats_b\n";
        this.assertDistributedPlan(query, Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_hash_partition_count", "50").setSystemProperty("min_hash_partition_count", "4").setSystemProperty("min_input_size_per_task", "20MB").setSystemProperty("min_input_rows_per_task", "400").build(), PlanMatchPattern.output(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("column_a", "column_a_1").right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, Optional.of(20), PlanMatchPattern.tableScan("table_with_stats_b", (Map<String, String>)ImmutableMap.of((Object)"column_a_1", (Object)"column_a"))))).left(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, Optional.of(20), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("table_with_stats_a", (Map<String, String>)ImmutableMap.of((Object)"column_a", (Object)"column_a", (Object)"column_b_0", (Object)"column_b")))))), PlanMatchPattern.tableScan("table_with_stats_b", (Map<String, String>)ImmutableMap.of((Object)"column_b_4", (Object)"column_b")))));
    }

    @Test
    public void testPlanWhenEstimatedPartitionCountBasedOnRowsIsMoreThanOutputSize() {
        String query = "SELECT count(column_a) FROM table_with_stats_a group by column_b\n";
        this.assertDistributedPlan(query, Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("max_hash_partition_count", "100").setSystemProperty("min_hash_partition_count", "4").setSystemProperty("min_input_size_per_task", "20MB").setSystemProperty("min_input_rows_per_task", "20").build(), PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, Optional.of(10), PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))))));
    }
}

