/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.tree.FunctionCall;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TestFullOuterJoinWithCoalesce
extends BasePlanTest {
    @Test
    @Disabled
    public void testFullOuterJoinWithCoalesce() {
        this.assertDistributedPlan("SELECT coalesce(ts.a, r.a) FROM (   SELECT coalesce(t.a, s.a) AS a    FROM (VALUES 1, 2, 3) t(a)    FULL OUTER JOIN (VALUES 1, 4) s(a)   ON t.a = s.a) ts FULL OUTER JOIN (VALUES 2, 5) r(a) on ts.a = r.a", PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("coalesce(ts, r)")), PlanMatchPattern.join(JoinNode.Type.FULL, builder -> builder.equiCriteria("ts", "r").left(PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ts", (Object)PlanMatchPattern.expression("coalesce(t, s)")), PlanMatchPattern.join(JoinNode.Type.FULL, leftJoinBuilder -> leftJoinBuilder.equiCriteria("t", "s").left(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"t"))))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"s"))))))))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"r")))))))));
    }

    @Test
    @Disabled
    public void testArgumentsInDifferentOrder() {
        this.assertDistributedPlan("SELECT coalesce(l.a, r.a) FROM (VALUES 1, 2, 3) l(a) FULL OUTER JOIN (VALUES 1, 4) r(a) ON l.a = r.a GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("coalesce(l, r)")), PlanMatchPattern.join(JoinNode.Type.FULL, builder -> builder.equiCriteria("l", "r").left(PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"l")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"r")))))))))));
        this.assertDistributedPlan("SELECT coalesce(r.a, l.a) FROM (VALUES 1, 2, 3) l(a) FULL OUTER JOIN (VALUES 1, 4) r(a) ON l.a = r.a GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("coalesce(r, l)")), PlanMatchPattern.join(JoinNode.Type.FULL, builder -> builder.equiCriteria("l", "r").left(PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"l")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"r")))))))))));
    }

    @Test
    public void testCoalesceWithManyArguments() {
        this.assertDistributedPlan("SELECT coalesce(l.a, m.a, r.a) FROM (VALUES 1, 2, 3) l(a) FULL OUTER JOIN (VALUES 1, 4) m(a) ON l.a = m.a FULL OUTER JOIN (VALUES 2, 5) r(a) ON l.a = r.a GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("coalesce(l, m, r)")), PlanMatchPattern.join(JoinNode.Type.FULL, builder -> builder.equiCriteria("l", "r").left(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.FULL, leftJoinBuilder -> leftJoinBuilder.equiCriteria("l", "m").left(PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"l")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"m"))))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"r"))))))))));
    }

    @Test
    public void testComplexArgumentToCoalesce() {
        this.assertDistributedPlan("SELECT coalesce(l.a, m.a + 1, r.a) FROM (VALUES 1, 2, 3) l(a) FULL OUTER JOIN (VALUES 1, 4) m(a) ON l.a = m.a FULL OUTER JOIN (VALUES 2, 5) r(a) ON l.a = r.a GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("coalesce(l, m + 1, r)")), PlanMatchPattern.join(JoinNode.Type.FULL, builder -> builder.equiCriteria("l", "r").left(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.FULL, leftJoinBuilder -> leftJoinBuilder.equiCriteria("l", "m").left(PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"l")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"m"))))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"r"))))))))));
    }
}

