/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.MockConnectorEntities;
import io.trino.connector.MockConnectorFactory;
import io.trino.metadata.QualifiedObjectName;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.Identity;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestRowFilter {
    private static final String LOCAL_CATALOG = "local";
    private static final String MOCK_CATALOG = "mock";
    private static final String MOCK_CATALOG_MISSING_COLUMNS = "mockmissingcolumns";
    private static final String USER = "user";
    private static final String VIEW_OWNER = "view-owner";
    private static final String RUN_AS_USER = "run-as-user";
    private static final Session SESSION = TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setIdentity(Identity.forUser((String)"user").build()).build();
    private QueryAssertions assertions;
    private TestingAccessControlManager accessControl;

    @BeforeAll
    public void init() {
        LocalQueryRunner runner = LocalQueryRunner.builder((Session)SESSION).build();
        runner.createCatalog(LOCAL_CATALOG, (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        ConnectorViewDefinition view = new ConnectorViewDefinition("SELECT nationkey, name FROM local.tiny.nation", Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("nationkey", BigintType.BIGINT.getTypeId(), Optional.empty()), (Object)new ConnectorViewDefinition.ViewColumn("name", VarcharType.createVarcharType((int)25).getTypeId(), Optional.empty())), Optional.empty(), Optional.of(VIEW_OWNER), false, (List)ImmutableList.of());
        MockConnectorFactory mock = MockConnectorFactory.builder().withGetViews((s, prefix) -> ImmutableMap.of((Object)new SchemaTableName("default", "nation_view"), (Object)view)).withGetColumns(schemaTableName -> {
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_with_hidden_column"))) {
                return MockConnectorEntities.TPCH_NATION_WITH_HIDDEN_COLUMN;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_with_optional_column"))) {
                return MockConnectorEntities.TPCH_NATION_WITH_OPTIONAL_COLUMN;
            }
            throw new UnsupportedOperationException();
        }).withData(schemaTableName -> {
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation"))) {
                return MockConnectorEntities.TPCH_NATION_DATA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_with_hidden_column"))) {
                return MockConnectorEntities.TPCH_WITH_HIDDEN_COLUMN_DATA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_with_optional_column"))) {
                return MockConnectorEntities.TPCH_NATION_DATA;
            }
            throw new UnsupportedOperationException();
        }).build();
        runner.createCatalog(MOCK_CATALOG, (ConnectorFactory)mock, (Map)ImmutableMap.of());
        MockConnectorFactory mockMissingColumns = MockConnectorFactory.builder().withName(MOCK_CATALOG_MISSING_COLUMNS).withGetViews((s, prefix) -> ImmutableMap.of((Object)new SchemaTableName("default", "nation_view"), (Object)view)).withGetColumns(schemaTableName -> {
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_with_optional_column"))) {
                return MockConnectorEntities.TPCH_NATION_WITH_OPTIONAL_COLUMN;
            }
            throw new UnsupportedOperationException();
        }).withData(schemaTableName -> {
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_with_optional_column"))) {
                return MockConnectorEntities.TPCH_NATION_DATA;
            }
            throw new UnsupportedOperationException();
        }).withAllowMissingColumnsOnInsert(true).build();
        runner.createCatalog(MOCK_CATALOG_MISSING_COLUMNS, (ConnectorFactory)mockMissingColumns, (Map)ImmutableMap.of());
        this.assertions = new QueryAssertions((QueryRunner)runner);
        this.accessControl = this.assertions.getQueryRunner().getAccessControl();
    }

    @AfterAll
    public void teardown() {
        this.accessControl = null;
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testSimpleFilter() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().expression("orderkey < 10").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders")))).matches("VALUES BIGINT '7'");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().expression("NULL").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders")))).matches("VALUES BIGINT '0'");
    }

    @Test
    public void testMultipleFilters() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().expression("orderkey < 10").build());
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().expression("orderkey > 5").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders")))).matches("VALUES BIGINT '2'");
    }

    @Test
    public void testCorrelatedSubquery() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("EXISTS (SELECT 1 FROM nation WHERE nationkey = orderkey)").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders")))).matches("VALUES BIGINT '7'");
    }

    @Test
    public void testView() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "nation"), VIEW_OWNER, ViewExpression.builder().expression("nationkey = 1").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(Session.builder((Session)SESSION).setIdentity(Identity.forUser((String)RUN_AS_USER).build()).build(), "SELECT name FROM mock.default.nation_view")))).matches("VALUES CAST('ARGENTINA' AS VARCHAR(25))");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "nation"), VIEW_OWNER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("nationkey = 1").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(Session.builder((Session)SESSION).setIdentity(Identity.forUser((String)VIEW_OWNER).build()).build(), "SELECT name FROM mock.default.nation_view")))).matches("VALUES CAST('ARGENTINA' AS VARCHAR(25))");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "nation"), RUN_AS_USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("nationkey = 1").build());
        Session session = Session.builder((Session)SESSION).setIdentity(Identity.forUser((String)RUN_AS_USER).build()).build();
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(session, "SELECT count(*) FROM mock.default.nation_view")))).matches("VALUES BIGINT '25'");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(MOCK_CATALOG, "default", "nation_view"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("nationkey = 1").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT name FROM mock.default.nation_view")))).matches("VALUES CAST('ARGENTINA' AS VARCHAR(25))");
    }

    @Test
    public void testTableReferenceInWithClause() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().expression("orderkey = 1").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH t AS (SELECT count(*) FROM orders) SELECT * FROM t")))).matches("VALUES BIGINT '1'");
    }

    @Test
    public void testOtherSchema() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("sf1").expression("(SELECT count(*) FROM customer) = 150000").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders")))).matches("VALUES BIGINT '15000'");
    }

    @Test
    public void testDifferentIdentity() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), RUN_AS_USER, ViewExpression.builder().identity(RUN_AS_USER).catalog(LOCAL_CATALOG).schema("tiny").expression("orderkey = 1").build());
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().identity(RUN_AS_USER).catalog(LOCAL_CATALOG).schema("tiny").expression("orderkey IN (SELECT orderkey FROM orders)").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders")))).matches("VALUES BIGINT '1'");
    }

    @Test
    public void testRecursion() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("orderkey IN (SELECT orderkey FROM orders)").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT count(*) FROM orders")).hasMessageMatching(".*\\QRow filter for 'local.tiny.orders' is recursive\\E.*");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("orderkey IN (SELECT local.tiny.orderkey FROM orders)").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT count(*) FROM orders")).hasMessageMatching(".*\\QRow filter for 'local.tiny.orders' is recursive\\E.*");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), RUN_AS_USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("orderkey IN (SELECT orderkey FROM orders)").build());
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("orderkey IN (SELECT orderkey FROM orders)").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT count(*) FROM orders")).hasMessageMatching(".*\\QRow filter for 'local.tiny.orders' is recursive\\E.*");
    }

    @Test
    public void testLimitedScope() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "customer"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("orderkey = 1").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT (SELECT min(name) FROM customer WHERE customer.custkey = orders.custkey) FROM orders")).hasMessage("line 1:31: Invalid row filter for 'local.tiny.customer': Column 'orderkey' cannot be resolved");
    }

    @Test
    public void testSqlInjection() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "nation"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("regionkey IN (SELECT regionkey FROM region WHERE name = 'ASIA')").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH region(regionkey, name) AS (VALUES (0, 'ASIA'), (1, 'ASIA'), (2, 'ASIA'), (3, 'ASIA'), (4, 'ASIA'))SELECT name FROM nation ORDER BY name LIMIT 1")))).matches("VALUES CAST('CHINA' AS VARCHAR(25))");
    }

    @Test
    public void testInvalidFilter() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("$$$").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT count(*) FROM orders")).hasMessage("line 1:22: Invalid row filter for 'local.tiny.orders': mismatched input '$'. Expecting: <expression>");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("unknown_column").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT count(*) FROM orders")).hasMessage("line 1:22: Invalid row filter for 'local.tiny.orders': Column 'unknown_column' cannot be resolved");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("1").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT count(*) FROM orders")).hasMessage("line 1:22: Expected row filter for 'local.tiny.orders' to be of type BOOLEAN, but was integer");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("count(*) > 0").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT count(*) FROM orders")).hasMessage("line 1:10: Row filter for 'local.tiny.orders' cannot contain aggregations, window functions or grouping operations: [count(*)]");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("row_number() OVER () > 0").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT count(*) FROM orders")).hasMessage("line 1:22: Row filter for 'local.tiny.orders' cannot contain aggregations, window functions or grouping operations: [row_number() OVER ()]");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("grouping(orderkey) = 0").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT count(*) FROM orders")).hasMessage("line 1:20: Row filter for 'local.tiny.orders' cannot contain aggregations, window functions or grouping operations: [GROUPING (orderkey)]");
    }

    @Test
    public void testShowStats() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().identity(RUN_AS_USER).catalog(LOCAL_CATALOG).schema("tiny").expression("orderkey = 0").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW STATS FOR (SELECT * FROM tiny.orders)")))).containsAll("VALUES (VARCHAR 'orderkey', 0e1, 0e1, 1e0, CAST(NULL AS double), CAST(NULL AS varchar), CAST(NULL AS varchar)),(VARCHAR 'custkey', 0e1, 0e1, 1e0, CAST(NULL AS double), CAST(NULL AS varchar), CAST(NULL AS varchar)),(NULL, NULL, NULL, NULL, 0e1, NULL, NULL)");
    }

    @Test
    public void testDelete() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(MOCK_CATALOG, "tiny", "nation"), USER, ViewExpression.builder().expression("nationkey < 10").build());
        ((QueryAssertions.QueryAssert)((Object)this.assertions.query("DELETE FROM mock.tiny.nation WHERE nationkey < 3").assertThat())).matches("SELECT BIGINT '3'");
        ((QueryAssertions.QueryAssert)((Object)this.assertions.query("DELETE FROM mock.tiny.nation WHERE nationkey IN (1, 2, 3)").assertThat())).matches("SELECT BIGINT '3'");
        ((QueryAssertions.QueryAssert)((Object)this.assertions.query("DELETE FROM mock.tiny.nation").assertThat())).matches("SELECT BIGINT '10'");
        ((QueryAssertions.QueryAssert)((Object)this.assertions.query("DELETE FROM mock.tiny.nation WHERE nationkey IN (1, 11)").assertThat())).matches("SELECT BIGINT '1'");
        ((QueryAssertions.QueryAssert)((Object)this.assertions.query("DELETE FROM mock.tiny.nation WHERE nationkey >= 10").assertThat())).matches("SELECT BIGINT '0'");
    }

    @Test
    public void testMergeDelete() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(MOCK_CATALOG, "tiny", "nation"), USER, ViewExpression.builder().expression("nationkey < 10").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2) t(x) ON nationkey = x\nWHEN MATCHED THEN DELETE")).hasMessage("line 1:1: Cannot merge into a table with row filters");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2,3,4,5) t(x) ON regionkey = x\nWHEN MATCHED THEN DELETE")).hasMessage("line 1:1: Cannot merge into a table with row filters");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,11) t(x) ON nationkey = x\nWHEN MATCHED THEN DELETE")).hasMessage("line 1:1: Cannot merge into a table with row filters");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 11,12,13,14,15) t(x) ON nationkey = x\nWHEN MATCHED THEN DELETE")).hasMessage("line 1:1: Cannot merge into a table with row filters");
    }

    @Test
    public void testUpdate() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(MOCK_CATALOG, "tiny", "nation"), USER, ViewExpression.builder().expression("nationkey < 10").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation SET regionkey = regionkey * 2 WHERE nationkey < 3")).hasMessage("line 1:1: Updating a table with a row filter is not supported");
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation SET regionkey = regionkey * 2 WHERE nationkey IN (1, 2, 3)")).hasMessage("line 1:1: Updating a table with a row filter is not supported");
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation SET regionkey = regionkey * 2")).hasMessage("line 1:1: Updating a table with a row filter is not supported");
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation SET regionkey = regionkey * 2 WHERE nationkey IN (1, 11)")).hasMessage("line 1:1: Updating a table with a row filter is not supported");
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation SET regionkey = regionkey * 2 WHERE nationkey = 11")).hasMessage("line 1:1: Updating a table with a row filter is not supported");
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation SET nationkey = 10 WHERE nationkey < 3")).hasMessage("line 1:1: Updating a table with a row filter is not supported");
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation SET nationkey = null WHERE nationkey < 3")).hasMessage("line 1:1: Updating a table with a row filter is not supported");
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation SET nationkey = 10 WHERE nationkey = 10")).hasMessage("line 1:1: Updating a table with a row filter is not supported");
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation SET nationkey = null WHERE nationkey = null ")).hasMessage("line 1:1: Updating a table with a row filter is not supported");
    }

    @Test
    public void testMergeUpdate() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(MOCK_CATALOG, "tiny", "nation"), USER, ViewExpression.builder().expression("nationkey < 10").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 5) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET regionkey = regionkey * 2")).hasMessage("line 1:1: Cannot merge into a table with row filters");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2,3,4,5,6) t(x) ON regionkey = x\nWHEN MATCHED THEN UPDATE SET regionkey = regionkey * 2")).hasMessage("line 1:1: Cannot merge into a table with row filters");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1, 11) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET regionkey = regionkey * 2")).hasMessage("line 1:1: Cannot merge into a table with row filters");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 11) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET regionkey = regionkey * 2")).hasMessage("line 1:1: Cannot merge into a table with row filters");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2,3) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET nationkey = 10")).hasMessage("line 1:1: Cannot merge into a table with row filters");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2,3) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET nationkey = NULL")).hasMessage("line 1:1: Cannot merge into a table with row filters");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 10) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET nationkey = 13")).hasMessage("line 1:1: Cannot merge into a table with row filters");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 10) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET nationkey = NULL")).hasMessage("line 1:1: Cannot merge into a table with row filters");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 10) t(x) ON nationkey IS NULL\nWHEN MATCHED THEN UPDATE SET nationkey = 13")).hasMessage("line 1:1: Cannot merge into a table with row filters");
    }

    @Test
    public void testInsert() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(MOCK_CATALOG, "tiny", "nation"), USER, ViewExpression.builder().expression("nationkey > 100").build());
        ((QueryAssertions.QueryAssert)((Object)this.assertions.query("INSERT INTO mock.tiny.nation VALUES (101, 'POLAND', 0, 'No comment')").assertThat())).skippingTypesCheck().matches("SELECT BIGINT '1'");
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation VALUES (26, 'POLAND', 0, 'No comment')")).hasMessage("Access Denied: Cannot insert row that does not match a row filter");
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation VALUES (26, 'POLAND', 0, 'No comment'),(27, 'HOLLAND', 0, 'A comment')")).hasMessage("Access Denied: Cannot insert row that does not match a row filter");
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation(nationkey) VALUES (null)")).hasMessage("Access Denied: Cannot insert row that does not match a row filter");
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation(regionkey) VALUES (0)")).hasMessage("Access Denied: Cannot insert row that does not match a row filter");
    }

    @Test
    public void testMergeInsert() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(MOCK_CATALOG, "tiny", "nation"), USER, ViewExpression.builder().expression("nationkey > 100").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 42) t(dummy) ON false\nWHEN NOT MATCHED THEN INSERT VALUES (101, 'POLAND', 0, 'No comment')")).hasMessage("line 1:1: Cannot merge into a table with row filters");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 42) t(dummy) ON false\nWHEN NOT MATCHED THEN INSERT VALUES (26, 'POLAND', 0, 'No comment')")).hasMessage("line 1:1: Cannot merge into a table with row filters");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES (26, 'POLAND', 0, 'No comment'), (27, 'HOLLAND', 0, 'A comment')) t(a,b,c,d) ON nationkey = a\nWHEN NOT MATCHED THEN INSERT VALUES (a,b,c,d)")).hasMessage("line 1:1: Cannot merge into a table with row filters");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 42) t(dummy) ON false\nWHEN NOT MATCHED THEN INSERT (nationkey) VALUES (NULL)")).hasMessage("line 1:1: Cannot merge into a table with row filters");
        Assertions.assertThatThrownBy(() -> this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 42) t(dummy) ON false\nWHEN NOT MATCHED THEN INSERT (nationkey) VALUES (0)")).hasMessage("line 1:1: Cannot merge into a table with row filters");
    }

    @Test
    public void testRowFilterWithHiddenColumns() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(MOCK_CATALOG, "tiny", "nation_with_hidden_column"), USER, ViewExpression.builder().expression("nationkey < 1").build());
        ((QueryAssertions.QueryAssert)((Object)this.assertions.query("SELECT * FROM mock.tiny.nation_with_hidden_column").assertThat())).skippingTypesCheck().matches("VALUES (BIGINT '0', 'ALGERIA', BIGINT '0', ' haggle. carefully final deposits detect slyly agai')");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation_with_hidden_column VALUES (101, 'POLAND', 0, 'No comment')")).isInstanceOf(TrinoException.class)).hasMessage("Access Denied: Cannot insert row that does not match a row filter");
        ((QueryAssertions.QueryAssert)((Object)this.assertions.query("INSERT INTO mock.tiny.nation_with_hidden_column VALUES (0, 'POLAND', 0, 'No comment')").assertThat())).skippingTypesCheck().matches("VALUES BIGINT '1'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation_with_hidden_column SET name = 'POLAND'")).isInstanceOf(TrinoException.class)).hasMessageContaining("Updating a table with a row filter is not supported");
        ((QueryAssertions.QueryAssert)((Object)this.assertions.query("DELETE FROM mock.tiny.nation_with_hidden_column WHERE regionkey < 5").assertThat())).skippingTypesCheck().matches("SELECT BIGINT '1'");
        ((QueryAssertions.QueryAssert)((Object)this.assertions.query("DELETE FROM mock.tiny.nation_with_hidden_column WHERE \"$hidden\" IS NOT NULL").assertThat())).skippingTypesCheck().matches("SELECT BIGINT '1'");
    }

    @Test
    public void testRowFilterOnHiddenColumn() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(MOCK_CATALOG, "tiny", "nation_with_hidden_column"), USER, ViewExpression.builder().expression("\"$hidden\" < 1").build());
        ((QueryAssertions.QueryAssert)((Object)this.assertions.query("SELECT count(*) FROM mock.tiny.nation_with_hidden_column").assertThat())).skippingTypesCheck().matches("VALUES BIGINT '25'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation_with_hidden_column VALUES (101, 'POLAND', 0, 'No comment')")).isInstanceOf(ArrayIndexOutOfBoundsException.class)).hasMessage("Index 4 out of bounds for length 4");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation_with_hidden_column SET name = 'POLAND'")).isInstanceOf(TrinoException.class)).hasMessageContaining("Updating a table with a row filter is not supported");
        ((QueryAssertions.QueryAssert)((Object)this.assertions.query("DELETE FROM mock.tiny.nation_with_hidden_column WHERE regionkey < 5").assertThat())).skippingTypesCheck().matches("SELECT BIGINT '25'");
    }

    @Test
    public void testRowFilterOnOptionalColumn() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(MOCK_CATALOG_MISSING_COLUMNS, "tiny", "nation_with_optional_column"), USER, ViewExpression.builder().expression("length(optional) > 2").build());
        ((QueryAssertions.QueryAssert)((Object)this.assertions.query("INSERT INTO mockmissingcolumns.tiny.nation_with_optional_column(nationkey, name, regionkey, comment, optional) VALUES (0, 'POLAND', 0, 'No comment', 'some string')").assertThat())).skippingTypesCheck().matches("VALUES BIGINT '1'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mockmissingcolumns.tiny.nation_with_optional_column(nationkey, name, regionkey, comment, optional) VALUES (0, 'POLAND', 0, 'No comment', 'so')")).isInstanceOf(TrinoException.class)).hasMessage("Access Denied: Cannot insert row that does not match a row filter");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mockmissingcolumns.tiny.nation_with_optional_column(nationkey, name, regionkey, comment, optional) VALUES (0, 'POLAND', 0, 'No comment', null)")).isInstanceOf(TrinoException.class)).hasMessage("Access Denied: Cannot insert row that does not match a row filter");
    }
}

