/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.collect.ImmutableList;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.type.AbstractTestType;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestLongTimestampType
extends AbstractTestType {
    public TestLongTimestampType() {
        super((Type)TimestampType.TIMESTAMP_NANOS, SqlTimestamp.class, TestLongTimestampType.createTestBlock());
    }

    public static Block createTestBlock() {
        BlockBuilder blockBuilder = TimestampType.TIMESTAMP_NANOS.createBlockBuilder(null, 15);
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(1111123L, 123000));
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(1111123L, 123000));
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(1111123L, 123000));
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(2222123L, 123000));
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(2222123L, 123000));
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(2222123L, 123000));
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(2222123L, 123000));
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(2222123L, 123000));
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(3333123L, 123000));
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(3333123L, 123000));
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(4444123L, 123000));
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        LongTimestamp timestamp = (LongTimestamp)value;
        return new LongTimestamp(timestamp.getEpochMicros() + 1L, 0);
    }

    @Test
    public void testRange() {
        Type.Range range = (Type.Range)this.type.getRange().orElseThrow();
        Assert.assertEquals((Object)range.getMin(), (Object)new LongTimestamp(Long.MIN_VALUE, 0));
        Assert.assertEquals((Object)range.getMax(), (Object)new LongTimestamp(Long.MAX_VALUE, 999000));
    }

    @Test
    public void testRangeEveryPrecision() {
        for (MaxPrecision entry : TestLongTimestampType.maxPrecisions()) {
            Type.Range range = (Type.Range)TimestampType.createTimestampType((int)entry.precision()).getRange().orElseThrow();
            Assert.assertEquals((Object)range.getMin(), (Object)new LongTimestamp(Long.MIN_VALUE, 0));
            Assert.assertEquals((Object)range.getMax(), (Object)entry.expectedMax());
        }
    }

    public static List<MaxPrecision> maxPrecisions() {
        return ImmutableList.of((Object)new MaxPrecision(7, new LongTimestamp(Long.MAX_VALUE, 900000)), (Object)new MaxPrecision(8, new LongTimestamp(Long.MAX_VALUE, 990000)), (Object)new MaxPrecision(9, new LongTimestamp(Long.MAX_VALUE, 999000)), (Object)new MaxPrecision(10, new LongTimestamp(Long.MAX_VALUE, 999900)), (Object)new MaxPrecision(11, new LongTimestamp(Long.MAX_VALUE, 999990)), (Object)new MaxPrecision(12, new LongTimestamp(Long.MAX_VALUE, 999999)));
    }

    @Test
    public void testPreviousValue() {
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEmpty();
    }

    @Test
    public void testNextValue() {
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEmpty();
    }

    record MaxPrecision(int precision, LongTimestamp expectedMax) {
    }
}

