/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.util.SingleAccessMethodCompiler;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.objectweb.asm.ByteVector;
import org.testng.Assert;

public class TestSingleAccessMethodCompiler {
    @Test
    public void testBasic() throws ReflectiveOperationException {
        LongUnaryOperator addOne = (LongUnaryOperator)SingleAccessMethodCompiler.compileSingleAccessMethod((String)"AddOne", LongUnaryOperator.class, (MethodHandle)MethodHandles.lookup().findStatic(TestSingleAccessMethodCompiler.class, "increment", MethodType.methodType(Long.TYPE, Long.TYPE)));
        Assert.assertEquals((long)addOne.applyAsLong(1L), (long)2L);
    }

    private static long increment(long x) {
        return x + 1L;
    }

    @Test
    public void testBasicWithClassNameTooLong() throws ReflectiveOperationException {
        int symbolTableSizeLimit = 65535;
        int overflowingNameLength = 65550;
        StringBuilder builder = new StringBuilder(overflowingNameLength);
        for (int i = 0; i < 1150; ++i) {
            builder.append("NameThatIsLongerThanTheAllowedSymbolTableUTF8ConstantSize");
        }
        String suggestedName = builder.toString();
        Assert.assertEquals((int)suggestedName.length(), (int)overflowingNameLength);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new ByteVector().putUTF8(suggestedName)).isInstanceOf(IllegalArgumentException.class)).hasMessage("UTF8 string too large");
        LongUnaryOperator addOne = (LongUnaryOperator)SingleAccessMethodCompiler.compileSingleAccessMethod((String)suggestedName, LongUnaryOperator.class, (MethodHandle)MethodHandles.lookup().findStatic(TestSingleAccessMethodCompiler.class, "increment", MethodType.methodType(Long.TYPE, Long.TYPE)));
        Assert.assertEquals((long)addOne.applyAsLong(1L), (long)2L);
        Assert.assertTrue((addOne.getClass().getName().length() < symbolTableSizeLimit ? 1 : 0) != 0, (String)"class name should be truncated with extra room to spare");
    }

    @Test
    public void testGeneric() throws ReflectiveOperationException {
        LongFunction print = (LongFunction)SingleAccessMethodCompiler.compileSingleAccessMethod((String)"Print", LongFunction.class, (MethodHandle)MethodHandles.lookup().findStatic(TestSingleAccessMethodCompiler.class, "incrementAndPrint", MethodType.methodType(String.class, Long.TYPE)));
        Assert.assertEquals((String)((String)print.apply(1L)), (String)"2");
    }

    private static String incrementAndPrint(long x) {
        return String.valueOf(x + 1L);
    }
}

