/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.UuidType;
import io.trino.type.AbstractTestType;
import io.trino.type.UuidOperators;
import java.lang.invoke.MethodHandle;
import java.util.Optional;
import java.util.UUID;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestUuidType
extends AbstractTestType {
    public TestUuidType() {
        super((Type)UuidType.UUID, String.class, TestUuidType.createTestBlock());
    }

    public static Block createTestBlock() {
        BlockBuilder blockBuilder = UuidType.UUID.createBlockBuilder(null, 1);
        for (int i = 0; i < 10; ++i) {
            String uuid = "6b5f5b65-67e4-43b0-8ee3-586cd49f58a" + i;
            UuidType.UUID.writeSlice(blockBuilder, UuidOperators.castFromVarcharToUuid((Slice)Slices.utf8Slice((String)uuid)));
        }
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        Slice slice = (Slice)value;
        Slice greater = Slices.allocate((int)16);
        greater.setLong(0, slice.getLong(0));
        greater.setLong(8, Long.reverseBytes(Long.reverseBytes(slice.getLong(8)) + 1L));
        return greater;
    }

    @Override
    protected Object getNonNullValue() {
        return Slices.allocate((int)16);
    }

    @Test
    public void testDisplayName() {
        Assert.assertEquals((String)UuidType.UUID.getDisplayName(), (String)"uuid");
    }

    @Test
    public void testJavaUuidToTrinoUuid() {
        Assertions.assertThat((Comparable)UuidType.javaUuidToTrinoUuid((UUID)UUID.fromString("00000000-0000-0000-0000-000000000001"))).isEqualTo((Object)UuidOperators.castFromVarcharToUuid((Slice)Slices.utf8Slice((String)"00000000-0000-0000-0000-000000000001")));
        Assertions.assertThat((Comparable)UuidType.javaUuidToTrinoUuid((UUID)UUID.fromString("f79c3e09-677c-4bbd-a479-3f349cb785e7"))).isEqualTo((Object)UuidOperators.castFromVarcharToUuid((Slice)Slices.utf8Slice((String)"f79c3e09-677c-4bbd-a479-3f349cb785e7")));
    }

    @Test
    public void testOrdering() throws Throwable {
        String lowerAsString = "406caec7-68b9-4778-81b2-a12ece70c8b1";
        String higherAsString = "f79c3e09-677c-4bbd-a479-3f349cb785e7";
        UUID lower = UUID.fromString(lowerAsString);
        UUID higher = UUID.fromString(higherAsString);
        Assertions.assertThat((Comparable)higher).isLessThan((Comparable)lower);
        Slice lowerSlice = UuidType.javaUuidToTrinoUuid((UUID)lower);
        Slice higherSlice = UuidType.javaUuidToTrinoUuid((UUID)higher);
        MethodHandle compareByValue = new TypeOperators().getComparisonUnorderedFirstOperator((Type)UuidType.UUID, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
        long comparisonByValue = compareByValue.invoke(lowerSlice, higherSlice);
        ((AbstractLongAssert)Assertions.assertThat((long)comparisonByValue).as("value comparison operator result", new Object[0])).isLessThan(0L);
        MethodHandle compareFromBlock = new TypeOperators().getComparisonUnorderedFirstOperator((Type)UuidType.UUID, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}));
        long comparisonFromBlock = compareFromBlock.invoke(Utils.nativeValueToBlock((Type)UuidType.UUID, (Object)lowerSlice), 0, Utils.nativeValueToBlock((Type)UuidType.UUID, (Object)higherSlice), 0);
        ((AbstractLongAssert)Assertions.assertThat((long)comparisonFromBlock).as("block-position comparison operator result", new Object[0])).isLessThan(0L);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)lowerSlice).as("comparing slices lexicographically", new Object[0])).isLessThan((Comparable)higherSlice);
    }

    @Test
    public void testRange() {
        Assertions.assertThat((Optional)this.type.getRange()).isEmpty();
    }

    @Test
    public void testPreviousValue() {
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEmpty();
    }

    @Test
    public void testNextValue() {
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEmpty();
    }
}

