/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarcharType;
import io.trino.type.AbstractTestType;
import io.trino.type.InternalTypeManager;
import io.trino.util.StructuralTestUtil;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestVarcharArrayType
extends AbstractTestType {
    public TestVarcharArrayType() {
        super(InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.arrayType((TypeSignature)VarcharType.VARCHAR.getTypeSignature())), List.class, TestVarcharArrayType.createTestBlock(InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.arrayType((TypeSignature)VarcharType.VARCHAR.getTypeSignature()))));
    }

    public static Block createTestBlock(Type arrayType) {
        BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 4);
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)VarcharType.VARCHAR, "1", "2"));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)VarcharType.VARCHAR, "the", "quick", "brown", "fox"));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)VarcharType.VARCHAR, "one-two-three-four-five", "123456789012345", "the quick brown fox", "hello-world-hello-world-hello-world"));
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        Block block = (Block)value;
        VariableWidthBlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, block.getPositionCount() + 1);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            VarcharType.VARCHAR.appendTo(block, i, (BlockBuilder)blockBuilder);
        }
        VarcharType.VARCHAR.writeSlice((BlockBuilder)blockBuilder, Slices.utf8Slice((String)"_"));
        return blockBuilder.build();
    }

    @Test
    public void testRange() {
        Assertions.assertThat((Optional)this.type.getRange()).isEmpty();
    }

    @Test
    public void testPreviousValue() {
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEmpty();
    }

    @Test
    public void testNextValue() {
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEmpty();
    }
}

