/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.collect.ImmutableMap;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.type.AbstractTestType;
import io.trino.util.StructuralTestUtil;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestVarcharVarcharMapType
extends AbstractTestType {
    public TestVarcharVarcharMapType() {
        super((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR), Map.class, TestVarcharVarcharMapType.createTestBlock((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)));
    }

    public static Block createTestBlock(Type mapType) {
        BlockBuilder blockBuilder = mapType.createBlockBuilder(null, 2);
        mapType.writeObject(blockBuilder, (Object)StructuralTestUtil.sqlMapOf((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)"hi", (Object)"there")));
        mapType.writeObject(blockBuilder, (Object)StructuralTestUtil.sqlMapOf((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)"one", (Object)"1", (Object)"hello", (Object)"world")));
        mapType.writeObject(blockBuilder, (Object)StructuralTestUtil.sqlMapOf((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)"one-two-three-four-five", (Object)"123456789012345", (Object)"the quick brown fox", (Object)"hello-world-hello-world-hello-world")));
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Test
    public void testRange() {
        Assertions.assertThat((Optional)this.type.getRange()).isEmpty();
    }

    @Test
    public void testPreviousValue() {
        Object sampleValue = this.getSampleValue();
        if (!this.type.isOrderable()) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.type.getPreviousValue(sampleValue)).isInstanceOf(IllegalStateException.class)).hasMessage("Type is not orderable: " + this.type);
            return;
        }
        Assertions.assertThat((Optional)this.type.getPreviousValue(sampleValue)).isEmpty();
    }

    @Test
    public void testNextValue() {
        Object sampleValue = this.getSampleValue();
        if (!this.type.isOrderable()) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.type.getNextValue(sampleValue)).isInstanceOf(IllegalStateException.class)).hasMessage("Type is not orderable: " + this.type);
            return;
        }
        Assertions.assertThat((Optional)this.type.getNextValue(sampleValue)).isEmpty();
    }
}

