/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.StageId;
import io.trino.execution.scheduler.faulttolerant.EventDrivenFaultTolerantQueryScheduler;
import io.trino.execution.scheduler.faulttolerant.OutputDataSizeEstimator;
import io.trino.execution.scheduler.faulttolerant.OutputDataSizeEstimatorFactory;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class CompositeOutputDataSizeEstimator
implements OutputDataSizeEstimator {
    private final List<OutputDataSizeEstimator> estimators;

    private CompositeOutputDataSizeEstimator(List<OutputDataSizeEstimator> estimators) {
        this.estimators = ImmutableList.copyOf(estimators);
    }

    @Override
    public Optional<OutputDataSizeEstimator.OutputDataSizeEstimateResult> getEstimatedOutputDataSize(EventDrivenFaultTolerantQueryScheduler.StageExecution stageExecution, Function<StageId, EventDrivenFaultTolerantQueryScheduler.StageExecution> stageExecutionLookup, boolean parentEager) {
        for (OutputDataSizeEstimator estimator : this.estimators) {
            Optional<OutputDataSizeEstimator.OutputDataSizeEstimateResult> result = estimator.getEstimatedOutputDataSize(stageExecution, stageExecutionLookup, parentEager);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    public static @interface ForCompositeOutputDataSizeEstimator {
    }

    public static class Factory
    implements OutputDataSizeEstimatorFactory {
        private final List<OutputDataSizeEstimatorFactory> delegateFactories;

        @Inject
        public Factory(@ForCompositeOutputDataSizeEstimator List<OutputDataSizeEstimatorFactory> delegateFactories) {
            Preconditions.checkArgument((!delegateFactories.isEmpty() ? 1 : 0) != 0, (Object)"Got empty list of delegates");
            this.delegateFactories = ImmutableList.copyOf(delegateFactories);
        }

        @Override
        public OutputDataSizeEstimator create(Session session) {
            List estimators = (List)this.delegateFactories.stream().map(factory -> factory.create(session)).collect(ImmutableList.toImmutableList());
            return new CompositeOutputDataSizeEstimator(estimators);
        }
    }
}

