/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import io.trino.execution.scheduler.faulttolerant.NodeRequirements;
import io.trino.execution.scheduler.faulttolerant.SplitAssigner;
import io.trino.metadata.Split;
import io.trino.spi.HostAddress;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class SingleDistributionSplitAssigner
implements SplitAssigner {
    private final Set<HostAddress> hostRequirement;
    private final Set<PlanNodeId> allSources;
    private boolean partitionAdded;
    private final Set<PlanNodeId> completedSources = new HashSet<PlanNodeId>();

    SingleDistributionSplitAssigner(Set<HostAddress> hostRequirement, Set<PlanNodeId> allSources) {
        this.hostRequirement = ImmutableSet.copyOf((Collection)Objects.requireNonNull(hostRequirement, "hostRequirement is null"));
        this.allSources = ImmutableSet.copyOf((Collection)Objects.requireNonNull(allSources, "allSources is null"));
    }

    @Override
    public SplitAssigner.AssignmentResult assign(PlanNodeId planNodeId, ListMultimap<Integer, Split> splits, boolean noMoreSplits) {
        SplitAssigner.AssignmentResult.Builder assignment = SplitAssigner.AssignmentResult.builder();
        if (!this.partitionAdded) {
            this.partitionAdded = true;
            assignment.addPartition(new SplitAssigner.Partition(0, new NodeRequirements(Optional.empty(), this.hostRequirement)));
            assignment.setNoMorePartitions();
        }
        if (!splits.isEmpty()) {
            Preconditions.checkState((!this.completedSources.contains(planNodeId) ? 1 : 0) != 0, (String)"source is finished: %s", (Object)planNodeId);
            assignment.updatePartition(new SplitAssigner.PartitionUpdate(0, planNodeId, true, (List<Split>)ImmutableList.copyOf((Collection)splits.values()), false));
        }
        if (noMoreSplits) {
            assignment.updatePartition(new SplitAssigner.PartitionUpdate(0, planNodeId, false, (List<Split>)ImmutableList.of(), true));
            this.completedSources.add(planNodeId);
        }
        if (this.completedSources.containsAll(this.allSources)) {
            assignment.sealPartition(0);
        }
        return assignment.build();
    }

    @Override
    public SplitAssigner.AssignmentResult finish() {
        SplitAssigner.AssignmentResult.Builder result = SplitAssigner.AssignmentResult.builder();
        if (!this.partitionAdded) {
            this.partitionAdded = true;
            result.addPartition(new SplitAssigner.Partition(0, new NodeRequirements(Optional.empty(), this.hostRequirement))).sealPartition(0).setNoMorePartitions();
        }
        return result.build();
    }
}

