/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import io.trino.metadata.CatalogFunctionMetadata;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.Metadata;
import io.trino.metadata.SignatureBinder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.function.Signature;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.type.UnknownType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

class FunctionBinder {
    private final Metadata metadata;
    private final TypeManager typeManager;

    public FunctionBinder(Metadata metadata, TypeManager typeManager) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    CatalogFunctionBinding bindFunction(List<TypeSignatureProvider> parameterTypes, Collection<CatalogFunctionMetadata> candidates, String displayName) {
        return this.tryBindFunction(parameterTypes, candidates).orElseThrow(() -> FunctionBinder.functionNotFound(displayName, parameterTypes, candidates));
    }

    Optional<CatalogFunctionBinding> tryBindFunction(List<TypeSignatureProvider> parameterTypes, Collection<CatalogFunctionMetadata> candidates) {
        List exactCandidates = (List)candidates.stream().filter(function -> function.functionMetadata().getSignature().getTypeVariableConstraints().isEmpty()).collect(ImmutableList.toImmutableList());
        Optional<CatalogFunctionBinding> match = this.matchFunctionExact(exactCandidates, parameterTypes);
        if (match.isPresent()) {
            return match;
        }
        List genericCandidates = (List)candidates.stream().filter(function -> !function.functionMetadata().getSignature().getTypeVariableConstraints().isEmpty()).collect(ImmutableList.toImmutableList());
        match = this.matchFunctionExact(genericCandidates, parameterTypes);
        if (match.isPresent()) {
            return match;
        }
        return this.matchFunctionWithCoercion(candidates, parameterTypes);
    }

    CatalogFunctionBinding bindCoercion(Signature signature, Collection<CatalogFunctionMetadata> candidates) {
        List exactCandidates = (List)candidates.stream().filter(function -> FunctionBinder.possibleExactCastMatch(signature, function.functionMetadata().getSignature())).collect(ImmutableList.toImmutableList());
        for (CatalogFunctionMetadata candidate : exactCandidates) {
            if (!this.canBindSignature(candidate.functionMetadata().getSignature(), signature)) continue;
            return this.toFunctionBinding(candidate, signature);
        }
        List genericCandidates = (List)candidates.stream().filter(function -> !function.functionMetadata().getSignature().getTypeVariableConstraints().isEmpty()).collect(ImmutableList.toImmutableList());
        for (CatalogFunctionMetadata candidate : genericCandidates) {
            if (!this.canBindSignature(candidate.functionMetadata().getSignature(), signature)) continue;
            return this.toFunctionBinding(candidate, signature);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, String.format("%s not found", signature));
    }

    private boolean canBindSignature(Signature declaredSignature, Signature actualSignature) {
        return new SignatureBinder(this.metadata, this.typeManager, declaredSignature, false).canBind(TypeSignatureProvider.fromTypeSignatures(actualSignature.getArgumentTypes()), actualSignature.getReturnType());
    }

    private static boolean possibleExactCastMatch(Signature signature, Signature declaredSignature) {
        if (!declaredSignature.getTypeVariableConstraints().isEmpty()) {
            return false;
        }
        if (!declaredSignature.getReturnType().getBase().equalsIgnoreCase(signature.getReturnType().getBase())) {
            return false;
        }
        return ((TypeSignature)declaredSignature.getArgumentTypes().get(0)).getBase().equalsIgnoreCase(((TypeSignature)signature.getArgumentTypes().get(0)).getBase());
    }

    private Optional<CatalogFunctionBinding> matchFunctionExact(List<CatalogFunctionMetadata> candidates, List<TypeSignatureProvider> actualParameters) {
        return this.matchFunction(candidates, actualParameters, false);
    }

    private Optional<CatalogFunctionBinding> matchFunctionWithCoercion(Collection<CatalogFunctionMetadata> candidates, List<TypeSignatureProvider> actualParameters) {
        return this.matchFunction(candidates, actualParameters, true);
    }

    private Optional<CatalogFunctionBinding> matchFunction(Collection<CatalogFunctionMetadata> candidates, List<TypeSignatureProvider> parameters, boolean coercionAllowed) {
        List<ApplicableFunction> applicableFunctions = this.identifyApplicableFunctions(candidates, parameters, coercionAllowed);
        if (applicableFunctions.isEmpty()) {
            return Optional.empty();
        }
        if (coercionAllowed) {
            Preconditions.checkState((!(applicableFunctions = this.selectMostSpecificFunctions(applicableFunctions, parameters)).isEmpty() ? 1 : 0) != 0, (Object)"at least single function must be left");
        }
        if (applicableFunctions.size() == 1) {
            ApplicableFunction applicableFunction = (ApplicableFunction)Iterables.getOnlyElement(applicableFunctions);
            return Optional.of(this.toFunctionBinding(applicableFunction.function(), applicableFunction.boundSignature()));
        }
        StringBuilder errorMessageBuilder = new StringBuilder();
        errorMessageBuilder.append("Could not choose a best candidate operator. Explicit type casts must be added.\n");
        errorMessageBuilder.append("Candidates are:\n");
        for (ApplicableFunction function : applicableFunctions) {
            errorMessageBuilder.append("\t * ");
            errorMessageBuilder.append(function.boundSignature());
            errorMessageBuilder.append("\n");
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_CALL, errorMessageBuilder.toString());
    }

    private List<ApplicableFunction> identifyApplicableFunctions(Collection<CatalogFunctionMetadata> candidates, List<TypeSignatureProvider> actualParameters, boolean allowCoercion) {
        ImmutableList.Builder applicableFunctions = ImmutableList.builder();
        for (CatalogFunctionMetadata function : candidates) {
            new SignatureBinder(this.metadata, this.typeManager, function.functionMetadata().getSignature(), allowCoercion).bind(actualParameters).ifPresent(signature -> applicableFunctions.add((Object)new ApplicableFunction(function, (Signature)signature)));
        }
        return applicableFunctions.build();
    }

    private List<ApplicableFunction> selectMostSpecificFunctions(List<ApplicableFunction> applicableFunctions, List<TypeSignatureProvider> parameters) {
        Preconditions.checkArgument((!applicableFunctions.isEmpty() ? 1 : 0) != 0);
        List<ApplicableFunction> mostSpecificFunctions = this.selectMostSpecificFunctions(applicableFunctions);
        if (mostSpecificFunctions.size() <= 1) {
            return mostSpecificFunctions;
        }
        Optional<List<Type>> optionalParameterTypes = this.toTypes(parameters);
        if (optionalParameterTypes.isEmpty()) {
            return mostSpecificFunctions;
        }
        List<Type> parameterTypes = optionalParameterTypes.get();
        if (!FunctionBinder.someParameterIsUnknown(parameterTypes)) {
            return mostSpecificFunctions;
        }
        List<ApplicableFunction> unknownOnlyCastFunctions = this.getUnknownOnlyCastFunctions(applicableFunctions, parameterTypes);
        if (!unknownOnlyCastFunctions.isEmpty() && (mostSpecificFunctions = unknownOnlyCastFunctions).size() == 1) {
            return mostSpecificFunctions;
        }
        if (this.returnTypeIsTheSame(mostSpecificFunctions) && FunctionBinder.allReturnNullOnGivenInputTypes(mostSpecificFunctions, parameterTypes)) {
            ApplicableFunction selectedFunction = (ApplicableFunction)Ordering.usingToString().reverse().sortedCopy(mostSpecificFunctions).get(0);
            return ImmutableList.of((Object)selectedFunction);
        }
        return mostSpecificFunctions;
    }

    private List<ApplicableFunction> selectMostSpecificFunctions(List<ApplicableFunction> candidates) {
        ArrayList<ApplicableFunction> representatives = new ArrayList<ApplicableFunction>();
        for (ApplicableFunction current : candidates) {
            boolean found = false;
            for (int i = 0; i < representatives.size(); ++i) {
                ApplicableFunction representative = (ApplicableFunction)representatives.get(i);
                if (this.isMoreSpecificThan(current, representative)) {
                    representatives.set(i, current);
                }
                if (!this.isMoreSpecificThan(current, representative) && !this.isMoreSpecificThan(representative, current)) continue;
                found = true;
                break;
            }
            if (found) continue;
            representatives.add(current);
        }
        return representatives;
    }

    private static boolean someParameterIsUnknown(List<Type> parameters) {
        return parameters.stream().anyMatch(type -> type.equals((Object)UnknownType.UNKNOWN));
    }

    private List<ApplicableFunction> getUnknownOnlyCastFunctions(List<ApplicableFunction> applicableFunction, List<Type> actualParameters) {
        return (List)applicableFunction.stream().filter(function -> this.onlyCastsUnknown((ApplicableFunction)function, actualParameters)).collect(ImmutableList.toImmutableList());
    }

    private boolean onlyCastsUnknown(ApplicableFunction applicableFunction, List<Type> actualParameters) {
        List boundTypes = (List)applicableFunction.boundSignature().getArgumentTypes().stream().map(arg_0 -> ((TypeManager)this.typeManager).getType(arg_0)).collect(ImmutableList.toImmutableList());
        Preconditions.checkState((actualParameters.size() == boundTypes.size() ? 1 : 0) != 0, (Object)"type lists are of different lengths");
        for (int i = 0; i < actualParameters.size(); ++i) {
            if (((Type)boundTypes.get(i)).equals(actualParameters.get(i)) || actualParameters.get(i) == UnknownType.UNKNOWN) continue;
            return false;
        }
        return true;
    }

    private boolean returnTypeIsTheSame(List<ApplicableFunction> applicableFunctions) {
        Set returnTypes = applicableFunctions.stream().map(function -> this.typeManager.getType(function.boundSignature().getReturnType())).collect(Collectors.toSet());
        return returnTypes.size() == 1;
    }

    private static boolean allReturnNullOnGivenInputTypes(List<ApplicableFunction> applicableFunctions, List<Type> parameters) {
        return applicableFunctions.stream().allMatch(x -> FunctionBinder.returnsNullOnGivenInputTypes(x, parameters));
    }

    private static boolean returnsNullOnGivenInputTypes(ApplicableFunction applicableFunction, List<Type> parameterTypes) {
        FunctionMetadata function = applicableFunction.functionMetadata();
        if (function.getKind() != FunctionKind.SCALAR) {
            return true;
        }
        FunctionNullability functionNullability = function.getFunctionNullability();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            if (!parameterTypes.get(i).equals((Object)UnknownType.UNKNOWN) || functionNullability.isArgumentNullable(i)) continue;
            return true;
        }
        return false;
    }

    private Optional<List<Type>> toTypes(List<TypeSignatureProvider> typeSignatureProviders) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (TypeSignatureProvider typeSignatureProvider : typeSignatureProviders) {
            if (typeSignatureProvider.hasDependency()) {
                return Optional.empty();
            }
            resultBuilder.add((Object)this.typeManager.getType(typeSignatureProvider.getTypeSignature()));
        }
        return Optional.of(resultBuilder.build());
    }

    private boolean isMoreSpecificThan(ApplicableFunction left, ApplicableFunction right) {
        List<TypeSignatureProvider> resolvedTypes = TypeSignatureProvider.fromTypeSignatures(left.boundSignature().getArgumentTypes());
        return new SignatureBinder(this.metadata, this.typeManager, right.declaredSignature(), true).canBind(resolvedTypes);
    }

    private CatalogFunctionBinding toFunctionBinding(CatalogFunctionMetadata functionMetadata, Signature signature) {
        BoundSignature boundSignature = new BoundSignature(new CatalogSchemaFunctionName(functionMetadata.catalogHandle().getCatalogName(), functionMetadata.schemaName(), functionMetadata.functionMetadata().getCanonicalName()), this.typeManager.getType(signature.getReturnType()), (List)signature.getArgumentTypes().stream().map(arg_0 -> ((TypeManager)this.typeManager).getType(arg_0)).collect(ImmutableList.toImmutableList()));
        return new CatalogFunctionBinding(functionMetadata.catalogHandle(), FunctionBinder.bindFunctionMetadata(boundSignature, functionMetadata.functionMetadata()), SignatureBinder.bindFunction(functionMetadata.functionMetadata().getFunctionId(), functionMetadata.functionMetadata().getSignature(), boundSignature));
    }

    private static FunctionMetadata bindFunctionMetadata(BoundSignature signature, FunctionMetadata functionMetadata) {
        FunctionMetadata.Builder newMetadata = FunctionMetadata.builder((String)functionMetadata.getCanonicalName(), (FunctionKind)functionMetadata.getKind()).functionId(functionMetadata.getFunctionId()).signature(signature.toSignature());
        functionMetadata.getNames().forEach(arg_0 -> ((FunctionMetadata.Builder)newMetadata).alias(arg_0));
        if (functionMetadata.getDescription().isEmpty()) {
            newMetadata.noDescription();
        } else {
            newMetadata.description(functionMetadata.getDescription());
        }
        if (functionMetadata.isHidden()) {
            newMetadata.hidden();
        }
        if (!functionMetadata.isDeterministic()) {
            newMetadata.nondeterministic();
        }
        if (functionMetadata.isDeprecated()) {
            newMetadata.deprecated();
        }
        if (functionMetadata.getFunctionNullability().isReturnNullable()) {
            newMetadata.nullable();
        }
        List argumentNullability = functionMetadata.getFunctionNullability().getArgumentNullable();
        if (functionMetadata.getSignature().isVariableArity()) {
            List fixedArgumentNullability = argumentNullability.subList(0, argumentNullability.size() - 1);
            int variableArgumentCount = signature.getArgumentTypes().size() - fixedArgumentNullability.size();
            argumentNullability = ImmutableList.builder().addAll(fixedArgumentNullability).addAll(Collections.nCopies(variableArgumentCount, (Boolean)argumentNullability.get(argumentNullability.size() - 1))).build();
        }
        newMetadata.argumentNullability(argumentNullability);
        return newMetadata.build();
    }

    static TrinoException functionNotFound(String name, List<TypeSignatureProvider> parameterTypes, Collection<CatalogFunctionMetadata> candidates) {
        if (candidates.isEmpty()) {
            return new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Function '%s' not registered", name));
        }
        TreeSet<String> expectedParameters = new TreeSet<String>();
        for (CatalogFunctionMetadata function : candidates) {
            String arguments = Joiner.on((String)", ").join((Iterable)function.functionMetadata().getSignature().getArgumentTypes());
            String constraints = Joiner.on((String)", ").join((Iterable)function.functionMetadata().getSignature().getTypeVariableConstraints());
            expectedParameters.add(String.format("%s(%s) %s", name, arguments, constraints).stripTrailing());
        }
        String parameters = Joiner.on((String)", ").join(parameterTypes);
        String expected = Joiner.on((String)", ").join(expectedParameters);
        String message = String.format("Unexpected parameters (%s) for function %s. Expected: %s", parameters, name, expected);
        return new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, message);
    }

    record CatalogFunctionBinding(CatalogHandle catalogHandle, FunctionMetadata functionMetadata, FunctionBinding functionBinding) {
        CatalogFunctionBinding {
            Objects.requireNonNull(catalogHandle, "catalogHandle is null");
            Objects.requireNonNull(functionMetadata, "functionMetadata is null");
            Objects.requireNonNull(functionBinding, "functionBinding is null");
        }
    }

    private record ApplicableFunction(CatalogFunctionMetadata function, Signature boundSignature) {
        public FunctionMetadata functionMetadata() {
            return this.function.functionMetadata();
        }

        public Signature declaredSignature() {
            return this.function.functionMetadata().getSignature();
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("declaredSignature", (Object)this.function.functionMetadata().getSignature()).add("boundSignature", (Object)this.boundSignature).toString();
        }
    }
}

