/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.FlatSet;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import java.util.Objects;

public class ChannelSet {
    private final FlatSet set;

    private ChannelSet(FlatSet set) {
        this.set = set;
    }

    public long getEstimatedSizeInBytes() {
        return this.set.getEstimatedSize();
    }

    public int size() {
        return this.set.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsNull() {
        return this.set.containsNull();
    }

    public boolean contains(Block valueBlock, int position) {
        return this.set.contains(valueBlock, position);
    }

    public boolean contains(Block valueBlock, int position, long rawHash) {
        return this.set.contains(valueBlock, position, rawHash);
    }

    public static class ChannelSetBuilder {
        private final LocalMemoryContext memoryContext;
        private final FlatSet set;

        public ChannelSetBuilder(Type type, TypeOperators typeOperators, LocalMemoryContext memoryContext) {
            this.set = new FlatSet(type, typeOperators.getReadValueOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FLAT_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL})), typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT})), typeOperators.getDistinctFromOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL})), typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL})));
            this.memoryContext = Objects.requireNonNull(memoryContext, "memoryContext is null");
            this.memoryContext.setBytes(this.set.getEstimatedSize());
        }

        public ChannelSet build() {
            return new ChannelSet(this.set);
        }

        public void addAll(Block valueBlock, Block hashBlock) {
            if (valueBlock.getPositionCount() == 0) {
                return;
            }
            if (valueBlock instanceof RunLengthEncodedBlock) {
                RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)valueBlock;
                if (hashBlock != null) {
                    this.set.add(rleBlock.getValue(), 0, BigintType.BIGINT.getLong(hashBlock, 0));
                } else {
                    this.set.add(rleBlock.getValue(), 0);
                }
            } else if (hashBlock != null) {
                for (int position = 0; position < valueBlock.getPositionCount(); ++position) {
                    this.set.add(valueBlock, position, BigintType.BIGINT.getLong(hashBlock, position));
                }
            } else {
                for (int position = 0; position < valueBlock.getPositionCount(); ++position) {
                    this.set.add(valueBlock, position);
                }
            }
            this.memoryContext.setBytes(this.set.getEstimatedSize());
        }
    }
}

