/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.MapAggregationState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameters;

@AggregationFunction(value="map_agg", isOrderSensitive=true)
@Description(value="Aggregates all the rows (key/value pairs) into a single map")
public final class MapAggregationFunction {
    private MapAggregationFunction() {
    }

    @InputFunction
    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    public static void input(@AggregationState(value={"K", "V"}) MapAggregationState state, @BlockPosition @SqlType(value="K") Block key, @SqlNullable @BlockPosition @SqlType(value="V") Block value, @BlockIndex int position) {
        state.add(key, position, value, position);
    }

    @CombineFunction
    public static void combine(@AggregationState(value={"K", "V"}) MapAggregationState state, @AggregationState(value={"K", "V"}) MapAggregationState otherState) {
        state.merge(otherState);
    }

    @OutputFunction(value="map(K, V)")
    public static void output(@AggregationState(value={"K", "V"}) MapAggregationState state, BlockBuilder out) {
        state.writeAll((MapBlockBuilder)out);
    }
}

