/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.MapAggregationStateFactory;
import io.trino.operator.aggregation.MapAggregationStateSerializer;
import io.trino.operator.aggregation.SingleMapAggregationState;
import io.trino.spi.block.Block;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateMetadata;

@AccumulatorStateMetadata(stateFactoryClass=MapAggregationStateFactory.class, stateSerializerClass=MapAggregationStateSerializer.class, typeParameters={"K", "V"}, serializedType="map(K, V)")
public interface MapAggregationState
extends AccumulatorState {
    public void add(Block var1, int var2, Block var3, int var4);

    default public void merge(MapAggregationState other) {
        SqlMap serializedState = ((SingleMapAggregationState)other).removeTempSerializedState();
        int rawOffset = serializedState.getRawOffset();
        Block rawKeyBlock = serializedState.getRawKeyBlock();
        Block rawValueBlock = serializedState.getRawValueBlock();
        for (int i = 0; i < serializedState.getSize(); ++i) {
            this.add(rawKeyBlock, rawOffset + i, rawValueBlock, rawOffset + i);
        }
    }

    public void writeAll(MapBlockBuilder var1);
}

