/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.MapAggregationState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameters;
import io.trino.spi.type.Type;

@AggregationFunction(value="map_union")
@Description(value="Aggregate all the maps into a single map")
public final class MapUnionAggregation {
    private MapUnionAggregation() {
    }

    @InputFunction
    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    public static void input(@TypeParameter(value="V") Type valueType, @AggregationState(value={"K", "V"}) MapAggregationState state, @SqlType(value="map(K,V)") SqlMap value) {
        int rawOffset = value.getRawOffset();
        Block rawKeyBlock = value.getRawKeyBlock();
        Block rawValueBlock = value.getRawValueBlock();
        for (int i = 0; i < value.getSize(); ++i) {
            state.add(rawKeyBlock, rawOffset + i, rawValueBlock, rawOffset + i);
        }
    }

    @CombineFunction
    public static void combine(@AggregationState(value={"K", "V"}) MapAggregationState state, @AggregationState(value={"K", "V"}) MapAggregationState otherState) {
        state.merge(otherState);
    }

    @OutputFunction(value="map(K, V)")
    public static void output(@AggregationState(value={"K", "V"}) MapAggregationState state, BlockBuilder out) {
        state.writeAll((MapBlockBuilder)out);
    }
}

