/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.histogram;

import io.trino.operator.aggregation.histogram.HistogramStateFactory;
import io.trino.operator.aggregation.histogram.HistogramStateSerializer;
import io.trino.operator.aggregation.histogram.SingleHistogramState;
import io.trino.spi.block.Block;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateMetadata;
import io.trino.spi.type.BigintType;

@AccumulatorStateMetadata(stateFactoryClass=HistogramStateFactory.class, stateSerializerClass=HistogramStateSerializer.class, typeParameters={"T"}, serializedType="map(T, BIGINT)")
public interface HistogramState
extends AccumulatorState {
    public void add(Block var1, int var2, long var3);

    default public void merge(HistogramState other) {
        SqlMap serializedState = ((SingleHistogramState)other).removeTempSerializedState();
        int rawOffset = serializedState.getRawOffset();
        Block rawKeyBlock = serializedState.getRawKeyBlock();
        Block rawValueBlock = serializedState.getRawValueBlock();
        for (int i = 0; i < serializedState.getSize(); ++i) {
            this.add(rawKeyBlock, rawOffset + i, BigintType.BIGINT.getLong(rawValueBlock, rawOffset + i));
        }
    }

    public void writeAll(MapBlockBuilder var1);
}

