/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.histogram;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.trino.operator.aggregation.histogram.HistogramState;
import io.trino.operator.aggregation.histogram.TypedHistogram;
import io.trino.spi.block.Block;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.Objects;

public class SingleHistogramState
implements HistogramState {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SingleHistogramState.class);
    private final Type keyType;
    private final MethodHandle readFlat;
    private final MethodHandle writeFlat;
    private final MethodHandle hashFlat;
    private final MethodHandle distinctFlatBlock;
    private final MethodHandle hashBlock;
    private TypedHistogram typedHistogram;
    private SqlMap tempSerializedState;

    public SingleHistogramState(Type keyType, MethodHandle readFlat, MethodHandle writeFlat, MethodHandle hashFlat, MethodHandle distinctFlatBlock, MethodHandle hashBlock) {
        this.keyType = Objects.requireNonNull(keyType, "keyType is null");
        this.readFlat = Objects.requireNonNull(readFlat, "readFlat is null");
        this.writeFlat = Objects.requireNonNull(writeFlat, "writeFlat is null");
        this.hashFlat = Objects.requireNonNull(hashFlat, "hashFlat is null");
        this.distinctFlatBlock = Objects.requireNonNull(distinctFlatBlock, "distinctFlatBlock is null");
        this.hashBlock = Objects.requireNonNull(hashBlock, "hashBlock is null");
    }

    @Override
    public void add(Block block, int position, long count) {
        if (this.typedHistogram == null) {
            this.typedHistogram = new TypedHistogram(this.keyType, this.readFlat, this.writeFlat, this.hashFlat, this.distinctFlatBlock, this.hashBlock, false);
        }
        this.typedHistogram.add(0, block, position, count);
    }

    @Override
    public void writeAll(MapBlockBuilder out) {
        if (this.typedHistogram == null) {
            out.appendNull();
            return;
        }
        this.typedHistogram.serialize(0, out);
    }

    public long getEstimatedSize() {
        long estimatedSize = INSTANCE_SIZE;
        if (this.typedHistogram != null) {
            estimatedSize += this.typedHistogram.getEstimatedSize();
        }
        return estimatedSize;
    }

    void setTempSerializedState(SqlMap tempSerializedState) {
        this.tempSerializedState = tempSerializedState;
    }

    SqlMap removeTempSerializedState() {
        SqlMap sqlMap = this.tempSerializedState;
        Preconditions.checkState((sqlMap != null ? 1 : 0) != 0, (Object)"tempDeserializeBlock is null");
        this.tempSerializedState = null;
        return sqlMap;
    }
}

