/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxn;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.trino.array.ObjectBigArray;
import io.trino.operator.aggregation.minmaxn.MinMaxNState;
import io.trino.operator.aggregation.minmaxn.TypedHeap;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.SqlRow;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.GroupedAccumulatorState;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import java.util.Objects;
import java.util.function.LongFunction;

public final class MinMaxNStateFactory {
    private MinMaxNStateFactory() {
    }

    public static abstract class SingleMinMaxNState
    extends AbstractMinMaxNState {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(SingleMinMaxNState.class);
        private final LongFunction<TypedHeap> heapFactory;
        private TypedHeap typedHeap;
        private SqlRow tempSerializedState;

        public SingleMinMaxNState(LongFunction<TypedHeap> heapFactory) {
            this.heapFactory = Objects.requireNonNull(heapFactory, "heapFactory is null");
        }

        protected SingleMinMaxNState(SingleMinMaxNState state) {
            Preconditions.checkArgument((state.tempSerializedState == null ? 1 : 0) != 0);
            this.tempSerializedState = null;
            this.heapFactory = state.heapFactory;
            this.typedHeap = state.typedHeap != null ? new TypedHeap(state.typedHeap) : null;
        }

        public abstract AccumulatorState copy();

        public final long getEstimatedSize() {
            return (long)INSTANCE_SIZE + (this.typedHeap == null ? 0L : this.typedHeap.getEstimatedSize());
        }

        @Override
        public final void initialize(long n) {
            if (this.typedHeap == null) {
                this.typedHeap = this.heapFactory.apply(n);
            }
        }

        @Override
        public final void add(Block block, int position) {
            this.typedHeap.add(block, position);
        }

        @Override
        public final void writeAllSorted(BlockBuilder out) {
            if (this.typedHeap == null || this.typedHeap.isEmpty()) {
                out.appendNull();
                return;
            }
            ((ArrayBlockBuilder)out).buildEntry(this.typedHeap::writeAllSorted);
        }

        @Override
        final TypedHeap getTypedHeap() {
            return this.typedHeap;
        }

        void setTempSerializedState(SqlRow tempSerializedState) {
            this.tempSerializedState = tempSerializedState;
        }

        SqlRow removeTempSerializedState() {
            SqlRow sqlRow = this.tempSerializedState;
            Preconditions.checkState((sqlRow != null ? 1 : 0) != 0, (Object)"tempDeserializeBlock is null");
            this.tempSerializedState = null;
            return sqlRow;
        }
    }

    public static abstract class GroupedMinMaxNState
    extends AbstractMinMaxNState
    implements GroupedAccumulatorState {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(GroupedMinMaxNState.class);
        private final LongFunction<TypedHeap> heapFactory;
        private final ObjectBigArray<TypedHeap> heaps = new ObjectBigArray();
        private long groupId;
        private long size;

        public GroupedMinMaxNState(LongFunction<TypedHeap> heapFactory) {
            this.heapFactory = heapFactory;
        }

        public final void setGroupId(long groupId) {
            this.groupId = groupId;
        }

        public final void ensureCapacity(long size) {
            this.heaps.ensureCapacity(size);
        }

        public final long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.heaps.sizeOf() + this.size;
        }

        @Override
        public final void initialize(long n) {
            if (this.getTypedHeap() == null) {
                TypedHeap typedHeap = this.heapFactory.apply(n);
                this.setTypedHeap(typedHeap);
                this.size += typedHeap.getEstimatedSize();
            }
        }

        @Override
        public final void add(Block block, int position) {
            TypedHeap typedHeap = this.getTypedHeap();
            this.size -= typedHeap.getEstimatedSize();
            typedHeap.add(block, position);
            this.size += typedHeap.getEstimatedSize();
        }

        @Override
        public final void writeAllSorted(BlockBuilder out) {
            TypedHeap typedHeap = this.getTypedHeap();
            if (typedHeap == null || typedHeap.isEmpty()) {
                out.appendNull();
                return;
            }
            ((ArrayBlockBuilder)out).buildEntry(typedHeap::writeAllSorted);
        }

        @Override
        final TypedHeap getTypedHeap() {
            return (TypedHeap)this.heaps.get(this.groupId);
        }

        private void setTypedHeap(TypedHeap value) {
            this.heaps.set(this.groupId, (Object)value);
        }
    }

    private static abstract class AbstractMinMaxNState
    implements MinMaxNState {
        private AbstractMinMaxNState() {
        }

        abstract TypedHeap getTypedHeap();

        @Override
        public final void merge(MinMaxNState other) {
            SqlRow sqlRow = ((SingleMinMaxNState)other).removeTempSerializedState();
            int rawIndex = sqlRow.getRawIndex();
            int capacity = Math.toIntExact(BigintType.BIGINT.getLong(sqlRow.getRawFieldBlock(0), rawIndex));
            this.initialize(capacity);
            TypedHeap typedHeap = this.getTypedHeap();
            Block values = new ArrayType(typedHeap.getElementType()).getObject(sqlRow.getRawFieldBlock(1), rawIndex);
            typedHeap.addAll(values);
        }

        @Override
        public final void serialize(BlockBuilder out) {
            TypedHeap typedHeap = this.getTypedHeap();
            if (typedHeap == null) {
                out.appendNull();
            } else {
                ((RowBlockBuilder)out).buildEntry(fieldBuilders -> {
                    BigintType.BIGINT.writeLong((BlockBuilder)fieldBuilders.get(0), (long)typedHeap.getCapacity());
                    ((ArrayBlockBuilder)fieldBuilders.get(1)).buildEntry(typedHeap::writeAllUnsorted);
                });
            }
        }
    }
}

