/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.multimapagg;

import com.google.common.base.Preconditions;
import io.trino.operator.aggregation.multimapagg.AbstractMultimapAggregationState;
import io.trino.operator.aggregation.multimapagg.MultimapAggregationState;
import io.trino.spi.block.Block;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;

public class SingleMultimapAggregationState
extends AbstractMultimapAggregationState {
    private SqlMap tempSerializedState;

    public SingleMultimapAggregationState(Type keyType, MethodHandle keyReadFlat, MethodHandle keyWriteFlat, MethodHandle hashFlat, MethodHandle distinctFlatBlock, MethodHandle keyHashBlock, Type valueType, MethodHandle valueReadFlat, MethodHandle valueWriteFlat) {
        super(keyType, keyReadFlat, keyWriteFlat, hashFlat, distinctFlatBlock, keyHashBlock, valueType, valueReadFlat, valueWriteFlat, false);
    }

    private SingleMultimapAggregationState(SingleMultimapAggregationState state) {
        super(state);
        Preconditions.checkArgument((state.tempSerializedState == null ? 1 : 0) != 0, (Object)"state.tempSerializedState is not null");
        this.tempSerializedState = null;
    }

    @Override
    public void add(Block keyBlock, int keyPosition, Block valueBlock, int valuePosition) {
        this.add(0, keyBlock, keyPosition, valueBlock, valuePosition);
    }

    @Override
    public void merge(MultimapAggregationState other) {
        SqlMap serializedState = ((SingleMultimapAggregationState)other).removeTempSerializedState();
        this.deserialize(0, serializedState);
    }

    @Override
    public void writeAll(MapBlockBuilder out) {
        this.serialize(0, out);
    }

    public AccumulatorState copy() {
        return new SingleMultimapAggregationState(this);
    }

    void setTempSerializedState(SqlMap tempSerializedState) {
        this.tempSerializedState = tempSerializedState;
    }

    SqlMap removeTempSerializedState() {
        SqlMap sqlMap = this.tempSerializedState;
        Preconditions.checkState((sqlMap != null ? 1 : 0) != 0, (Object)"tempDeserializeBlock is null");
        this.tempSerializedState = null;
        return sqlMap;
    }
}

