/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import io.airlift.slice.SizeOf;
import io.trino.operator.output.PositionsAppender;
import io.trino.operator.output.PositionsAppenderFactory;
import io.trino.operator.output.PositionsAppenderUtil;
import io.trino.spi.block.Block;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.RowType;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RowPositionsAppender
implements PositionsAppender {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(RowPositionsAppender.class);
    private final PositionsAppender[] fieldAppenders;
    private int initialEntryCount;
    private boolean initialized;
    private int positionCount;
    private boolean hasNullRow;
    private boolean hasNonNullRow;
    private boolean[] rowIsNull = new boolean[0];
    private long retainedSizeInBytes = -1L;
    private long sizeInBytes = -1L;

    public static RowPositionsAppender createRowAppender(PositionsAppenderFactory positionsAppenderFactory, RowType type, int expectedPositions, long maxPageSizeInBytes) {
        PositionsAppender[] fields = new PositionsAppender[type.getFields().size()];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = positionsAppenderFactory.create(((RowType.Field)type.getFields().get(i)).getType(), expectedPositions, maxPageSizeInBytes);
        }
        return new RowPositionsAppender(fields, expectedPositions);
    }

    private RowPositionsAppender(PositionsAppender[] fieldAppenders, int expectedPositions) {
        this.fieldAppenders = Objects.requireNonNull(fieldAppenders, "fields is null");
        this.initialEntryCount = expectedPositions;
        this.resetSize();
    }

    @Override
    public void append(IntArrayList positions, Block block) {
        if (positions.isEmpty()) {
            return;
        }
        this.ensureCapacity(positions.size());
        if (block instanceof RowBlock) {
            IntArrayList nonNullPositions;
            RowBlock sourceRowBlock = (RowBlock)block;
            if (sourceRowBlock.mayHaveNull()) {
                nonNullPositions = this.processNullablePositions(positions, sourceRowBlock);
                this.hasNullRow |= nonNullPositions.size() < positions.size();
                this.hasNonNullRow |= nonNullPositions.size() > 0;
            } else {
                nonNullPositions = this.processNonNullablePositions(positions, sourceRowBlock);
                this.hasNonNullRow = true;
            }
            List fieldBlocks = sourceRowBlock.getChildren();
            for (int i = 0; i < this.fieldAppenders.length; ++i) {
                this.fieldAppenders[i].append(nonNullPositions, (Block)fieldBlocks.get(i));
            }
        } else if (this.allPositionsNull(positions, block)) {
            Arrays.fill(this.rowIsNull, this.positionCount, this.positionCount + positions.size(), true);
            this.hasNullRow = true;
        } else {
            throw new IllegalArgumentException("unsupported block type: " + block);
        }
        this.positionCount += positions.size();
        this.resetSize();
    }

    @Override
    public void appendRle(Block value, int rlePositionCount) {
        this.ensureCapacity(rlePositionCount);
        if (value instanceof RowBlock) {
            RowBlock sourceRowBlock = (RowBlock)value;
            if (sourceRowBlock.isNull(0)) {
                Arrays.fill(this.rowIsNull, this.positionCount, this.positionCount + rlePositionCount, true);
                this.hasNullRow = true;
            } else {
                List fieldBlocks = sourceRowBlock.getChildren();
                int fieldPosition = sourceRowBlock.getFieldBlockOffset(0);
                for (int i = 0; i < this.fieldAppenders.length; ++i) {
                    this.fieldAppenders[i].appendRle(((Block)fieldBlocks.get(i)).getSingleValueBlock(fieldPosition), rlePositionCount);
                }
                this.hasNonNullRow = true;
            }
        } else if (value.isNull(0)) {
            Arrays.fill(this.rowIsNull, this.positionCount, this.positionCount + rlePositionCount, true);
            this.hasNullRow = true;
        } else {
            throw new IllegalArgumentException("unsupported block type: " + value);
        }
        this.positionCount += rlePositionCount;
        this.resetSize();
    }

    @Override
    public void append(int position, Block value) {
        this.ensureCapacity(1);
        if (value instanceof RowBlock) {
            RowBlock sourceRowBlock = (RowBlock)value;
            if (sourceRowBlock.isNull(position)) {
                this.rowIsNull[this.positionCount] = true;
                this.hasNullRow = true;
            } else {
                List fieldBlocks = sourceRowBlock.getChildren();
                int fieldPosition = sourceRowBlock.getFieldBlockOffset(position);
                for (int i = 0; i < this.fieldAppenders.length; ++i) {
                    this.fieldAppenders[i].append(fieldPosition, (Block)fieldBlocks.get(i));
                }
                this.hasNonNullRow = true;
            }
        } else if (value.isNull(position)) {
            this.rowIsNull[this.positionCount] = true;
            this.hasNullRow = true;
        } else {
            throw new IllegalArgumentException("unsupported block type: " + value);
        }
        ++this.positionCount;
        this.resetSize();
    }

    @Override
    public Block build() {
        Block result;
        Block[] fieldBlocks = new Block[this.fieldAppenders.length];
        for (int i = 0; i < this.fieldAppenders.length; ++i) {
            fieldBlocks[i] = this.fieldAppenders[i].build();
        }
        if (this.hasNonNullRow) {
            result = RowBlock.fromFieldBlocks((int)this.positionCount, this.hasNullRow ? Optional.of(this.rowIsNull) : Optional.empty(), (Block[])fieldBlocks);
        } else {
            Block nullRowBlock = RowBlock.fromFieldBlocks((int)1, Optional.of(new boolean[]{true}), (Block[])fieldBlocks);
            result = RunLengthEncodedBlock.create((Block)nullRowBlock, (int)this.positionCount);
        }
        this.reset();
        return result;
    }

    @Override
    public long getRetainedSizeInBytes() {
        if (this.retainedSizeInBytes != -1L) {
            return this.retainedSizeInBytes;
        }
        long size = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.rowIsNull);
        for (PositionsAppender field : this.fieldAppenders) {
            size += field.getRetainedSizeInBytes();
        }
        this.retainedSizeInBytes = size;
        return size;
    }

    @Override
    public long getSizeInBytes() {
        if (this.sizeInBytes != -1L) {
            return this.sizeInBytes;
        }
        long size = 5L * (long)this.positionCount;
        for (PositionsAppender field : this.fieldAppenders) {
            size += field.getSizeInBytes();
        }
        this.sizeInBytes = size;
        return this.sizeInBytes;
    }

    private void reset() {
        this.initialEntryCount = PositionsAppenderUtil.calculateBlockResetSize(this.positionCount);
        this.initialized = false;
        this.rowIsNull = new boolean[0];
        this.positionCount = 0;
        this.hasNonNullRow = false;
        this.hasNullRow = false;
        this.resetSize();
    }

    private boolean allPositionsNull(IntArrayList positions, Block block) {
        for (int i = 0; i < positions.size(); ++i) {
            if (block.isNull(positions.getInt(i))) continue;
            return false;
        }
        return true;
    }

    private IntArrayList processNullablePositions(IntArrayList positions, RowBlock sourceRowBlock) {
        int[] nonNullPositions = new int[positions.size()];
        int nonNullPositionsCount = 0;
        for (int i = 0; i < positions.size(); ++i) {
            int position = positions.getInt(i);
            boolean positionIsNull = sourceRowBlock.isNull(position);
            nonNullPositions[nonNullPositionsCount] = sourceRowBlock.getFieldBlockOffset(position);
            nonNullPositionsCount += positionIsNull ? 0 : 1;
            this.rowIsNull[this.positionCount + i] = positionIsNull;
        }
        return IntArrayList.wrap((int[])nonNullPositions, (int)nonNullPositionsCount);
    }

    private IntArrayList processNonNullablePositions(IntArrayList positions, RowBlock sourceRowBlock) {
        int[] nonNullPositions = new int[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            nonNullPositions[i] = sourceRowBlock.getFieldBlockOffset(positions.getInt(i));
        }
        return IntArrayList.wrap((int[])nonNullPositions);
    }

    private void ensureCapacity(int additionalCapacity) {
        if (this.rowIsNull.length <= this.positionCount + additionalCapacity) {
            int newSize;
            if (this.initialized) {
                newSize = PositionsAppenderUtil.calculateNewArraySize(this.rowIsNull.length);
            } else {
                newSize = this.initialEntryCount;
                this.initialized = true;
            }
            int newCapacity = Math.max(newSize, this.positionCount + additionalCapacity);
            this.rowIsNull = Arrays.copyOf(this.rowIsNull, newCapacity);
            this.resetSize();
        }
    }

    private void resetSize() {
        this.sizeInBytes = -1L;
        this.retainedSizeInBytes = -1L;
    }
}

