/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.aggregation.histogram.TypedHistogram;
import io.trino.spi.block.Block;
import io.trino.spi.block.MapBlock;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;

@Description(value="Return a map containing the counts of the elements in the array")
@ScalarFunction(value="array_histogram")
public final class ArrayHistogramFunction {
    private ArrayHistogramFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="map(T, bigint)")
    public static SqlMap arrayHistogram(@TypeParameter(value="T") Type elementType, @OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.FLAT}, result=InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER)) MethodHandle readFlat, @OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FLAT_RETURN)) MethodHandle writeFlat, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.FLAT}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle hashFlat, @OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle distinctFlatBlock, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle hashBlock, @TypeParameter(value="map(T, bigint)") MapType mapType, @SqlType(value="array(T)") Block arrayBlock) {
        TypedHistogram histogram = new TypedHistogram(elementType, readFlat, writeFlat, hashFlat, distinctFlatBlock, hashBlock, false);
        int positionCount = arrayBlock.getPositionCount();
        for (int position = 0; position < positionCount; ++position) {
            if (arrayBlock.isNull(position)) continue;
            histogram.add(0, arrayBlock, position, 1L);
        }
        MapBlockBuilder blockBuilder = mapType.createBlockBuilder(null, histogram.size());
        histogram.serialize(0, blockBuilder);
        MapBlock mapBlock = (MapBlock)blockBuilder.build();
        return mapType.getObject((Block)mapBlock, 0);
    }
}

