/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.sql.SqlPathElement;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.tree.Identifier;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class SqlPath {
    public static final SqlPath EMPTY_PATH = SqlPath.buildPath("", Optional.empty());
    private final List<CatalogSchemaName> path;
    private final String rawPath;

    public static SqlPath buildPath(String rawPath, Optional<String> defaultCatalog) {
        ImmutableList.Builder path = ImmutableList.builder();
        path.add((Object)new CatalogSchemaName("system", "builtin"));
        for (SqlPathElement pathElement : SqlPath.parsePath(rawPath)) {
            pathElement.getCatalog().map(Identifier::getValue).or(() -> defaultCatalog).ifPresent(catalog -> path.add((Object)new CatalogSchemaName(catalog, pathElement.getSchema().getValue())));
        }
        return new SqlPath((List<CatalogSchemaName>)path.build(), rawPath);
    }

    @JsonCreator
    public SqlPath(@JsonProperty List<CatalogSchemaName> path, @JsonProperty String rawPath) {
        this.path = ImmutableList.copyOf(path);
        this.rawPath = Objects.requireNonNull(rawPath, "rawPath is null");
    }

    @JsonProperty
    public String getRawPath() {
        return this.rawPath;
    }

    @JsonProperty
    public List<CatalogSchemaName> getPath() {
        return this.path;
    }

    public static List<SqlPathElement> parsePath(String rawPath) {
        if (rawPath.isBlank()) {
            return ImmutableList.of();
        }
        SqlParser parser = new SqlParser();
        List pathSpecification = parser.createPathSpecification(rawPath).getPath();
        List pathElements = (List)pathSpecification.stream().map(pathElement -> new SqlPathElement(pathElement.getCatalog(), pathElement.getSchema())).collect(ImmutableList.toImmutableList());
        return pathElements;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlPath that = (SqlPath)obj;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public String toString() {
        return this.rawPath;
    }
}

