/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.Iterables;
import io.trino.execution.scheduler.faulttolerant.FaultTolerantPartitioningScheme;
import io.trino.operator.BucketPartitionFunction;
import io.trino.operator.PartitionFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.NodePartitionMap;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.SystemPartitioningHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;

public final class MergePartitioningHandle
implements ConnectorPartitioningHandle {
    private final Optional<PartitioningScheme> insertPartitioning;
    private final Optional<PartitioningScheme> updatePartitioning;

    @JsonCreator
    public MergePartitioningHandle(Optional<PartitioningScheme> insertPartitioning, Optional<PartitioningScheme> updatePartitioning) {
        this.insertPartitioning = Objects.requireNonNull(insertPartitioning, "insertPartitioning is null");
        this.updatePartitioning = Objects.requireNonNull(updatePartitioning, "updatePartitioning is null");
        Preconditions.checkArgument((insertPartitioning.isPresent() || updatePartitioning.isPresent() ? 1 : 0) != 0, (Object)"insert or update partitioning must be present");
    }

    @JsonGetter
    public Optional<PartitioningScheme> getInsertPartitioning() {
        return this.insertPartitioning;
    }

    @JsonGetter
    public Optional<PartitioningScheme> getUpdatePartitioning() {
        return this.updatePartitioning;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergePartitioningHandle that = (MergePartitioningHandle)o;
        return this.insertPartitioning.equals(that.insertPartitioning) && this.updatePartitioning.equals(that.updatePartitioning);
    }

    public int hashCode() {
        return Objects.hash(this.insertPartitioning, this.updatePartitioning);
    }

    public String toString() {
        ArrayList parts = new ArrayList();
        this.insertPartitioning.ifPresent(scheme -> parts.add("insert = " + scheme.getPartitioning().getHandle()));
        this.updatePartitioning.ifPresent(scheme -> parts.add("update = " + scheme.getPartitioning().getHandle()));
        return "MERGE " + parts;
    }

    public NodePartitionMap getNodePartitioningMap(Function<PartitioningHandle, NodePartitionMap> getMap) {
        Optional<NodePartitionMap> optionalInsertMap = this.insertPartitioning.map(scheme -> scheme.getPartitioning().getHandle()).map(getMap);
        Optional<NodePartitionMap> optionalUpdateMap = this.updatePartitioning.map(scheme -> scheme.getPartitioning().getHandle()).map(getMap);
        if (optionalInsertMap.isPresent() && optionalUpdateMap.isPresent()) {
            NodePartitionMap insertMap = optionalInsertMap.get();
            NodePartitionMap updateMap = optionalUpdateMap.get();
            if (!insertMap.getPartitionToNode().equals(updateMap.getPartitionToNode()) || !Arrays.equals(insertMap.getBucketToPartition(), updateMap.getBucketToPartition())) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Insert and update layout have mismatched BucketNodeMap");
            }
        }
        return optionalInsertMap.orElseGet(optionalUpdateMap::orElseThrow);
    }

    public FaultTolerantPartitioningScheme getFaultTolerantPartitioningScheme(Function<PartitioningHandle, FaultTolerantPartitioningScheme> getScheme) {
        Optional<FaultTolerantPartitioningScheme> optionalInsertScheme = this.insertPartitioning.map(scheme -> scheme.getPartitioning().getHandle()).map(getScheme);
        Optional<FaultTolerantPartitioningScheme> optionalUpdateScheme = this.updatePartitioning.map(scheme -> scheme.getPartitioning().getHandle()).map(getScheme);
        if (optionalInsertScheme.isPresent() && optionalUpdateScheme.isPresent()) {
            FaultTolerantPartitioningScheme insertScheme = optionalInsertScheme.get();
            FaultTolerantPartitioningScheme updateScheme = optionalUpdateScheme.get();
            if (insertScheme.getPartitionCount() != updateScheme.getPartitionCount() || !Arrays.equals((int[])insertScheme.getBucketToPartitionMap().orElse(null), (int[])updateScheme.getBucketToPartitionMap().orElse(null)) || !Objects.equals(insertScheme.getPartitionToNodeMap(), updateScheme.getPartitionToNodeMap())) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Insert and update layout have mismatched BucketNodeMap");
            }
        }
        return optionalInsertScheme.orElseGet(optionalUpdateScheme::orElseThrow);
    }

    public PartitionFunction getPartitionFunction(PartitionFunctionLookup partitionFunctionLookup, List<Type> types, int[] bucketToPartition) {
        List<Type> insertTypes = types.subList(1, types.size() - (this.updatePartitioning.isPresent() ? 1 : 0));
        Optional<PartitionFunction> insertFunction = this.insertPartitioning.map(scheme -> partitionFunctionLookup.get((PartitioningScheme)scheme, insertTypes));
        Optional<PartitionFunction> updateFunction = this.updatePartitioning.map(scheme -> partitionFunctionLookup.get((PartitioningScheme)scheme, List.of((Type)Iterables.getLast((Iterable)types))));
        return MergePartitioningHandle.getPartitionFunction(insertFunction, updateFunction, insertTypes.size(), bucketToPartition);
    }

    private static PartitionFunction getPartitionFunction(Optional<PartitionFunction> insertFunction, Optional<PartitionFunction> updateFunction, int insertArguments, int[] bucketToPartition) {
        if (insertFunction.isPresent() && updateFunction.isPresent()) {
            return new MergePartitionFunction(insertFunction.get(), updateFunction.get(), IntStream.range(1, insertArguments + 1).toArray(), new int[]{insertArguments + 1});
        }
        BucketPartitionFunction roundRobinFunction = new BucketPartitionFunction(new SystemPartitioningHandle.SystemPartitionFunction.RoundRobinBucketFunction(bucketToPartition.length), bucketToPartition);
        if (insertFunction.isPresent()) {
            return new MergePartitionFunction(insertFunction.get(), roundRobinFunction, IntStream.range(1, insertArguments + 1).toArray(), new int[0]);
        }
        if (updateFunction.isPresent()) {
            return new MergePartitionFunction(roundRobinFunction, updateFunction.get(), new int[0], new int[]{insertArguments + 1});
        }
        throw new AssertionError();
    }

    public static interface PartitionFunctionLookup {
        public PartitionFunction get(PartitioningScheme var1, List<Type> var2);
    }

    private static final class MergePartitionFunction
    implements PartitionFunction {
        private final PartitionFunction insertFunction;
        private final PartitionFunction updateFunction;
        private final int[] insertColumns;
        private final int[] updateColumns;

        public MergePartitionFunction(PartitionFunction insertFunction, PartitionFunction updateFunction, int[] insertColumns, int[] updateColumns) {
            this.insertFunction = Objects.requireNonNull(insertFunction, "insertFunction is null");
            this.updateFunction = Objects.requireNonNull(updateFunction, "updateFunction is null");
            this.insertColumns = Objects.requireNonNull(insertColumns, "insertColumns is null");
            this.updateColumns = Objects.requireNonNull(updateColumns, "updateColumns is null");
            Preconditions.checkArgument((insertFunction.getPartitionCount() == updateFunction.getPartitionCount() ? 1 : 0) != 0, (Object)"partition counts must match");
        }

        @Override
        public int getPartitionCount() {
            return this.insertFunction.getPartitionCount();
        }

        @Override
        public int getPartition(Page page, int position) {
            Block operationBlock = page.getBlock(0);
            byte operation = TinyintType.TINYINT.getByte(operationBlock, position);
            return switch (operation) {
                case 1, 4 -> this.insertFunction.getPartition(page.getColumns(this.insertColumns), position);
                case 2, 3, 5 -> this.updateFunction.getPartition(page.getColumns(this.updateColumns), position);
                default -> throw new VerifyException("Invalid merge operation number: " + operation);
            };
        }
    }
}

