/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import io.trino.metadata.ResolvedFunction;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ResolvedFunctionCallBuilder {
    private final ResolvedFunction resolvedFunction;
    private List<Expression> argumentValues = new ArrayList<Expression>();
    private Optional<NodeLocation> location = Optional.empty();
    private Optional<Window> window = Optional.empty();
    private Optional<Expression> filter = Optional.empty();
    private Optional<OrderBy> orderBy = Optional.empty();
    private boolean distinct;

    public static ResolvedFunctionCallBuilder builder(ResolvedFunction resolvedFunction) {
        return new ResolvedFunctionCallBuilder(resolvedFunction);
    }

    private ResolvedFunctionCallBuilder(ResolvedFunction resolvedFunction) {
        this.resolvedFunction = Objects.requireNonNull(resolvedFunction, "resolvedFunction is null");
    }

    public ResolvedFunctionCallBuilder addArgument(Expression value) {
        Objects.requireNonNull(value, "value is null");
        this.argumentValues.add(value);
        return this;
    }

    public ResolvedFunctionCallBuilder setArguments(List<Expression> values) {
        Objects.requireNonNull(values, "values is null");
        this.argumentValues = new ArrayList<Expression>(values);
        return this;
    }

    public ResolvedFunctionCallBuilder setLocation(NodeLocation location) {
        this.location = Optional.of(Objects.requireNonNull(location, "location is null"));
        return this;
    }

    public ResolvedFunctionCallBuilder setWindow(Window window) {
        this.window = Optional.of(Objects.requireNonNull(window, "window is null"));
        return this;
    }

    public ResolvedFunctionCallBuilder setWindow(Optional<Window> window) {
        this.window = Objects.requireNonNull(window, "window is null");
        return this;
    }

    public ResolvedFunctionCallBuilder setFilter(Expression filter) {
        this.filter = Optional.of(Objects.requireNonNull(filter, "filter is null"));
        return this;
    }

    public ResolvedFunctionCallBuilder setFilter(Optional<Expression> filter) {
        this.filter = Objects.requireNonNull(filter, "filter is null");
        return this;
    }

    public ResolvedFunctionCallBuilder setOrderBy(OrderBy orderBy) {
        this.orderBy = Optional.of(Objects.requireNonNull(orderBy, "orderBy is null"));
        return this;
    }

    public ResolvedFunctionCallBuilder setOrderBy(Optional<OrderBy> orderBy) {
        this.orderBy = Objects.requireNonNull(orderBy, "orderBy is null");
        return this;
    }

    public ResolvedFunctionCallBuilder setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public FunctionCall build() {
        return new FunctionCall(this.location, this.resolvedFunction.toQualifiedName(), this.window, this.filter, this.orderBy, this.distinct, Optional.empty(), Optional.empty(), this.argumentValues);
    }
}

