/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.DomainTranslator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class PushdownFilterIntoWindow
implements Rule<FilterNode> {
    private static final Capture<WindowNode> childCapture = Capture.newCapture();
    private final Pattern<FilterNode> pattern;
    private final PlannerContext plannerContext;

    public PushdownFilterIntoWindow(PlannerContext plannerContext) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.pattern = Patterns.filter().with(Patterns.source().matching(Patterns.window().matching(window -> window.getOrderingScheme().isPresent()).matching(window -> Util.toTopNRankingType(window).isPresent()).capturedAs(childCapture)));
    }

    @Override
    public Pattern<FilterNode> getPattern() {
        return this.pattern;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isOptimizeTopNRanking(session);
    }

    @Override
    public Rule.Result apply(FilterNode node, Captures captures, Rule.Context context) {
        Session session = context.getSession();
        TypeProvider types = context.getSymbolAllocator().getTypes();
        WindowNode windowNode = (WindowNode)captures.get(childCapture);
        DomainTranslator.ExtractionResult extractionResult = DomainTranslator.getExtractionResult(this.plannerContext, session, node.getPredicate(), types);
        TupleDomain<Symbol> tupleDomain = extractionResult.getTupleDomain();
        Optional<TopNRankingNode.RankingType> rankingType = Util.toTopNRankingType(windowNode);
        Symbol rankingSymbol = (Symbol)Iterables.getOnlyElement(windowNode.getWindowFunctions().keySet());
        OptionalInt upperBound = PushdownFilterIntoWindow.extractUpperBound(tupleDomain, rankingSymbol);
        if (upperBound.isEmpty()) {
            return Rule.Result.empty();
        }
        if (upperBound.getAsInt() <= 0) {
            return Rule.Result.ofPlanNode(new ValuesNode(node.getId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
        }
        TopNRankingNode newSource = new TopNRankingNode(windowNode.getId(), windowNode.getSource(), windowNode.getSpecification(), rankingType.get(), rankingSymbol, upperBound.getAsInt(), false, Optional.empty());
        if (!PushdownFilterIntoWindow.allRowNumberValuesInDomain(tupleDomain, rankingSymbol, upperBound.getAsInt())) {
            return Rule.Result.ofPlanNode(new FilterNode(node.getId(), newSource, node.getPredicate()));
        }
        TupleDomain newTupleDomain = tupleDomain.filter((symbol, domain) -> !symbol.equals(rankingSymbol));
        Expression newPredicate = ExpressionUtils.combineConjuncts(this.plannerContext.getMetadata(), extractionResult.getRemainingExpression(), new DomainTranslator(this.plannerContext).toPredicate((TupleDomain<Symbol>)newTupleDomain));
        if (newPredicate.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
            return Rule.Result.ofPlanNode(newSource);
        }
        return Rule.Result.ofPlanNode(new FilterNode(node.getId(), newSource, newPredicate));
    }

    private static boolean allRowNumberValuesInDomain(TupleDomain<Symbol> tupleDomain, Symbol symbol, long upperBound) {
        if (tupleDomain.isNone()) {
            return false;
        }
        Domain domain = (Domain)((Map)tupleDomain.getDomains().get()).get(symbol);
        if (domain == null) {
            return true;
        }
        return domain.getValues().contains(ValueSet.ofRanges((Range)Range.range((Type)domain.getType(), (Object)1L, (boolean)true, (Object)upperBound, (boolean)true), (Range[])new Range[0]));
    }

    private static OptionalInt extractUpperBound(TupleDomain<Symbol> tupleDomain, Symbol symbol) {
        if (tupleDomain.isNone()) {
            return OptionalInt.empty();
        }
        Domain rowNumberDomain = (Domain)((Map)tupleDomain.getDomains().get()).get(symbol);
        if (rowNumberDomain == null) {
            return OptionalInt.empty();
        }
        ValueSet values = rowNumberDomain.getValues();
        if (values.isAll() || values.isNone() || values.getRanges().getRangeCount() <= 0) {
            return OptionalInt.empty();
        }
        Range span = values.getRanges().getSpan();
        if (span.isHighUnbounded()) {
            return OptionalInt.empty();
        }
        Verify.verify((boolean)rowNumberDomain.getType().equals(BigintType.BIGINT));
        long upperBound = (Long)span.getHighBoundedValue();
        if (!span.isHighInclusive()) {
            --upperBound;
        }
        if (upperBound >= Integer.MIN_VALUE && upperBound <= Integer.MAX_VALUE) {
            return OptionalInt.of(Math.toIntExact(upperBound));
        }
        return OptionalInt.empty();
    }
}

