/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.rewrite;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.execution.ParameterExtractor;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.sql.QueryUtil;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.QueryType;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.rewrite.StatementRewrite;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.DescribeInput;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Limit;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.StringLiteral;
import io.trino.type.TypeUtils;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class DescribeInputRewrite
implements StatementRewrite.Rewrite {
    private final SqlParser parser;

    @Inject
    public DescribeInputRewrite(SqlParser parser) {
        this.parser = Objects.requireNonNull(parser, "parser is null");
    }

    @Override
    public Statement rewrite(AnalyzerFactory analyzerFactory, Session session, Statement node, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        return (Statement)new Visitor(session, this.parser, analyzerFactory, parameters, parameterLookup, warningCollector, planOptimizersStatsCollector).process((Node)node, null);
    }

    private static final class Visitor
    extends AstVisitor<Node, Void> {
        private final Session session;
        private final SqlParser parser;
        private final AnalyzerFactory analyzerFactory;
        private final List<Expression> parameters;
        private final Map<NodeRef<Parameter>, Expression> parameterLookup;
        private final WarningCollector warningCollector;
        private final PlanOptimizersStatsCollector planOptimizersStatsCollector;

        public Visitor(Session session, SqlParser parser, AnalyzerFactory analyzerFactory, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.parser = Objects.requireNonNull(parser, "parser is null");
            this.analyzerFactory = Objects.requireNonNull(analyzerFactory, "analyzerFactory is null");
            this.parameters = parameters;
            this.parameterLookup = parameterLookup;
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
            this.planOptimizersStatsCollector = Objects.requireNonNull(planOptimizersStatsCollector, "planOptimizersStatsCollector is null");
        }

        protected Node visitDescribeInput(DescribeInput node, Void context) {
            String sqlString = this.session.getPreparedStatement(node.getName().getValue());
            Statement statement = this.parser.createStatement(sqlString);
            Analyzer analyzer = this.analyzerFactory.createAnalyzer(this.session, this.parameters, this.parameterLookup, this.warningCollector, this.planOptimizersStatsCollector);
            Analysis analysis = analyzer.analyze(statement, QueryType.DESCRIBE);
            List<Parameter> parameters = ParameterExtractor.extractParameters(statement);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < parameters.size(); ++i) {
                builder.add((Object)Visitor.createDescribeInputRow(this.session, i, parameters.get(i), analysis));
            }
            Row[] rows = (Row[])builder.build().toArray(Row[]::new);
            Optional<Object> limit = Optional.empty();
            if (rows.length == 0) {
                rows = new Row[]{QueryUtil.row((Expression[])new Expression[]{new NullLiteral(), new NullLiteral()})};
                limit = Optional.of(new Limit((Expression)new LongLiteral("0")));
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{QueryUtil.identifier((String)"Position"), QueryUtil.identifier((String)"Type")}), (Relation)QueryUtil.aliased((Relation)QueryUtil.values((Row[])rows), (String)"Parameter Input", (List)ImmutableList.of((Object)"Position", (Object)"Type")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"Position")})), Optional.empty(), limit);
        }

        private static Row createDescribeInputRow(Session session, int position, Parameter parameter, Analysis queryAnalysis) {
            Object type = queryAnalysis.getCoercion((Expression)parameter);
            if (type == null) {
                type = UnknownType.UNKNOWN;
            }
            return QueryUtil.row((Expression[])new Expression[]{new LongLiteral(Integer.toString(position)), new StringLiteral(TypeUtils.getDisplayLabel(type, SystemSessionProperties.isOmitDateTimeTypePrecision(session)))});
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }
    }
}

