/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.json.JsonInputErrorNode;
import io.trino.operator.scalar.json.JsonInputConversionError;
import io.trino.operator.scalar.json.JsonOutputConversionError;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.AbstractVariableWidthType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;

public class Json2016Type
extends AbstractVariableWidthType {
    public static final Json2016Type JSON_2016 = new Json2016Type();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public Json2016Type() {
        super(new TypeSignature("json2016", new TypeSignatureParameter[0]), JsonNode.class);
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        return this.getObject(block, position);
    }

    public Object getObject(Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        String json = block.getSlice(position, 0, block.getSliceLength(position)).toStringUtf8();
        if (json.equals(JsonInputErrorNode.JSON_ERROR.toString())) {
            return JsonInputErrorNode.JSON_ERROR;
        }
        try {
            return MAPPER.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw new JsonInputConversionError(e);
        }
    }

    public void writeObject(BlockBuilder blockBuilder, Object value) {
        String json;
        if (value == JsonInputErrorNode.JSON_ERROR) {
            json = JsonInputErrorNode.JSON_ERROR.toString();
        } else {
            try {
                json = MAPPER.writeValueAsString(value);
            }
            catch (JsonProcessingException e) {
                throw new JsonOutputConversionError(e);
            }
        }
        Slice bytes = Slices.utf8Slice((String)json);
        ((VariableWidthBlockBuilder)blockBuilder).writeEntry(bytes);
    }
}

