/*
 * Decompiled with CFR 0.152.
 */
package io.trino;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import io.trino.util.StructuralTestUtil;
import java.util.List;
import java.util.Objects;

public class RowPageBuilder {
    private final List<Type> types;
    private final List<BlockBuilder> builders;
    private long rowCount;

    public static RowPageBuilder rowPageBuilder(Type ... types) {
        return RowPageBuilder.rowPageBuilder((Iterable<Type>)ImmutableList.copyOf((Object[])types));
    }

    public static RowPageBuilder rowPageBuilder(Iterable<Type> types) {
        return new RowPageBuilder(types);
    }

    RowPageBuilder(Iterable<Type> types) {
        this.types = ImmutableList.copyOf(Objects.requireNonNull(types, "types is null"));
        ImmutableList.Builder builders = ImmutableList.builderWithExpectedSize((int)this.types.size());
        for (Type type : types) {
            builders.add((Object)type.createBlockBuilder(null, 1));
        }
        this.builders = builders.build();
        Preconditions.checkArgument((!this.builders.isEmpty() ? 1 : 0) != 0, (Object)"At least one value info is required");
    }

    public boolean isEmpty() {
        return this.rowCount == 0L;
    }

    public RowPageBuilder row(Object ... values) {
        Preconditions.checkArgument((values.length == this.builders.size() ? 1 : 0) != 0, (String)"Expected %s values, but got %s", (int)this.builders.size(), (int)values.length);
        for (int channel = 0; channel < values.length; ++channel) {
            this.append(channel, values[channel]);
        }
        ++this.rowCount;
        return this;
    }

    public Page build() {
        Block[] blocks = new Block[this.builders.size()];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.builders.get(i).build();
        }
        return new Page(blocks);
    }

    private void append(int channel, Object element) {
        BlockBuilder blockBuilder = this.builders.get(channel);
        Type type = this.types.get(channel);
        StructuralTestUtil.appendToBlockBuilder(type, element, blockBuilder);
    }
}

