/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingConnectorSession;
import io.trino.type.ColorType;
import io.trino.type.IpAddressType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.testng.Assert;

public final class BlockAssertions {
    private static final int ENTRY_SIZE = 4;
    private static final int MAX_STRING_SIZE = 50;
    private static final int RANDOM_SEED = 633969769;

    private BlockAssertions() {
    }

    public static Object getOnlyValue(Type type, Block block) {
        Assert.assertEquals((int)block.getPositionCount(), (int)1, (String)"Block positions");
        return type.getObjectValue(TestingConnectorSession.SESSION, block, 0);
    }

    public static List<Object> toValues(Type type, Iterable<Block> blocks) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Block block : blocks) {
            for (int position = 0; position < block.getPositionCount(); ++position) {
                values.add(type.getObjectValue(TestingConnectorSession.SESSION, block, position));
            }
        }
        return Collections.unmodifiableList(values);
    }

    public static List<Object> toValues(Type type, Block block) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            values.add(type.getObjectValue(TestingConnectorSession.SESSION, block, position));
        }
        return Collections.unmodifiableList(values);
    }

    public static void assertBlockEquals(Type type, Block actual, Block expected) {
        Assert.assertEquals((int)actual.getPositionCount(), (int)expected.getPositionCount());
        for (int position = 0; position < actual.getPositionCount(); ++position) {
            Assert.assertEquals((Object)type.getObjectValue(TestingConnectorSession.SESSION, actual, position), (Object)type.getObjectValue(TestingConnectorSession.SESSION, expected, position), (String)("position " + position));
        }
    }

    public static Block createRandomDictionaryBlock(Block dictionary, int positionCount) {
        Preconditions.checkArgument((dictionary.getPositionCount() > 0 ? 1 : 0) != 0, (String)"dictionary position count %s is less than or equal to 0", (int)dictionary.getPositionCount());
        Random random = BlockAssertions.random();
        int[] ids = IntStream.range(0, positionCount).map(i -> random.nextInt(dictionary.getPositionCount())).toArray();
        return DictionaryBlock.create((int)positionCount, (Block)dictionary, (int[])ids);
    }

    public static RunLengthEncodedBlock createRandomRleBlock(Block block, int positionCount) {
        Preconditions.checkArgument((block.getPositionCount() >= 2 ? 1 : 0) != 0, (Object)String.format("block positions %d is less 2", block.getPositionCount()));
        return (RunLengthEncodedBlock)RunLengthEncodedBlock.create((Block)block.getSingleValueBlock(BlockAssertions.random().nextInt(block.getPositionCount())), (int)positionCount);
    }

    public static ValueBlock createRandomBlockForType(Type type, int positionCount, float nullRate) {
        BlockAssertions.verifyNullRate(nullRate);
        if (type == BooleanType.BOOLEAN) {
            return BlockAssertions.createRandomBooleansBlock(positionCount, nullRate);
        }
        if (type == BigintType.BIGINT) {
            return BlockAssertions.createRandomLongsBlock(positionCount, nullRate);
        }
        if (type == IntegerType.INTEGER || type == RealType.REAL) {
            return BlockAssertions.createRandomIntsBlock(positionCount, nullRate);
        }
        if (type == SmallintType.SMALLINT) {
            return BlockAssertions.createRandomSmallintsBlock(positionCount, nullRate);
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.isShort()) {
                return BlockAssertions.createRandomLongsBlock(positionCount, nullRate);
            }
            return BlockAssertions.createRandomLongDecimalsBlock(positionCount, nullRate);
        }
        if (type == VarcharType.VARCHAR) {
            return BlockAssertions.createRandomStringBlock(positionCount, nullRate, 50);
        }
        if (type instanceof CharType) {
            return BlockAssertions.createRandomCharsBlock((CharType)type, positionCount, nullRate);
        }
        if (type == DoubleType.DOUBLE) {
            return BlockAssertions.createRandomDoublesBlock(positionCount, nullRate);
        }
        if (type == TinyintType.TINYINT) {
            return BlockAssertions.createRandomTinyintsBlock(positionCount, nullRate);
        }
        if (type == UuidType.UUID) {
            return BlockAssertions.createRandomUUIDsBlock(positionCount, nullRate);
        }
        if (type == IpAddressType.IPADDRESS) {
            return BlockAssertions.createRandomIpAddressesBlock(positionCount, nullRate);
        }
        if (type == VarbinaryType.VARBINARY) {
            return BlockAssertions.createRandomVarbinariesBlock(positionCount, nullRate);
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            if (timestampType.isShort()) {
                return BlockAssertions.createRandomShortTimestampBlock(timestampType, positionCount, nullRate);
            }
            return BlockAssertions.createRandomLongTimestampBlock(timestampType, positionCount, nullRate);
        }
        return BlockAssertions.createRandomBlockForNestedType(type, positionCount, nullRate);
    }

    public static ValueBlock createRandomBlockForNestedType(Type type, int positionCount, float nullRate) {
        return BlockAssertions.createRandomBlockForNestedType(type, positionCount, nullRate, 4);
    }

    public static ValueBlock createRandomBlockForNestedType(Type type, int positionCount, float nullRate, int maxCardinality) {
        boolean[] isNull = null;
        Set<Integer> nullPositions = null;
        if (nullRate > 0.0f) {
            isNull = new boolean[positionCount];
            nullPositions = BlockAssertions.chooseNullPositions(positionCount, nullRate);
        }
        int[] offsets = new int[positionCount + 1];
        Random random = BlockAssertions.random();
        for (int position = 0; position < positionCount; ++position) {
            if (nullRate > 0.0f && nullPositions.contains(position)) {
                isNull[position] = true;
                offsets[position + 1] = offsets[position];
                continue;
            }
            offsets[position + 1] = offsets[position] + (type instanceof RowType ? 1 : random.nextInt(maxCardinality) + 1);
        }
        if (type instanceof ArrayType) {
            ValueBlock valuesBlock = BlockAssertions.createRandomBlockForType(((ArrayType)type).getElementType(), offsets[positionCount], nullRate);
            return ArrayBlock.fromElementBlock((int)positionCount, Optional.ofNullable(isNull), (int[])offsets, (Block)valuesBlock);
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            ValueBlock keyBlock = BlockAssertions.createRandomBlockForType(mapType.getKeyType(), offsets[positionCount], 0.0f);
            ValueBlock valueBlock = BlockAssertions.createRandomBlockForType(mapType.getValueType(), offsets[positionCount], nullRate);
            return mapType.createBlockFromKeyValue(Optional.ofNullable(isNull), offsets, (Block)keyBlock, (Block)valueBlock);
        }
        if (type instanceof RowType) {
            List fieldTypes = type.getTypeParameters();
            Block[] fieldBlocks = new Block[fieldTypes.size()];
            for (int i = 0; i < fieldBlocks.length; ++i) {
                fieldBlocks[i] = BlockAssertions.createRandomBlockForType((Type)fieldTypes.get(i), positionCount, nullRate);
            }
            return RowBlock.fromFieldBlocks((int)positionCount, Optional.ofNullable(isNull), (Block[])fieldBlocks);
        }
        throw new IllegalArgumentException(String.format("type %s is not supported.", type));
    }

    public static ValueBlock createRandomBooleansBlock(int positionCount, float nullRate) {
        Random random = BlockAssertions.random();
        return BlockAssertions.createBooleansBlock(BlockAssertions.generateListWithNulls(positionCount, nullRate, random::nextBoolean));
    }

    public static ValueBlock createRandomIntsBlock(int positionCount, float nullRate) {
        Random random = BlockAssertions.random();
        return BlockAssertions.createIntsBlock(BlockAssertions.generateListWithNulls(positionCount, nullRate, random::nextInt));
    }

    public static ValueBlock createRandomLongDecimalsBlock(int positionCount, float nullRate) {
        Random random = BlockAssertions.random();
        return BlockAssertions.createLongDecimalsBlock(BlockAssertions.generateListWithNulls(positionCount, nullRate, () -> String.valueOf(random.nextLong())));
    }

    public static ValueBlock createRandomShortTimestampBlock(TimestampType type, int positionCount, float nullRate) {
        Random random = BlockAssertions.random();
        return BlockAssertions.createLongsBlock(BlockAssertions.generateListWithNulls(positionCount, nullRate, () -> SqlTimestamp.fromMillis((int)type.getPrecision(), (long)random.nextLong()).getEpochMicros()));
    }

    public static ValueBlock createRandomLongTimestampBlock(TimestampType type, int positionCount, float nullRate) {
        Random random = BlockAssertions.random();
        return BlockAssertions.createLongTimestampBlock(type, BlockAssertions.generateListWithNulls(positionCount, nullRate, () -> {
            SqlTimestamp sqlTimestamp = SqlTimestamp.fromMillis((int)type.getPrecision(), (long)random.nextLong());
            return new LongTimestamp(sqlTimestamp.getEpochMicros(), sqlTimestamp.getPicosOfMicros());
        }));
    }

    public static ValueBlock createRandomLongsBlock(int positionCount, int numberOfUniqueValues) {
        Preconditions.checkArgument((positionCount >= numberOfUniqueValues ? 1 : 0) != 0, (String)"numberOfUniqueValues must be between 1 and positionCount: %s but was %s", (int)positionCount, (int)numberOfUniqueValues);
        int[] uniqueValues = BlockAssertions.chooseRandomUnique(positionCount, numberOfUniqueValues).stream().mapToInt(Integer::intValue).toArray();
        Random random = BlockAssertions.random();
        return BlockAssertions.createLongsBlock((Iterable)IntStream.range(0, positionCount).mapToLong(position -> uniqueValues[random.nextInt(numberOfUniqueValues)]).boxed().collect(ImmutableList.toImmutableList()));
    }

    public static ValueBlock createRandomLongsBlock(int positionCount, float nullRate) {
        Random random = BlockAssertions.random();
        return BlockAssertions.createLongsBlock(BlockAssertions.generateListWithNulls(positionCount, nullRate, random::nextLong));
    }

    public static ValueBlock createRandomSmallintsBlock(int positionCount, float nullRate) {
        Random random = BlockAssertions.random();
        return BlockAssertions.createTypedLongsBlock((Type)SmallintType.SMALLINT, BlockAssertions.generateListWithNulls(positionCount, nullRate, () -> (short)random.nextLong()));
    }

    public static ValueBlock createRandomStringBlock(int positionCount, float nullRate, int maxStringLength) {
        return BlockAssertions.createStringsBlock(BlockAssertions.generateListWithNulls(positionCount, nullRate, () -> BlockAssertions.generateRandomStringWithLength(maxStringLength)));
    }

    private static ValueBlock createRandomVarbinariesBlock(int positionCount, float nullRate) {
        Random random = BlockAssertions.random();
        return BlockAssertions.createSlicesBlock((Type)VarbinaryType.VARBINARY, BlockAssertions.generateListWithNulls(positionCount, nullRate, () -> Slices.random((int)16, (Random)random)));
    }

    private static ValueBlock createRandomUUIDsBlock(int positionCount, float nullRate) {
        Random random = BlockAssertions.random();
        return BlockAssertions.createSlicesBlock((Type)UuidType.UUID, BlockAssertions.generateListWithNulls(positionCount, nullRate, () -> Slices.random((int)16, (Random)random)));
    }

    private static ValueBlock createRandomIpAddressesBlock(int positionCount, float nullRate) {
        Random random = BlockAssertions.random();
        return BlockAssertions.createSlicesBlock((Type)IpAddressType.IPADDRESS, BlockAssertions.generateListWithNulls(positionCount, nullRate, () -> Slices.random((int)16, (Random)random)));
    }

    private static ValueBlock createRandomTinyintsBlock(int positionCount, float nullRate) {
        Random random = BlockAssertions.random();
        return BlockAssertions.createTypedLongsBlock((Type)TinyintType.TINYINT, BlockAssertions.generateListWithNulls(positionCount, nullRate, () -> (byte)random.nextLong()));
    }

    public static ValueBlock createRandomDoublesBlock(int positionCount, float nullRate) {
        Random random = BlockAssertions.random();
        return BlockAssertions.createDoublesBlock(BlockAssertions.generateListWithNulls(positionCount, nullRate, random::nextDouble));
    }

    public static ValueBlock createRandomCharsBlock(CharType charType, int positionCount, float nullRate) {
        return BlockAssertions.createCharsBlock(charType, BlockAssertions.generateListWithNulls(positionCount, nullRate, () -> BlockAssertions.generateRandomStringWithLength(charType.getLength())));
    }

    public static <T> List<T> generateListWithNulls(int positionCount, float nullRate, Supplier<T> valueSupplier) {
        ArrayList<Object> result = new ArrayList<Object>(positionCount);
        Set<Integer> nullPositions = BlockAssertions.chooseNullPositions(positionCount, nullRate);
        for (int i = 0; i < positionCount; ++i) {
            result.add(nullPositions.contains(i) ? null : (Object)valueSupplier.get());
        }
        return Collections.unmodifiableList(result);
    }

    public static Set<Integer> chooseNullPositions(int positionCount, float nullRate) {
        int nullCount = (int)((float)positionCount * nullRate);
        if (nullCount == 0) {
            Verify.verify((nullRate == 0.0f || positionCount == 0 ? 1 : 0) != 0, (String)"position count %s too small to have at least one null with rate %s", (Object)positionCount, (Object)Float.valueOf(nullRate));
            return ImmutableSet.of();
        }
        return BlockAssertions.chooseRandomUnique(positionCount, nullCount);
    }

    public static ValueBlock createStringsBlock(String ... values) {
        Objects.requireNonNull(values, "values is null");
        return BlockAssertions.createStringsBlock(Arrays.asList(values));
    }

    public static ValueBlock createStringsBlock(Iterable<String> values) {
        VariableWidthBlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, 100);
        for (String value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            VarcharType.VARCHAR.writeString((BlockBuilder)builder, value);
        }
        return builder.buildValueBlock();
    }

    public static ValueBlock createSlicesBlock(Slice ... values) {
        Objects.requireNonNull(values, "values is null");
        return BlockAssertions.createSlicesBlock(Arrays.asList(values));
    }

    public static ValueBlock createSlicesBlock(Iterable<Slice> values) {
        return BlockAssertions.createSlicesBlock((Type)VarbinaryType.VARBINARY, values);
    }

    public static ValueBlock createSlicesBlock(Type type, Iterable<Slice> values) {
        return BlockAssertions.createBlock(type, (arg_0, arg_1) -> ((Type)type).writeSlice(arg_0, arg_1), values);
    }

    public static ValueBlock createStringSequenceBlock(int start, int end) {
        VariableWidthBlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, 100);
        for (int i = start; i < end; ++i) {
            VarcharType.VARCHAR.writeString((BlockBuilder)builder, String.valueOf(i));
        }
        return builder.buildValueBlock();
    }

    public static Block createStringDictionaryBlock(int start, int length) {
        Preconditions.checkArgument((length > 5 ? 1 : 0) != 0, (Object)"block must have more than 5 entries");
        int dictionarySize = length / 5;
        VariableWidthBlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, dictionarySize);
        for (int i = start; i < start + dictionarySize; ++i) {
            VarcharType.VARCHAR.writeString((BlockBuilder)builder, String.valueOf(i));
        }
        int[] ids = new int[length];
        for (int i = 0; i < length; ++i) {
            ids[i] = i % dictionarySize;
        }
        return DictionaryBlock.create((int)ids.length, (Block)builder.build(), (int[])ids);
    }

    public static ValueBlock createStringArraysBlock(Iterable<? extends Iterable<String>> values) {
        ArrayType arrayType = new ArrayType((Type)VarcharType.VARCHAR);
        ArrayBlockBuilder builder = arrayType.createBlockBuilder(null, 100);
        for (Iterable<String> iterable : values) {
            if (iterable == null) {
                builder.appendNull();
                continue;
            }
            arrayType.writeObject((BlockBuilder)builder, (Object)BlockAssertions.createStringsBlock(iterable));
        }
        return builder.buildValueBlock();
    }

    public static ValueBlock createBooleansBlock(Boolean ... values) {
        Objects.requireNonNull(values, "values is null");
        return BlockAssertions.createBooleansBlock(Arrays.asList(values));
    }

    public static ValueBlock createBooleansBlock(Boolean value, int count) {
        return BlockAssertions.createBooleansBlock(Collections.nCopies(count, value));
    }

    public static ValueBlock createBooleansBlock(Iterable<Boolean> values) {
        BlockBuilder builder = BooleanType.BOOLEAN.createBlockBuilder(null, 100);
        for (Boolean value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            BooleanType.BOOLEAN.writeBoolean(builder, value.booleanValue());
        }
        return builder.buildValueBlock();
    }

    public static ValueBlock createShortDecimalsBlock(String ... values) {
        Objects.requireNonNull(values, "values is null");
        return BlockAssertions.createShortDecimalsBlock(Arrays.asList(values));
    }

    public static ValueBlock createShortDecimalsBlock(Iterable<String> values) {
        DecimalType shortDecimalType = DecimalType.createDecimalType((int)1);
        BlockBuilder builder = shortDecimalType.createBlockBuilder(null, 100);
        for (String value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            shortDecimalType.writeLong(builder, new BigDecimal(value).unscaledValue().longValue());
        }
        return builder.buildValueBlock();
    }

    public static ValueBlock createLongDecimalsBlock(String ... values) {
        Objects.requireNonNull(values, "values is null");
        return BlockAssertions.createLongDecimalsBlock(Arrays.asList(values));
    }

    public static ValueBlock createLongDecimalsBlock(Iterable<String> values) {
        DecimalType longDecimalType = DecimalType.createDecimalType((int)19);
        BlockBuilder builder = longDecimalType.createBlockBuilder(null, 100);
        for (String value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            Decimals.writeBigDecimal((DecimalType)longDecimalType, (BlockBuilder)builder, (BigDecimal)new BigDecimal(value));
        }
        return builder.buildValueBlock();
    }

    public static ValueBlock createLongTimestampBlock(TimestampType type, LongTimestamp ... values) {
        Objects.requireNonNull(values, "values is null");
        return BlockAssertions.createLongTimestampBlock(type, Arrays.asList(values));
    }

    public static ValueBlock createLongTimestampBlock(TimestampType type, Iterable<LongTimestamp> values) {
        BlockBuilder builder = type.createBlockBuilder(null, 100);
        for (LongTimestamp value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            type.writeObject(builder, (Object)value);
        }
        return builder.buildValueBlock();
    }

    public static ValueBlock createCharsBlock(CharType charType, List<String> values) {
        return BlockAssertions.createBlock((Type)charType, (arg_0, arg_1) -> ((CharType)charType).writeString(arg_0, arg_1), values);
    }

    public static ValueBlock createTinyintsBlock(Integer ... values) {
        Objects.requireNonNull(values, "values is null");
        return BlockAssertions.createTinyintsBlock(Arrays.asList(values));
    }

    public static ValueBlock createTinyintsBlock(Iterable<Integer> values) {
        return BlockAssertions.createBlock((Type)TinyintType.TINYINT, (arg_0, arg_1) -> ((TinyintType)TinyintType.TINYINT).writeLong(arg_0, arg_1), values);
    }

    public static ValueBlock createSmallintsBlock(Integer ... values) {
        Objects.requireNonNull(values, "values is null");
        return BlockAssertions.createSmallintsBlock(Arrays.asList(values));
    }

    public static ValueBlock createSmallintsBlock(Iterable<Integer> values) {
        return BlockAssertions.createBlock((Type)SmallintType.SMALLINT, (arg_0, arg_1) -> ((SmallintType)SmallintType.SMALLINT).writeLong(arg_0, arg_1), values);
    }

    public static ValueBlock createIntsBlock(Integer ... values) {
        Objects.requireNonNull(values, "values is null");
        return BlockAssertions.createIntsBlock(Arrays.asList(values));
    }

    public static ValueBlock createIntsBlock(Iterable<Integer> values) {
        return BlockAssertions.createBlock((Type)IntegerType.INTEGER, (arg_0, arg_1) -> ((IntegerType)IntegerType.INTEGER).writeLong(arg_0, arg_1), values);
    }

    public static ValueBlock createRowBlock(List<Type> fieldTypes, Object[] ... rows) {
        RowBlockBuilder rowBlockBuilder = new RowBlockBuilder(fieldTypes, null, 1);
        for (Object[] row : rows) {
            if (row == null) {
                rowBlockBuilder.appendNull();
                continue;
            }
            Verify.verify((row.length == fieldTypes.size() ? 1 : 0) != 0);
            rowBlockBuilder.buildEntry(fieldBuilders -> {
                for (int fieldIndex = 0; fieldIndex < fieldTypes.size(); ++fieldIndex) {
                    Type fieldType = (Type)fieldTypes.get(fieldIndex);
                    Object fieldValue = row[fieldIndex];
                    if (fieldValue == null) {
                        ((BlockBuilder)fieldBuilders.get(fieldIndex)).appendNull();
                        continue;
                    }
                    if (fieldValue instanceof String) {
                        fieldType.writeSlice((BlockBuilder)fieldBuilders.get(fieldIndex), Slices.utf8Slice((String)((String)fieldValue)));
                        continue;
                    }
                    if (fieldValue instanceof Slice) {
                        fieldType.writeSlice((BlockBuilder)fieldBuilders.get(fieldIndex), (Slice)fieldValue);
                        continue;
                    }
                    if (fieldValue instanceof Double) {
                        fieldType.writeDouble((BlockBuilder)fieldBuilders.get(fieldIndex), ((Double)fieldValue).doubleValue());
                        continue;
                    }
                    if (fieldValue instanceof Long) {
                        fieldType.writeLong((BlockBuilder)fieldBuilders.get(fieldIndex), ((Long)fieldValue).longValue());
                        continue;
                    }
                    if (fieldValue instanceof Boolean) {
                        fieldType.writeBoolean((BlockBuilder)fieldBuilders.get(fieldIndex), ((Boolean)fieldValue).booleanValue());
                        continue;
                    }
                    if (fieldValue instanceof Block) {
                        fieldType.writeObject((BlockBuilder)fieldBuilders.get(fieldIndex), fieldValue);
                        continue;
                    }
                    if (fieldValue instanceof Integer) {
                        fieldType.writeLong((BlockBuilder)fieldBuilders.get(fieldIndex), (long)((Integer)fieldValue).intValue());
                        continue;
                    }
                    throw new IllegalArgumentException();
                }
            });
        }
        return rowBlockBuilder.buildValueBlock();
    }

    public static ValueBlock createEmptyLongsBlock() {
        return BigintType.BIGINT.createFixedSizeBlockBuilder(0).buildValueBlock();
    }

    public static ValueBlock createLongsBlock(int ... values) {
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(null, 100);
        for (int value : values) {
            BigintType.BIGINT.writeLong(builder, (long)value);
        }
        return builder.buildValueBlock();
    }

    public static ValueBlock createLongsBlock(Long ... values) {
        Objects.requireNonNull(values, "values is null");
        return BlockAssertions.createLongsBlock(Arrays.asList(values));
    }

    public static ValueBlock createLongsBlock(Iterable<Long> values) {
        return BlockAssertions.createTypedLongsBlock((Type)BigintType.BIGINT, values);
    }

    public static ValueBlock createTypedLongsBlock(Type type, Iterable<Long> values) {
        return BlockAssertions.createBlock(type, (arg_0, arg_1) -> ((Type)type).writeLong(arg_0, arg_1), values);
    }

    public static ValueBlock createLongSequenceBlock(int start, int end) {
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(end - start);
        for (int i = start; i < end; ++i) {
            BigintType.BIGINT.writeLong(builder, (long)i);
        }
        return builder.buildValueBlock();
    }

    public static Block createLongDictionaryBlock(int start, int length) {
        Preconditions.checkArgument((length > 5 ? 1 : 0) != 0, (Object)"block must have more than 5 entries");
        return BlockAssertions.createLongDictionaryBlock(start, length, length / 5);
    }

    public static Block createLongDictionaryBlock(int start, int length, int dictionarySize) {
        Preconditions.checkArgument((dictionarySize > 0 ? 1 : 0) != 0, (Object)"dictionarySize must be greater than 0");
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(null, dictionarySize);
        for (int i = start; i < start + dictionarySize; ++i) {
            BigintType.BIGINT.writeLong(builder, (long)i);
        }
        int[] ids = new int[length];
        for (int i = 0; i < length; ++i) {
            ids[i] = i % dictionarySize;
        }
        return DictionaryBlock.create((int)ids.length, (Block)builder.build(), (int[])ids);
    }

    public static ValueBlock createLongRepeatBlock(int value, int length) {
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(length);
        for (int i = 0; i < length; ++i) {
            BigintType.BIGINT.writeLong(builder, (long)value);
        }
        return builder.buildValueBlock();
    }

    public static ValueBlock createDoubleRepeatBlock(double value, int length) {
        BlockBuilder builder = DoubleType.DOUBLE.createFixedSizeBlockBuilder(length);
        for (int i = 0; i < length; ++i) {
            DoubleType.DOUBLE.writeDouble(builder, value);
        }
        return builder.buildValueBlock();
    }

    public static ValueBlock createTimestampsWithTimeZoneMillisBlock(Long ... values) {
        BlockBuilder builder = TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.createFixedSizeBlockBuilder(values.length);
        Long[] longArray = values;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long value = longArray[i];
            TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.writeLong(builder, value);
        }
        return builder.buildValueBlock();
    }

    public static ValueBlock createBooleanSequenceBlock(int start, int end) {
        BlockBuilder builder = BooleanType.BOOLEAN.createFixedSizeBlockBuilder(end - start);
        for (int i = start; i < end; ++i) {
            BooleanType.BOOLEAN.writeBoolean(builder, i % 2 == 0);
        }
        return builder.buildValueBlock();
    }

    public static ValueBlock createBlockOfReals(Float ... values) {
        Objects.requireNonNull(values, "values is null");
        return BlockAssertions.createBlockOfReals(Arrays.asList(values));
    }

    public static ValueBlock createBlockOfReals(Iterable<Float> values) {
        BlockBuilder builder = RealType.REAL.createBlockBuilder(null, 100);
        for (Float value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            RealType.REAL.writeLong(builder, (long)Float.floatToRawIntBits(value.floatValue()));
        }
        return builder.buildValueBlock();
    }

    public static ValueBlock createSequenceBlockOfReal(int start, int end) {
        BlockBuilder builder = RealType.REAL.createFixedSizeBlockBuilder(end - start);
        for (int i = start; i < end; ++i) {
            RealType.REAL.writeLong(builder, (long)Float.floatToRawIntBits(i));
        }
        return builder.buildValueBlock();
    }

    public static ValueBlock createDoublesBlock(Double ... values) {
        Objects.requireNonNull(values, "values is null");
        return BlockAssertions.createDoublesBlock(Arrays.asList(values));
    }

    public static ValueBlock createDoublesBlock(Iterable<Double> values) {
        return BlockAssertions.createBlock((Type)DoubleType.DOUBLE, (arg_0, arg_1) -> ((DoubleType)DoubleType.DOUBLE).writeDouble(arg_0, arg_1), values);
    }

    public static ValueBlock createDoubleSequenceBlock(int start, int end) {
        BlockBuilder builder = DoubleType.DOUBLE.createFixedSizeBlockBuilder(end - start);
        for (int i = start; i < end; ++i) {
            DoubleType.DOUBLE.writeDouble(builder, (double)i);
        }
        return builder.buildValueBlock();
    }

    public static ValueBlock createArrayBigintBlock(Iterable<? extends Iterable<Long>> values) {
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        ArrayBlockBuilder builder = arrayType.createBlockBuilder(null, 100);
        for (Iterable<Long> iterable : values) {
            if (iterable == null) {
                builder.appendNull();
                continue;
            }
            arrayType.writeObject((BlockBuilder)builder, (Object)BlockAssertions.createLongsBlock(iterable));
        }
        return builder.buildValueBlock();
    }

    public static ValueBlock createDateSequenceBlock(int start, int end) {
        BlockBuilder builder = DateType.DATE.createFixedSizeBlockBuilder(end - start);
        for (int i = start; i < end; ++i) {
            DateType.DATE.writeLong(builder, (long)i);
        }
        return builder.buildValueBlock();
    }

    public static ValueBlock createTimestampSequenceBlock(int start, int end) {
        BlockBuilder builder = TimestampType.TIMESTAMP_MILLIS.createFixedSizeBlockBuilder(end - start);
        for (int i = start; i < end; ++i) {
            TimestampType.TIMESTAMP_MILLIS.writeLong(builder, (long)Math.multiplyExact(i, 1000));
        }
        return builder.buildValueBlock();
    }

    public static ValueBlock createShortDecimalSequenceBlock(int start, int end, DecimalType type) {
        BlockBuilder builder = type.createFixedSizeBlockBuilder(end - start);
        long base = BigInteger.TEN.pow(type.getScale()).longValue();
        for (int i = start; i < end; ++i) {
            type.writeLong(builder, base * (long)i);
        }
        return builder.buildValueBlock();
    }

    public static ValueBlock createLongDecimalSequenceBlock(int start, int end, DecimalType type) {
        BlockBuilder builder = type.createFixedSizeBlockBuilder(end - start);
        BigInteger base = BigInteger.TEN.pow(type.getScale());
        for (int i = start; i < end; ++i) {
            type.writeObject(builder, (Object)Int128.valueOf((BigInteger)BigInteger.valueOf(i).multiply(base)));
        }
        return builder.buildValueBlock();
    }

    public static ValueBlock createColorRepeatBlock(int value, int length) {
        BlockBuilder builder = ColorType.COLOR.createFixedSizeBlockBuilder(length);
        for (int i = 0; i < length; ++i) {
            ColorType.COLOR.writeLong(builder, (long)value);
        }
        return builder.buildValueBlock();
    }

    public static ValueBlock createColorSequenceBlock(int start, int end) {
        BlockBuilder builder = ColorType.COLOR.createBlockBuilder(null, end - start);
        for (int i = start; i < end; ++i) {
            ColorType.COLOR.writeLong(builder, (long)i);
        }
        return builder.buildValueBlock();
    }

    public static Block createRepeatedValuesBlock(double value, int positionCount) {
        BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, 1);
        DoubleType.DOUBLE.writeDouble(blockBuilder, value);
        return RunLengthEncodedBlock.create((Block)blockBuilder.build(), (int)positionCount);
    }

    public static Block createRepeatedValuesBlock(long value, int positionCount) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, 1);
        BigintType.BIGINT.writeLong(blockBuilder, value);
        return RunLengthEncodedBlock.create((Block)blockBuilder.build(), (int)positionCount);
    }

    private static <T> ValueBlock createBlock(Type type, ValueWriter<T> valueWriter, Iterable<T> values) {
        BlockBuilder builder = type.createBlockBuilder(null, 100);
        for (T value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            valueWriter.write(builder, value);
        }
        return builder.buildValueBlock();
    }

    private static Set<Integer> chooseRandomUnique(int bound, int count) {
        Random random = BlockAssertions.random();
        if (count < bound / 10) {
            HashSet<Integer> values = new HashSet<Integer>(count);
            while (values.size() < count) {
                values.add(random.nextInt(bound));
            }
            return ImmutableSet.copyOf(values);
        }
        List allNumbers = IntStream.range(0, bound).boxed().collect(Collectors.toList());
        Collections.shuffle(allNumbers, random);
        return (Set)allNumbers.stream().limit(count).collect(ImmutableSet.toImmutableSet());
    }

    private static String generateRandomStringWithLength(int length) {
        String symbols = "abcdefghijklmnopqrstuvwxyz";
        Random random = BlockAssertions.random();
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = symbols.charAt(random.nextInt(symbols.length()));
        }
        return new String(chars);
    }

    private static void verifyNullRate(float nullRate) {
        Verify.verify((nullRate >= 0.0f && nullRate <= 1.0f ? 1 : 0) != 0, (String)"nullRate %s is not valid", (Object)Float.valueOf(nullRate));
    }

    private static Random random() {
        return new Random(633969769L);
    }

    private static interface ValueWriter<T> {
        public void write(BlockBuilder var1, T var2);
    }
}

