/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.block.ColumnarTestUtils;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ColumnarRow;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestColumnarRow {
    private static final int POSITION_COUNT = 5;
    private static final int FIELD_COUNT = 5;
    private static final RowType ROW_TYPE = RowType.anonymous(Collections.nCopies(5, VarcharType.VARCHAR));

    @Test
    public void test() {
        Slice[][] expectedValues = new Slice[5][];
        for (int i = 0; i < 5; ++i) {
            expectedValues[i] = new Slice[5];
            for (int j = 0; j < 5; ++j) {
                if (j % 3 == 1) continue;
                expectedValues[i][j] = Slices.utf8Slice((String)String.format("%d.%d", i, j));
            }
        }
        Block block = TestColumnarRow.createBlockBuilderWithValues(expectedValues);
        TestColumnarRow.verifyBlock(block, expectedValues);
        Slice[][] expectedValuesWithNull = (Slice[][])ColumnarTestUtils.alternatingNullValues(expectedValues);
        Block blockWithNull = TestColumnarRow.createBlockBuilderWithValues(expectedValuesWithNull);
        TestColumnarRow.verifyBlock(blockWithNull, expectedValuesWithNull);
    }

    private static <T> void verifyBlock(Block block, T[] expectedValues) {
        ColumnarTestUtils.assertBlock((Type)ROW_TYPE, block, expectedValues);
        TestColumnarRow.assertColumnarRow(block, expectedValues);
        TestColumnarRow.assertDictionaryBlock(block, expectedValues);
        TestColumnarRow.assertRunLengthEncodedBlock(block, expectedValues);
        int offset = 1;
        int length = expectedValues.length - 2;
        Block blockRegion = block.getRegion(offset, length);
        T[] expectedValuesRegion = Arrays.copyOfRange(expectedValues, offset, offset + length);
        ColumnarTestUtils.assertBlock((Type)ROW_TYPE, blockRegion, expectedValuesRegion);
        TestColumnarRow.assertColumnarRow(blockRegion, expectedValuesRegion);
        TestColumnarRow.assertDictionaryBlock(blockRegion, expectedValuesRegion);
        TestColumnarRow.assertRunLengthEncodedBlock(blockRegion, expectedValuesRegion);
    }

    private static <T> void assertDictionaryBlock(Block block, T[] expectedValues) {
        Block dictionaryBlock = ColumnarTestUtils.createTestDictionaryBlock(block);
        T[] expectedDictionaryValues = ColumnarTestUtils.createTestDictionaryExpectedValues(expectedValues);
        ColumnarTestUtils.assertBlock((Type)ROW_TYPE, dictionaryBlock, expectedDictionaryValues);
        TestColumnarRow.assertColumnarRow(dictionaryBlock, expectedDictionaryValues);
        TestColumnarRow.assertRunLengthEncodedBlock(dictionaryBlock, expectedDictionaryValues);
    }

    private static <T> void assertRunLengthEncodedBlock(Block block, T[] expectedValues) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            RunLengthEncodedBlock runLengthEncodedBlock = ColumnarTestUtils.createTestRleBlock(block, position);
            T[] expectedDictionaryValues = ColumnarTestUtils.createTestRleExpectedValues(expectedValues, position);
            ColumnarTestUtils.assertBlock((Type)ROW_TYPE, (Block)runLengthEncodedBlock, expectedDictionaryValues);
            TestColumnarRow.assertColumnarRow((Block)runLengthEncodedBlock, expectedDictionaryValues);
        }
    }

    private static <T> void assertColumnarRow(Block block, T[] expectedValues) {
        ColumnarRow columnarRow = ColumnarRow.toColumnarRow((Block)block);
        Assert.assertEquals((int)columnarRow.getPositionCount(), (int)expectedValues.length);
        for (int fieldId = 0; fieldId < 5; ++fieldId) {
            Block fieldBlock = columnarRow.getField(fieldId);
            int elementsPosition = 0;
            for (int position = 0; position < expectedValues.length; ++position) {
                T expectedRow = expectedValues[position];
                Assert.assertEquals((boolean)columnarRow.isNull(position), (expectedRow == null ? 1 : 0) != 0);
                if (expectedRow == null) continue;
                Object expectedElement = Array.get(expectedRow, fieldId);
                ColumnarTestUtils.assertBlockPosition((Type)ROW_TYPE, fieldBlock, elementsPosition, expectedElement);
                ++elementsPosition;
            }
        }
    }

    public static Block createBlockBuilderWithValues(Slice[][] expectedValues) {
        RowBlockBuilder blockBuilder = ROW_TYPE.createBlockBuilder(null, 100);
        for (Slice[] expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.buildEntry(fieldBuilders -> {
                for (int i = 0; i < expectedValue.length; ++i) {
                    Slice v = expectedValue[i];
                    if (v == null) {
                        ((BlockBuilder)fieldBuilders.get(i)).appendNull();
                        continue;
                    }
                    VarcharType.VARCHAR.writeSlice((BlockBuilder)fieldBuilders.get(i), v);
                }
            });
        }
        return blockBuilder.build();
    }
}

