/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.trino.Session;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogServiceProvider;
import io.trino.connector.MockConnectorFactory;
import io.trino.eventlistener.EventListenerManager;
import io.trino.execution.CreateMaterializedViewTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.AbstractMockMetadata;
import io.trino.metadata.AnalyzePropertyManager;
import io.trino.metadata.MaterializedViewDefinition;
import io.trino.metadata.MaterializedViewPropertyManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableMetadata;
import io.trino.metadata.TablePropertyManager;
import io.trino.metadata.TableSchema;
import io.trino.metadata.ViewDefinition;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TestingColumnHandle;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.QueryUtil;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.StatementAnalyzerFactory;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.TestingConnectorTransactionHandle;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.rewrite.StatementRewrite;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.CreateMaterializedView;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SelectItem;
import io.trino.sql.tree.StringLiteral;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingEventListenerManager;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.testng.Assert;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
public class TestCreateMaterializedViewTask {
    private static final String DEFAULT_MATERIALIZED_VIEW_FOO_PROPERTY_VALUE = null;
    private static final Integer DEFAULT_MATERIALIZED_VIEW_BAR_PROPERTY_VALUE = 123;
    private static final ConnectorTableMetadata MOCK_TABLE = new ConnectorTableMetadata(new SchemaTableName("schema", "mock_table"), List.of(new ColumnMetadata("a", (Type)SmallintType.SMALLINT), new ColumnMetadata("b", (Type)BigintType.BIGINT)), (Map)ImmutableMap.of((Object)"baz", (Object)"property_value"));
    private Session testSession;
    private MockMetadata metadata;
    private PlannerContext plannerContext;
    private TransactionManager transactionManager;
    private SqlParser parser;
    private QueryStateMachine queryStateMachine;
    private AnalyzerFactory analyzerFactory;
    private MaterializedViewPropertyManager materializedViewPropertyManager;
    private LocalQueryRunner queryRunner;
    private CatalogHandle testCatalogHandle;

    @BeforeEach
    public void setUp() {
        this.testSession = TestingSession.testSessionBuilder().setCatalog("test-catalog").build();
        this.queryRunner = LocalQueryRunner.create((Session)this.testSession);
        this.transactionManager = this.queryRunner.getTransactionManager();
        this.queryRunner.createCatalog("test-catalog", (ConnectorFactory)MockConnectorFactory.builder().withGetMaterializedViewProperties(() -> ImmutableList.builder().add((Object)PropertyMetadata.stringProperty((String)"foo", (String)"test materialized view property", (String)DEFAULT_MATERIALIZED_VIEW_FOO_PROPERTY_VALUE, (boolean)false)).add((Object)PropertyMetadata.integerProperty((String)"bar", (String)"test materialized view property", (Integer)DEFAULT_MATERIALIZED_VIEW_BAR_PROPERTY_VALUE, (boolean)false)).build()).build(), (Map)ImmutableMap.of());
        this.testCatalogHandle = this.queryRunner.getCatalogHandle("test-catalog");
        this.materializedViewPropertyManager = this.queryRunner.getMaterializedViewPropertyManager();
        this.metadata = new MockMetadata();
        this.plannerContext = TestingPlannerContext.plannerContextBuilder().withMetadata(this.metadata).build();
        this.parser = this.queryRunner.getSqlParser();
        this.analyzerFactory = new AnalyzerFactory(StatementAnalyzerFactory.createTestingStatementAnalyzerFactory((PlannerContext)this.plannerContext, (AccessControl)new AllowAllAccessControl(), (TablePropertyManager)this.queryRunner.getTablePropertyManager(), (AnalyzePropertyManager)this.queryRunner.getAnalyzePropertyManager()), new StatementRewrite((Set)ImmutableSet.of()), this.plannerContext.getTracer());
        this.queryStateMachine = this.stateMachine(this.transactionManager, MetadataManager.createTestMetadataManager(), (AccessControl)new AllowAllAccessControl());
    }

    @AfterEach
    public void tearDown() {
        if (this.queryRunner != null) {
            this.queryRunner.close();
        }
        this.testSession = null;
        this.metadata = null;
        this.plannerContext = null;
        this.transactionManager = null;
        this.parser = null;
        this.queryStateMachine = null;
        this.analyzerFactory = null;
        this.materializedViewPropertyManager = null;
        this.queryRunner = null;
    }

    @Test
    public void testCreateMaterializedViewIfNotExists() {
        CreateMaterializedView statement = new CreateMaterializedView(Optional.empty(), QualifiedName.of((String)"test_mv"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"test-catalog", (String[])new String[]{"schema", "mock_table"}))), false, true, Optional.empty(), (List)ImmutableList.of(), Optional.empty());
        MoreFutures.getFutureValue((Future)new CreateMaterializedViewTask(this.plannerContext, (AccessControl)new AllowAllAccessControl(), this.parser, this.analyzerFactory, this.materializedViewPropertyManager).execute(statement, this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP));
        Assert.assertEquals((int)this.metadata.getCreateMaterializedViewCallCount(), (int)1);
    }

    @Test
    public void testCreateMaterializedViewWithExistingView() {
        CreateMaterializedView statement = new CreateMaterializedView(Optional.empty(), QualifiedName.of((String)"test_mv"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"test-catalog", (String[])new String[]{"schema", "mock_table"}))), false, false, Optional.empty(), (List)ImmutableList.of(), Optional.empty());
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)new CreateMaterializedViewTask(this.plannerContext, (AccessControl)new AllowAllAccessControl(), this.parser, this.analyzerFactory, this.materializedViewPropertyManager).execute(statement, this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.ALREADY_EXISTS}).hasMessage("Materialized view already exists");
        Assert.assertEquals((int)this.metadata.getCreateMaterializedViewCallCount(), (int)1);
    }

    @Test
    public void testCreateMaterializedViewWithInvalidProperty() {
        CreateMaterializedView statement = new CreateMaterializedView(Optional.empty(), QualifiedName.of((String)"test_mv"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"test-catalog", (String[])new String[]{"schema", "mock_table"}))), false, true, Optional.empty(), (List)ImmutableList.of((Object)new Property(new Identifier("baz"), (Expression)new StringLiteral("abc"))), Optional.empty());
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)new CreateMaterializedViewTask(this.plannerContext, (AccessControl)new AllowAllAccessControl(), this.parser, this.analyzerFactory, this.materializedViewPropertyManager).execute(statement, this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_MATERIALIZED_VIEW_PROPERTY}).hasMessage("Catalog 'test-catalog' materialized view property 'baz' does not exist");
        Assert.assertEquals((int)this.metadata.getCreateMaterializedViewCallCount(), (int)0);
    }

    @Test
    public void testCreateMaterializedViewWithDefaultProperties() {
        QualifiedName materializedViewName = QualifiedName.of((String)"test-catalog", (String[])new String[]{"schema", "mv"});
        CreateMaterializedView statement = new CreateMaterializedView(Optional.empty(), materializedViewName, QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"test-catalog", (String[])new String[]{"schema", "mock_table"}))), false, true, Optional.empty(), (List)ImmutableList.of((Object)new Property(new Identifier("foo")), (Object)new Property(new Identifier("bar"))), Optional.empty());
        MoreFutures.getFutureValue((Future)new CreateMaterializedViewTask(this.plannerContext, (AccessControl)new AllowAllAccessControl(), this.parser, this.analyzerFactory, this.materializedViewPropertyManager).execute(statement, this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP));
        Optional<MaterializedViewDefinition> definitionOptional = this.metadata.getMaterializedView(this.testSession, QualifiedObjectName.valueOf((String)materializedViewName.toString()));
        Assertions.assertThat(definitionOptional).isPresent();
        Map properties = definitionOptional.get().getProperties();
        Assertions.assertThat(properties.get("foo")).isEqualTo((Object)DEFAULT_MATERIALIZED_VIEW_FOO_PROPERTY_VALUE);
        Assertions.assertThat(properties.get("bar")).isEqualTo((Object)DEFAULT_MATERIALIZED_VIEW_BAR_PROPERTY_VALUE);
    }

    @Test
    public void testCreateDenyPermission() {
        CreateMaterializedView statement = new CreateMaterializedView(Optional.empty(), QualifiedName.of((String)"test_mv"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"test-catalog", (String[])new String[]{"schema", "mock_table"}))), false, true, Optional.empty(), (List)ImmutableList.of(), Optional.empty());
        TestingAccessControlManager accessControl = new TestingAccessControlManager(this.transactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager());
        accessControl.loadSystemAccessControl("allow-all", (Map)ImmutableMap.of());
        accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"test_mv", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_MATERIALIZED_VIEW)});
        StatementAnalyzerFactory statementAnalyzerFactory = StatementAnalyzerFactory.createTestingStatementAnalyzerFactory((PlannerContext)this.plannerContext, (AccessControl)accessControl, (TablePropertyManager)new TablePropertyManager(CatalogServiceProvider.fail()), (AnalyzePropertyManager)new AnalyzePropertyManager(CatalogServiceProvider.fail()));
        AnalyzerFactory analyzerFactory = new AnalyzerFactory(statementAnalyzerFactory, new StatementRewrite((Set)ImmutableSet.of()), this.plannerContext.getTracer());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MoreFutures.getFutureValue((Future)new CreateMaterializedViewTask(this.plannerContext, (AccessControl)accessControl, this.parser, analyzerFactory, this.materializedViewPropertyManager).execute(statement, this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP))).isInstanceOf(AccessDeniedException.class)).hasMessageContaining("Cannot create materialized view test-catalog.schema.test_mv");
    }

    private QueryStateMachine stateMachine(TransactionManager transactionManager, MetadataManager metadata, AccessControl accessControl) {
        return QueryStateMachine.begin(Optional.empty(), (String)"test", Optional.empty(), (Session)this.testSession, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)transactionManager, (AccessControl)accessControl, (Executor)MoreExecutors.directExecutor(), (Metadata)metadata, (WarningCollector)WarningCollector.NOOP, (PlanOptimizersStatsCollector)PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector(), Optional.empty(), (boolean)true, (NodeVersion)new NodeVersion("test"));
    }

    private class MockMetadata
    extends AbstractMockMetadata {
        private final Map<SchemaTableName, MaterializedViewDefinition> materializedViews = new ConcurrentHashMap<SchemaTableName, MaterializedViewDefinition>();

        private MockMetadata() {
        }

        @Override
        public void createMaterializedView(Session session, QualifiedObjectName viewName, MaterializedViewDefinition definition, boolean replace, boolean ignoreExisting) {
            this.materializedViews.put(viewName.asSchemaTableName(), definition);
            if (!ignoreExisting) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Materialized view already exists");
            }
        }

        @Override
        public Optional<CatalogHandle> getCatalogHandle(Session session, String catalogName) {
            if ("test-catalog".equals(catalogName)) {
                return Optional.of(TestCreateMaterializedViewTask.this.testCatalogHandle);
            }
            return Optional.empty();
        }

        @Override
        public TableSchema getTableSchema(Session session, TableHandle tableHandle) {
            return new TableSchema("test-catalog", MOCK_TABLE.getTableSchema());
        }

        @Override
        public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName tableName) {
            if (tableName.asSchemaTableName().equals((Object)MOCK_TABLE.getTable())) {
                return Optional.of(new TableHandle(TestCreateMaterializedViewTask.this.testCatalogHandle, (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(tableName.asSchemaTableName()), (ConnectorTransactionHandle)TestingConnectorTransactionHandle.INSTANCE));
            }
            return Optional.empty();
        }

        @Override
        public Map<String, ColumnHandle> getColumnHandles(Session session, TableHandle tableHandle) {
            return (Map)MOCK_TABLE.getColumns().stream().collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, column -> new TestingColumnHandle(column.getName())));
        }

        @Override
        public TableMetadata getTableMetadata(Session session, TableHandle tableHandle) {
            if (tableHandle.getConnectorHandle() instanceof TestingMetadata.TestingTableHandle && ((TestingMetadata.TestingTableHandle)tableHandle.getConnectorHandle()).getTableName().equals((Object)MOCK_TABLE.getTable())) {
                return new TableMetadata("test-catalog", MOCK_TABLE);
            }
            return super.getTableMetadata(session, tableHandle);
        }

        @Override
        public Optional<MaterializedViewDefinition> getMaterializedView(Session session, QualifiedObjectName viewName) {
            return Optional.ofNullable(this.materializedViews.get(viewName.asSchemaTableName()));
        }

        @Override
        public Optional<ViewDefinition> getView(Session session, QualifiedObjectName viewName) {
            return Optional.empty();
        }

        public int getCreateMaterializedViewCallCount() {
            return this.materializedViews.size();
        }
    }
}

