/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.execution.QueryPreparer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.QueryUtil;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SelectItem;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestQueryPreparer {
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final QueryPreparer QUERY_PREPARER = new QueryPreparer(SQL_PARSER);

    @Test
    public void testSelectStatement() {
        QueryPreparer.PreparedQuery preparedQuery = QUERY_PREPARER.prepareQuery(SessionTestUtils.TEST_SESSION, "SELECT * FROM foo");
        Assert.assertEquals((Object)preparedQuery.getStatement(), (Object)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo"))));
    }

    @Test
    public void testExecuteStatement() {
        Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT * FROM foo").build();
        QueryPreparer.PreparedQuery preparedQuery = QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query");
        Assert.assertEquals((Object)preparedQuery.getStatement(), (Object)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo"))));
    }

    @Test
    public void testExecuteImmediateStatement() {
        QueryPreparer.PreparedQuery preparedQuery = QUERY_PREPARER.prepareQuery(SessionTestUtils.TEST_SESSION, "EXECUTE IMMEDIATE 'SELECT * FROM foo'");
        Assert.assertEquals((Object)preparedQuery.getStatement(), (Object)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo"))));
    }

    @Test
    public void testExecuteStatementDoesNotExist() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(SessionTestUtils.TEST_SESSION, "execute my_query")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_FOUND});
    }

    @Test
    public void testExecuteImmediateInvalidStatement() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> QUERY_PREPARER.prepareQuery(SessionTestUtils.TEST_SESSION, "EXECUTE IMMEDIATE 'SELECT FROM'")).isInstanceOf(ParsingException.class)).hasMessageMatching("line 1:27: mismatched input 'FROM'. Expecting: .*");
    }

    @Test
    public void testExecuteImmediateInvalidMultilineStatement() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> QUERY_PREPARER.prepareQuery(SessionTestUtils.TEST_SESSION, "EXECUTE\nIMMEDIATE 'SELECT\n FROM'")).isInstanceOf(ParsingException.class)).hasMessageMatching("line 3:2: mismatched input 'FROM'. Expecting: .*");
    }

    @Test
    public void testTooManyParameters() {
        Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT * FROM foo where col1 = ?").build();
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query USING 1,2")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(SessionTestUtils.TEST_SESSION, "EXECUTE IMMEDIATE 'SELECT * FROM foo where col1 = ?' USING 1,2")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE});
    }

    @Test
    public void testTooFewParameters() {
        Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT ? FROM foo where col1 = ?").build();
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query USING 1")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(SessionTestUtils.TEST_SESSION, "EXECUTE IMMEDIATE 'SELECT ? FROM foo where col1 = ?' USING 1")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE});
    }

    @Test
    public void testParameterMismatchWithOffset() {
        Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT ? FROM foo OFFSET ? ROWS").build();
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query USING 1")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(SessionTestUtils.TEST_SESSION, "EXECUTE IMMEDIATE 'SELECT ? FROM foo OFFSET ? ROWS' USING 1")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query USING 1, 2, 3, 4, 5, 6")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(SessionTestUtils.TEST_SESSION, "EXECUTE IMMEDIATE 'SELECT ? FROM foo OFFSET ? ROWS' USING 1, 2, 3, 4, 5, 6")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE});
    }

    @Test
    public void testParameterMismatchWithLimit() {
        Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT ? FROM foo LIMIT ?").build();
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query USING 1")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(SessionTestUtils.TEST_SESSION, "EXECUTE IMMEDIATE 'SELECT ? FROM foo LIMIT ?' USING 1")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query USING 1, 2, 3, 4, 5, 6")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(SessionTestUtils.TEST_SESSION, "EXECUTE IMMEDIATE 'SELECT ? FROM foo LIMIT ?' USING 1, 2, 3, 4, 5, 6")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE});
    }

    @Test
    public void testParameterMismatchWithFetchFirst() {
        Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT ? FROM foo FETCH FIRST ? ROWS ONLY").build();
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query USING 1")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(SessionTestUtils.TEST_SESSION, "EXECUTE IMMEDIATE 'SELECT ? FROM foo FETCH FIRST ? ROWS ONLY' USING 1")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query USING 1, 2, 3, 4, 5, 6")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(SessionTestUtils.TEST_SESSION, "EXECUTE IMMEDIATE 'SELECT ? FROM foo FETCH FIRST ? ROWS ONLY' USING 1, 2, 3, 4, 5, 6")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE});
    }
}

