/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.airlift.tracing.Tracing;
import io.opentelemetry.api.trace.Span;
import io.trino.cost.StatsAndCosts;
import io.trino.execution.ExecutionFailureInfo;
import io.trino.execution.StageId;
import io.trino.execution.StageInfo;
import io.trino.execution.StageState;
import io.trino.execution.StageStateMachine;
import io.trino.execution.scheduler.SplitSchedulerStats;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.StringLiteral;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.testng.Assert;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestStageStateMachine {
    private static final StageId STAGE_ID = new StageId("query", 0);
    private static final PlanFragment PLAN_FRAGMENT = TestStageStateMachine.createValuesPlan();
    private static final SQLException FAILED_CAUSE = new SQLException("FAILED");
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
    }

    @Test
    public void testBasicStateChanges() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        TestStageStateMachine.assertState(stateMachine, StageState.PLANNED);
        Assert.assertTrue((boolean)stateMachine.transitionToScheduling());
        TestStageStateMachine.assertState(stateMachine, StageState.SCHEDULING);
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        Assert.assertTrue((boolean)stateMachine.transitionToPending());
        TestStageStateMachine.assertState(stateMachine, StageState.PENDING);
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        Assert.assertTrue((boolean)stateMachine.transitionToFinished());
        TestStageStateMachine.assertState(stateMachine, StageState.FINISHED);
    }

    @Test
    public void testPlanned() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        TestStageStateMachine.assertState(stateMachine, StageState.PLANNED);
        stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToScheduling());
        TestStageStateMachine.assertState(stateMachine, StageState.SCHEDULING);
        stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToFinished());
        TestStageStateMachine.assertState(stateMachine, StageState.FINISHED);
        stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestStageStateMachine.assertState(stateMachine, StageState.FAILED);
    }

    @Test
    public void testScheduling() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToScheduling());
        TestStageStateMachine.assertState(stateMachine, StageState.SCHEDULING);
        Assert.assertFalse((boolean)stateMachine.transitionToScheduling());
        TestStageStateMachine.assertState(stateMachine, StageState.SCHEDULING);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduling();
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduling();
        Assert.assertTrue((boolean)stateMachine.transitionToFinished());
        TestStageStateMachine.assertState(stateMachine, StageState.FINISHED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduling();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestStageStateMachine.assertState(stateMachine, StageState.FAILED);
    }

    @Test
    public void testRunning() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        Assert.assertFalse((boolean)stateMachine.transitionToScheduling());
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        Assert.assertFalse((boolean)stateMachine.transitionToRunning());
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        Assert.assertTrue((boolean)stateMachine.transitionToPending());
        TestStageStateMachine.assertState(stateMachine, StageState.PENDING);
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToRunning();
        Assert.assertTrue((boolean)stateMachine.transitionToFinished());
        TestStageStateMachine.assertState(stateMachine, StageState.FINISHED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToRunning();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestStageStateMachine.assertState(stateMachine, StageState.FAILED);
    }

    @Test
    public void testFinished() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToFinished());
        TestStageStateMachine.assertFinalState(stateMachine, StageState.FINISHED);
    }

    @Test
    public void testFailed() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestStageStateMachine.assertFinalState(stateMachine, StageState.FAILED);
    }

    private static void assertFinalState(StageStateMachine stateMachine, StageState expectedState) {
        Assert.assertTrue((boolean)expectedState.isDone());
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assert.assertFalse((boolean)stateMachine.transitionToScheduling());
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assert.assertFalse((boolean)stateMachine.transitionToPending());
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assert.assertFalse((boolean)stateMachine.transitionToRunning());
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assert.assertFalse((boolean)stateMachine.transitionToFinished());
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assert.assertFalse((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assert.assertFalse((boolean)stateMachine.transitionToFailed((Throwable)new IOException("failure after finish")));
        TestStageStateMachine.assertState(stateMachine, expectedState);
    }

    private static void assertState(StageStateMachine stateMachine, StageState expectedState) {
        Assert.assertEquals((Object)stateMachine.getStageId(), (Object)STAGE_ID);
        StageInfo stageInfo = stateMachine.getStageInfo(ImmutableList::of);
        Assert.assertEquals((Object)stageInfo.getStageId(), (Object)STAGE_ID);
        Assert.assertEquals((Collection)stageInfo.getSubStages(), (Collection)ImmutableList.of());
        Assert.assertEquals((Collection)stageInfo.getTasks(), (Collection)ImmutableList.of());
        Assert.assertEquals((Collection)stageInfo.getTypes(), (Collection)ImmutableList.of((Object)VarcharType.VARCHAR));
        Assert.assertSame((Object)stageInfo.getPlan(), (Object)PLAN_FRAGMENT);
        Assert.assertEquals((Object)stateMachine.getState(), (Object)expectedState);
        Assert.assertEquals((Object)stageInfo.getState(), (Object)expectedState);
        if (expectedState == StageState.FAILED) {
            ExecutionFailureInfo failure = stageInfo.getFailureCause();
            Assert.assertEquals((String)failure.getMessage(), (String)FAILED_CAUSE.getMessage());
            Assert.assertEquals((String)failure.getType(), (String)FAILED_CAUSE.getClass().getName());
        } else {
            Assert.assertNull((Object)stageInfo.getFailureCause());
        }
    }

    private StageStateMachine createStageStateMachine() {
        return new StageStateMachine(STAGE_ID, PLAN_FRAGMENT, (Map)ImmutableMap.of(), (Executor)this.executor, Tracing.noopTracer(), Span.getInvalid(), new SplitSchedulerStats());
    }

    private static PlanFragment createValuesPlan() {
        Symbol symbol = new Symbol("column");
        PlanNodeId valuesNodeId = new PlanNodeId("plan");
        PlanFragment planFragment = new PlanFragment(new PlanFragmentId("plan"), (PlanNode)new ValuesNode(valuesNodeId, (List)ImmutableList.of((Object)symbol), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new StringLiteral("foo"))))), (Map)ImmutableMap.of((Object)symbol, (Object)VarcharType.VARCHAR), SystemPartitioningHandle.SOURCE_DISTRIBUTION, Optional.empty(), (List)ImmutableList.of((Object)valuesNodeId), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)symbol)), StatsAndCosts.empty(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty());
        return planFragment;
    }

    static {
        FAILED_CAUSE.setStackTrace(new StackTraceElement[0]);
    }
}

