/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import io.trino.operator.Operator;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.OperatorContext;
import io.trino.operator.TestingOperatorContext;
import io.trino.spi.Page;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestOperatorAssertion {
    private ScheduledExecutorService executor;

    @BeforeAll
    public void setUp() {
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testToPagesWithBlockedOperator() {
        BlockedOperator operator = new BlockedOperator(new Duration(15.0, TimeUnit.MILLISECONDS));
        List<Page> pages = OperatorAssertion.toPages(operator, Collections.emptyIterator());
        Assertions.assertThat(pages).isEmpty();
    }

    private class BlockedOperator
    implements Operator {
        private final Duration unblockAfter;
        private final OperatorContext operatorContext;
        private ListenableFuture<Void> isBlocked = NOT_BLOCKED;

        public BlockedOperator(Duration unblockAfter) {
            this.unblockAfter = Objects.requireNonNull(unblockAfter, "unblockAfter is null");
            this.operatorContext = TestingOperatorContext.create(TestOperatorAssertion.this.executor);
        }

        public OperatorContext getOperatorContext() {
            return this.operatorContext;
        }

        public ListenableFuture<Void> isBlocked() {
            return this.isBlocked;
        }

        public boolean needsInput() {
            return false;
        }

        public void addInput(Page page) {
            throw new UnsupportedOperationException();
        }

        public void finish() {
            if (this.isBlocked == NOT_BLOCKED) {
                this.isBlocked = Futures.scheduleAsync(Futures::immediateVoidFuture, (long)this.unblockAfter.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS, (ScheduledExecutorService)TestOperatorAssertion.this.executor);
            }
        }

        public boolean isFinished() {
            return this.isBlocked != NOT_BLOCKED && this.isBlocked.isDone();
        }

        public Page getOutput() {
            return null;
        }
    }
}

