/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.block.BlockAssertions;
import io.trino.operator.PageUtils;
import io.trino.spi.Page;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.ValueBlock;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestPageUtils {
    @Test
    public void testRecordMaterializedBytes() {
        ValueBlock first = BlockAssertions.createIntsBlock(1, 2, 3);
        LazyBlock second = TestPageUtils.lazyWrapper((Block)first);
        LazyBlock third = TestPageUtils.lazyWrapper((Block)first);
        Page page = new Page(3, new Block[]{first, second, third});
        second.getLoadedBlock();
        AtomicLong sizeInBytes = new AtomicLong();
        PageUtils.recordMaterializedBytes((Page)page, sizeInBytes::getAndAdd);
        Assert.assertEquals((long)sizeInBytes.get(), (long)(first.getSizeInBytes() * 2L));
        page.getBlock(2).getLoadedBlock();
        Assert.assertEquals((long)sizeInBytes.get(), (long)(first.getSizeInBytes() * 3L));
    }

    @Test
    public void testNestedBlocks() {
        LazyBlock elements = TestPageUtils.lazyWrapper((Block)BlockAssertions.createIntsBlock(1, 2, 3));
        ArrayBlock arrayBlock = ArrayBlock.fromElementBlock((int)2, Optional.empty(), (int[])new int[]{0, 1, 3}, (Block)elements);
        long initialArraySize = arrayBlock.getSizeInBytes();
        Page page = new Page(2, new Block[]{arrayBlock});
        AtomicLong sizeInBytes = new AtomicLong();
        PageUtils.recordMaterializedBytes((Page)page, sizeInBytes::getAndAdd);
        Assert.assertEquals((long)arrayBlock.getSizeInBytes(), (long)initialArraySize);
        Assert.assertEquals((long)sizeInBytes.get(), (long)arrayBlock.getSizeInBytes());
        arrayBlock.getLoadedBlock();
        Assert.assertEquals((long)sizeInBytes.get(), (long)arrayBlock.getSizeInBytes());
        Assert.assertEquals((long)sizeInBytes.get(), (long)(initialArraySize + elements.getSizeInBytes()));
    }

    private static LazyBlock lazyWrapper(Block block) {
        return new LazyBlock(block.getPositionCount(), () -> ((Block)block).getLoadedBlock());
    }
}

